*** Settings ***
Resource    environment/variables.txt 
Resource    NSFMOperationKeywords.robot
Resource    ../../instrumentationPlatformHooks/InstrumentationPlatformHooksKeywords.robot

Library    MockServerLibrary
Library    Process
Library    OperatingSystem
Library    Collections
Library    REST     ${NFVO_SCHEMA}://${NFVO_HOST}:${NFVO_PORT}    ssl_verify=false

Suite Setup    Create Sessions
Suite Teardown    Terminate All Processes    kill=true

*** Test Cases ***
NS Fault Alarm Notification
    [Documentation]    Test ID: 5.3.3.5.1
    ...    Test title: NS Fault Alarm Notification
    ...    Test objective: The objective is to test the dispatch of NS Fault Alarm Notification when a virtualised resource within an NS instance fails, and perform a JSON schema and content validation of the delivered notification. The action that triggers the notification under test is an explicit test step, but it is not performed by the test system.
    ...    Pre-conditions: A NS instance is instantiated, and a subscription for fault alarm notifications is available in the NFVO.
    ...    Reference: Clause 8.4.6.3.1 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none 
    Trigger the fault of a virtualised resource in the NS instance (external action) 
    Check Alarm Notification Http POST Request Body Json Schema Is    alarmNotification
    Check Alarm Notification Http POST Request Body notificationType attribute Is    alarmNotification

NS Fault Alarm Cleared Notification
    [Documentation]    Test ID: 5.3.3.5.2
    ...    Test title: NS Fault Alarm Cleared Notification
    ...    Test objective: The objective is to test the dispatch of NS Fault Alarm Cleared Notification when a faulty virtualised resource within an NS instance is cleared, and perform a JSON schema and content validation of the delivered notification. The action that triggers the notification under test is an explicit test step, but it is not performed by the test system.
    ...    Pre-conditions: A NS instance is instantiated, a virtualised resource is in faulty state, and a subscription for fault alarm cleared notifications is available in the NFVO.
    ...    Reference: Clause 8.4.6.3.1 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none 
    Trigger the fault cleared of a virtualised resource in the NS instance (external action) 
    Check Alarm cleared Notification Http POST Request Body Json Schema Is    alarmClearedNotification
    Check Alarm cleared Notification Http POST Request Body notificationType attribute Is    alarmClearedNotification

NS Fault Alarm List Rebuilt Notification 
    [Documentation]    Test ID: 5.3.3.5.3
    ...    Test title: NS Fault Alarm List Rebuilt Notification 
    ...    Test objective: The objective is to test the dispatch of NS Fault Alarm List Rebuilt Notification when the NFVO decides to rebuild the list of its NS alarms, e.g. due to a corruption in the alarm storage, and perform a JSON schema and content validation of the delivered notification. The action that triggers the notification under test is an explicit test step, but it is not performed by the test system.
    ...    Pre-conditions: A NS instance is instantiated, one or more virtualised resource are in faulty state, and a subscription for fault alarm list rebuilt notifications is available in the NFVO.
    ...    Reference: Clause 8.4.6.3.1 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none 
    Trigger the NS fault alarm list rebuild in the NFVO (external action) 
    Check Alarm list rebuilt Notification Http POST Request Body Json Schema Is    alarmListRebuiltNotification
    Check Alarm list rebuilt Notification Http POST Request Body notificationType attribute Is    alarmListRebuiltNotification

NS Fault Alarm Notification with Instrumental Platform Hook
    [Documentation]    Test ID: 5.3.3.5.4
    ...    Test title: NS Fault Alarm Notification with Instrumental Platform Hook
    ...    Test objective: The objective is to test the dispatch of NS Fault Alarm Notification when a virtualised resource failure within an NS instance is automatically triggered through an instrumenation platform, and perform a JSON schema and content validation of the delivered notification.
    ...    Pre-conditions: A NS instance is instantiated
    ...    Reference: Clause 8.4.6.3.1 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: An instrumentation platform is available to trigger the NS instance failure condition
    ...    Post-Conditions: none 
    Trigger the fault of a virtualised resource in the NS instance
    Check Instrumentation Platform Alarm Notification Http POST Request Body Json Schema Is    alarmNotification
    Check Instrumentation Platform Alarm Notification Http POST Request Body notificationType attribute Is    alarmNotification

NS Fault Alarm Cleared Notification with Instrumental Platform Hook
    [Documentation]    Test ID: 5.3.3.5.5
    ...    Test title: NS Fault Alarm Cleared Notification with Instrumental Platform Hook
    ...    Test objective: The objective is to test the dispatch of NS Fault Clear Alarm Notification when a virtualised resource failure within an NS instance is automatically cleared through an instrumenation platform, and perform a JSON schema and content validation of the delivered notification.
    ...    Pre-conditions: A NS instance is instantiated and a virtualised resource is in faulty state.
    ...    Reference: Clause 8.4.6.3.1 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: An instrumentation platform is available to trigger the NS instance failure clear condition
    ...    Post-Conditions: none 
    Trigger the fault cleared of a virtualised resource in the NS instance
    Check Instrumentation Platform Alarm Cleared Notification Http POST Request Body Json Schema Is    alarmClearedNotification
    Check Instrumentation Platform Alarm Cleared Notification Http POST Request Body notificationType attribute Is    alarmClearedNotification

NS Fault Alarm List Rebuilt Notification with Instrumental Platform Hook
    [Documentation]    Test ID: 5.3.3.5.6
    ...    Test title: NS Fault Alarm List Rebuilt Notification with Instrumental Platform Hook
    ...    Test objective: The objective is to test the dispatch of NS Fault Alarm List Rebuilt Notification when the NFVO decision to rebuild the list of its NS alarms is automatically triggered through an instrumentation platform, and perform a JSON schema and content validation of the delivered notification.
    ...    Pre-conditions: A NS instance is instantiated and one or more virtualised resource are in faulty state
    ...    Reference: Clause 8.4.6.3.1 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: An instrumentation platform is available to trigger the NS instance alarm list rebuilt condition
    ...    Post-Conditions: none 
    Trigger the NS fault alarm list rebuild in the NFVO
    Check Instrumentation Platform Alarm List Rebuilt Notification Http POST Request Body Json Schema Is    alarmListRebuiltNotification
    Check Instrumentation Platform Alarm List Rebuilt Notification Http POST Request Body notificationType attribute Is    alarmListRebuiltNotification

*** Keywords ***
Trigger the fault of a virtualised resource in the NS instance
    Pass Execution If   ${instrumentationPlatformSkip}  Skip Test step -- Instrumentation platform not supported 
    Create Alarm Subscription    AlarmNotification
    &{keyvalues}    Create Dictionary    eventType=COMMUNICATIONS_ALARM    delay=10s
    Trigger instrumentation platform    ${upperTesterUrlForAlarmNotifications}    ${nsInstanceIdForNotifications}    nsInstance    AlarmNotification    null    &{keyvalues}

Trigger the fault cleared of a virtualised resource in the NS instance
    Pass Execution If   ${instrumentationPlatformSkip}  Skip Test step -- Instrumentation platform not supported 
    Create Alarm Subscription    AlarmClearedNotification
    &{keyvalues}    Create Dictionary    eventType=COMMUNICATIONS_ALARM    delay=10s
    Trigger instrumentation platform    ${upperTesterUrlForAlarmNotifications}    ${nsInstanceIdForNotifications}    nsInstance    AlarmClearedNotification    null    &{keyvalues}

Trigger the NS fault alarm list rebuild in the NFVO
    Pass Execution If   ${instrumentationPlatformSkip}  Skip Test step -- Instrumentation platform not supported 
    Create Alarm Subscription    AlarmListRebuiltNotification
    &{keyvalues}    Create Dictionary    eventType=COMMUNICATIONS_ALARM    delay=10s
    Trigger instrumentation platform    ${upperTesterUrlForAlarmNotifications}    ${nsInstanceIdForNotifications}    nsInstance    AlarmListRebuiltNotification    null    &{keyvalues}

Trigger the fault of a virtualised resource in the NS instance (external action)  
    #do nothing
    Log    do nothing

Trigger the fault cleared of a virtualised resource in the NS instance (external action) 
    #do nothing
    Log    do nothing   

Trigger the NS fault alarm list rebuild in the NFVO (external action) 
    #do nothing
    Log    do nothing 

Check Alarm List Rebuilt Notification Http POST Request Body Json Schema Is    
    [Arguments]    ${element}
    ${schema}=	Get File	schemas/${element}.schema.json
    Configure Notification Forward    ${schema}    ${callback_endpoint}    ${callback_endpoint_fwd}

Check Alarm List Rebuilt Notification Http POST Request Body notificationType attribute Is
    [Arguments]    ${type}
    Configure Notification Alarm List Rebuilt Handler    ${callback_endpoint_fwd}    ${type}
    Wait Until Keyword Succeeds    2 min   10 sec   Verify Mock Expectation    ${notification_request}
    Clear Requests    ${callback_endpoint}
    Clear Requests    ${callback_endpoint_fwd}
    
Check Instrumentation Platform Alarm List Rebuilt Notification Http POST Request Body Json Schema Is
    [Arguments]    ${element}
    Pass Execution If   ${instrumentationPlatformSkip}  Skip Test step -- Instrumentation platform not supported 
    Check Alarm List Rebuilt Notification Http POST Request Body Json Schema Is   ${element}

Check Instrumentation Platform Alarm List Rebuilt Notification Http POST Request Body notificationType attribute Is
    [Arguments]    ${type}
    Pass Execution If   ${instrumentationPlatformSkip}  Skip Test step -- Instrumentation platform not supported 
    Check Alarm List Rebuilt Notification Http POST Request Body notificationType attribute Is   ${type}

Check Alarm Notification Http POST Request Body Json Schema Is    
    [Arguments]    ${element}
    ${schema}=	Get File	schemas/${element}.schema.json
    Configure Notification Forward    ${schema}    ${callback_endpoint}    ${callback_endpoint_fwd}

Check Instrumentation Platform Alarm Notification Http POST Request Body Json Schema Is
    [Arguments]    ${element}
    Pass Execution If   ${instrumentationPlatformSkip}  Skip Test step -- Instrumentation platform not supported 
    Check Alarm Notification Http POST Request Body Json Schema Is   ${element}

Check Alarm Notification Http POST Request Body notificationType attribute Is
    [Arguments]    ${type}
    Configure Notification Alarm Handler    ${callback_endpoint_fwd}    ${type}
    Wait Until Keyword Succeeds    2 min   10 sec   Verify Mock Expectation    ${notification_request}
    Clear Requests    ${callback_endpoint}
    Clear Requests    ${callback_endpoint_fwd}

Check Instrumentation Platform Alarm Notification Http POST Request Body notificationType attribute Is
    [Arguments]    ${type}
    Pass Execution If   ${instrumentationPlatformSkip}  Skip Test step -- Instrumentation platform not supported 
    Check Alarm Notification Http POST Request Body notificationType attribute Is   ${type}

Check Alarm cleared Notification Http POST Request Body Json Schema Is    
    [Arguments]    ${element}
    ${schema}=	Get File	schemas/${element}.schema.json
    Configure Notification Forward    ${schema}    ${callback_endpoint}    ${callback_endpoint_fwd}
    
Check Instrumentation Platform Alarm Cleared Notification Http POST Request Body Json Schema Is
    [Arguments]    ${element}
    Pass Execution If   ${instrumentationPlatformSkip}  Skip Test step -- Instrumentation platform not supported 
    Check Alarm cleared Notification Http POST Request Body Json Schema Is   ${element}

Check Instrumentation Platform Alarm Cleared Notification Http POST Request Body notificationType attribute Is
    [Arguments]    ${type}
    Pass Execution If   ${instrumentationPlatformSkip}  Skip Test step -- Instrumentation platform not supported 
    Check Alarm cleared Notification Http POST Request Body notificationType attribute Is   ${type}

Check Alarm cleared Notification Http POST Request Body notificationType attribute Is
    [Arguments]    ${type}
    Configure Notification Alarm Cleareance Handler    ${callback_endpoint_fwd}    ${type}
    Wait Until Keyword Succeeds    2 min   10 sec   Verify Mock Expectation    ${notification_request}
    Clear Requests    ${callback_endpoint}
    Clear Requests    ${callback_endpoint_fwd}

Configure Notification Alarm List Rebuilt Handler
    [Arguments]    ${endpoint}    ${type}
    ${json}=    evaluate    {}
    set to dictionary    ${json}    notificationType    ${type}    
    ${BODY}=    evaluate    json.dumps(${json})    json
    Log  Creating mock request and response to handle status notification
    &{req}=  Create Mock Request Matcher	POST  ${endpoint}  body_type="JSON"    body=${BODY}
    Set Global Variable    ${notification_request}    ${req}    
    &{headers} =	Create Dictionary	Content-Type=application/json
    &{notification_response}=  Create Mock Response	 headers=${headers}  status_code=204
    Create Mock Expectation  ${notification_request}  ${notification_response}

Configure Notification Alarm Handler
    [Arguments]    ${endpoint}    ${type}
    ${json}=    evaluate    {}
    set to dictionary    ${json}    notificationType    ${type}    
    ${BODY}=    evaluate    json.dumps(${json})    json
    Log  Creating mock request and response to handle status notification
    &{req}=  Create Mock Request Matcher	POST  ${endpoint}  body_type="JSON"    body=${BODY}
    Set Global Variable    ${notification_request}    ${req}    
    &{headers} =	Create Dictionary	Content-Type=application/json
    &{notification_response}=  Create Mock Response	    headers=${headers}      status_code=204
    Create Mock Expectation  ${notification_request}  ${notification_response}

Configure Notification Alarm Cleareance Handler
    [Arguments]    ${endpoint}    ${type}
    ${json}=    evaluate    {}
    set to dictionary   ${json}    notificationType    ${type}
    ${BODY}=    evaluate    json.dumps(${json})    json
    Log  Creating mock request and response to handle status notification
    &{req}=  Create Mock Request Matcher	POST  ${endpoint}  body_type="JSON"    body=${BODY}
    Set Global Variable    ${notification_request}    ${req}    
    &{headers} =	Create Dictionary	Content-Type=application/json
    &{notification_response}=  Create Mock Response	  headers=${headers}  status_code=204
    Create Mock Expectation  ${notification_request}  ${notification_response}
  
Configure Notification Forward
    [Arguments]    ${schema}    ${endpoint}    ${endpoint_fwd}    
    Log  Creating mock Http POST forward to handle ${schema}
    &{notification_tmp}=  Create Mock Request Matcher	POST  ${endpoint}  body_type="JSON_SCHEMA"    body=${schema}
    &{notification_fwd}=  Create Mock Http Forward	${endpoint_fwd}
    Create Mock Expectation With Http Forward  ${notification_tmp}  ${notification_fwd}
    
Create Alarm Subscription
    [Arguments]    ${notificationType}
    Log    Create subscription instance by POST to ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/fmSubscriptionRequestForInstrumentationPlatform.json
    ${body}=        Format String   ${template}     callback_uri=${callback_uri}:${callback_port}    callback_endpoint=${callback_endpoint}    nsInstanceId=${nsInstanceIdForNotifications}    notificationType=${notificationType}
    Log  Creating mock request and response to handle GET operation on notification endpoint
    &{notification_request}=  Create Mock Request Matcher	GET  ${callback_endpoint}
    &{notification_response}=  Create Mock Response	status_code=204
    Log    Issue the subscription request
    #Create Mock Expectation  ${notification_request}  ${notification_response}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions    ${body}    
    ${output}=    Output    response
    Set Global Variable    ${response}    ${output}
    Clear Requests    ${callback_endpoint}
	