*** Settings ***
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt    # Generic Parameters
Resource          NSDManagementKeywords.robot
Library           JSONLibrary
Library           REST    ${NFVO_SCHEMA}://${NFVO_HOST}:${NFVO_PORT}    ssl_verify=false
Library           OperatingSystem

*** Test Cases ***
GET Individual PNFD Archive Artifact
    [Documentation]    Test ID: 5.3.1.17.1
    ...    Test title: GET Individual PNFD Archive Artifact
    ...    Test objective: The objective is to test the retrieval of an individual PNFD Archive artifact
    ...    Pre-conditions: One or more PNFD archives are on-boarded in the NFVO.
    ...    Reference: Clause 5.4.7c.3.2 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Individual PNFD Archive Artifact
    Check HTTP Response Status Code Is    200
    
GET Individual PNFD Archive Artifact with include_signatures parameter
    [Documentation]    Test ID: 5.3.1.17.2
    ...    Test title: GET Individual PNFD Archive Artifact with include_signatures parameter
    ...    Test objective: The objective is to test that the GET request read the whole content of the archive containing the artifact files successfully and also contain security certificates when requested with "include_signature" parameter, and perform a validation that returned content is in Zip format
    ...    Pre-conditions: One or more PNFD archives are on-boarded to the NFVO.
    ...    Reference: Clause 5.4.7c.3.2 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Individual PNFD Archive Artifact with include_signatures parameter
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Content-Type Is    application/zip
    
GET Individual PNFD Archive Artifact in octet stream format
    [Documentation]    Test ID: 5.3.1.17.3
    ...    Test title: GET Individual PNFD Archive Artifact in octet stream format
    ...    Test objective: The objective is to test the retrieval of an individual PNFD Archive artifact when the NFVO cannot determine the artifact content type. The test performs a validation that the returned artifcat in is octet-stream format. 
    ...    Pre-conditions: One or more PNFD archives are on-boarded to the NFVO.
    ...    Reference: Clause 5.4.7c.3.2 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: The NFVO cannot determine the content type of the artifact
    ...    Post-Conditions: none
    GET Individual PNFD Archive Artifact in octet stream format
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Content-Type Is    application/octet-stream

GET Individual PNFD Archive Artifact with Range Request and NFVO supporting Range Requests
    [Documentation]    Test ID: 5.3.1.17.4
    ...    Test title: GET Individual PNFD Archive Artifact with Range Request and NFVO supporting Range Requests
    ...    Test objective: The objective is to test the retrieval of an individual PNFD Archive artifact when using a range request to return single range of bytes from the file, with the NFVO supporting it. The test also perform a validation that returned content matches the issued range
    ...    Pre-conditions: One or more PNFD archives are on-boarded in the NFVO.
    ...    Reference: Clause 5.4.7c.3.2 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: The NFVO supports range requests to return single range of bytes from the PNFD Archive artifact
    ...    Post-Conditions: none
    GET Individual PNFD Archive Artifact with Range Request
    Check HTTP Response Status Code Is    206
    Check HTTP Response Header Content-Range Is Present and Matches the requested range
    Check HTTP Response Header Content-Length Is Present and Matches the requested range length
    
GET Individual PNFD Archive Artifact with Range Request and NFVO not supporting Range Requests
    [Documentation]    Test ID: 5.3.1.17.5
    ...    Test title: GET Individual PNFD Archive Artifact with Range Request and NFVO not supporting Range Requests
    ...    Test objective: The objective is to test that the retrieval of an individual PNFD archive artifact, when using a range request to return single range of bytes from the file and the NFVO not supporting it, returns the full PNFD Archive artifact.
    ...    Pre-conditions: One or more PNFD archives are on-boarded in the NFVO.
    ...    Reference: Clause 5.4.7c.3.2 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: The NFVO does not support range requests to return single range of bytes from the PNFD Archive artifact
    ...    Post-Conditions: none    
    GET Individual PNFD Archive Artifact with Range Request
    Check HTTP Response Status Code Is    200
    
GET Individual PNFD Archive Artifact with invalid resource identifier
    [Documentation]    Test ID: 5.3.1.17.6
    ...    Test title: GET Individual PNFD Archive Artifact with invalid resource identifier
    ...    Test objective: The objective is to test that the retrieval of an individual PNFD Archive Artifact fails when using an invalid resource identifier
    ...    Pre-conditions: One or more PNFD archives are on-boarded in the NFVO.
    ...    Reference: Clause 5.4.7c.3.2 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none    
    GET Individual PNFD Archive Artifact with invalid resource identifier
    Check HTTP Response Status Code Is    404
    Check HTTP Response Body Json Schema Is   ProblemDetails
    
GET Individual PNFD Archive Artifact - Not Acceptable
    [Documentation]    Test ID: 5.3.1.17.7
    ...    Test title: GET Individual PNFD Archive Artifact - Not Acceptable
    ...    Test objective: The objective is to test that the retrieval of an individual PNFD Archive artifact fails when related request contained an "Accept" header not compatible with the Content type "application/zip" but the "include_signatures" flag was provided
    ...    Pre-conditions: One or more PNFD archives are on-boarded to the NFVO.
    ...    Reference: Clause 5.4.7c.3.2 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none      
    GET Individual PNFD Archive Artifact with incompatable header
    Check HTTP Response Status Code Is    406
    Check HTTP Response Body Json Schema Is   ProblemDetails

GET Individual PNFD Archive Artifact with conflict due to onboarding state
    [Documentation]    Test ID: 5.3.1.17.8
    ...    GET Individual PNFD Archive Artifact with conflict due to onboarding state
    ...    Test objective: The objective is to test that the retrieval of an individual PNFD Archive Artifact fails due to a conflict when the PNFD is not in onboarding state ONBOARDED in the NFVO. The test also performs a validation of the JSON schema validation of the failed operation HTTP response
    ...    Pre-conditions: The onboarding state of the PNFD archive for which the content is requested is different from ONBOARDED.
    ...    Reference: Clause 5.4.7c.3.2 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none   
    GET Individual PNFD Archive Artifact in onboarding state different from ONBOARDED
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is   ProblemDetails
    
GET Individual PNFD Archive Artifact with invalid Range Request
    [Documentation]    Test ID: 5.3.1.17.9
    ...    Test title: GET Individual PNFD Archive Artifact with invalid Range Request
    ...    Test objective: The objective is to test that the retrieval of an Individual PNFD Archive fails when using a range request that does not match any available byte range in the file.
    ...    Pre-conditions: One or more PNFD Archives are on-boarded to the NFVO.
    ...    Reference: Clause 5.4.7c.3.2 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: The NFVO supports range requests to return single range of bytes from the PNFD Archive artifact
    ...    Post-Conditions: none      
    GET Individual PNFD Archive Artifact with invalid Range Request
    Check HTTP Response Status Code Is    416
    Check HTTP Response Body Json Schema Is   ProblemDetails

POST Individual PNFD Archive Artifact - Method not implemented
    [Documentation]    Test ID: 5.3.1.17.10
    ...    Test title: POST Individual PNFD Archive Artifact - Method not implemented
    ...    Test objective: The objective is to test that POST method is not allowed to create an individual artifact contained in an PNFD archive.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.7c.3.1 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send POST Request for PNFD archive Artifact
    Check HTTP Response Status Code Is    405
    
PUT Individual PNFD Archive Artifact - Method not implemented
    [Documentation]    Test ID: 5.3.1.17.11
    ...    Test title: PUT Individual PNFD Archive Artifact - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not allowed to modify an Individual PNFD Archive artifact
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.7c.3.3 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send PUT Request for Individual PNFD Archive Artifact
    Check HTTP Response Status Code Is    405

PATCH Individual PNFD Archive Artifact - Method not implemented
    [Documentation]    Test ID: 5.3.1.17.12
    ...    Test title: PATCH Individual PNFD Archive Artifact - Method not implemented
    ...    Test objective: The objective is to test that PATCH  method is not allowed to update an Individual PNFD Archive artifact
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.7c.3.4 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send PATCH Request for Individual PNFD Archive Artifact
    Check HTTP Response Status Code Is    405

DELETE Individual PNFD Archive Artifact - Method not implemented
    [Documentation]    Test ID: 5.3.1.17.13
    ...    Test title: DELETE Individual PNFD Archive Artifact - Method not implemented
    ...    Test objective: The objective is to test that DELETE  method is not allowed to delete an Individual PNFD Archive artifact
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.7c.3.5 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send DELETE Request for Individual PNFD Archive Artifact
    Check HTTP Response Status Code Is    405

GET Individual PNFD Archive Artifact with permitted authorization scope
    [Documentation]    Test ID: 5.3.1.17.13
    ...    Test title: GET Individual PNFD Archive Artifact with permitted authorization scope
    ...    Test objective: The objective is to test the retrieval of an individual PNFD Archive artifact with permitted authorization scope
    ...    Pre-conditions: One or more PNFD archives are on-boarded in the NFVO.
    ...    Reference: Clause 5.4.7c.3.2 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Individual PNFD Archive Artifact with permitted authorization scope
    Check HTTP Response Status Code Is    200

GET Individual PNFD Archive Artifact with not permitted authorization scope
    [Documentation]    Test ID: 5.3.1.17.14
    ...    Test title: GET Individual PNFD Archive Artifact with not permitted authorization scope
    ...    Test objective: The objective is to test that the retrieval of an individual PNFD Archive artifact fails when using not permitted authorization scope
    ...    Pre-conditions: One or more PNFD archives are on-boarded in the NFVO.
    ...    Reference: Clause 5.4.7c.3.2 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Individual PNFD Archive Artifact with not permitted authorization scope
    Check HTTP Response Status Code Is    200

    