*** Settings ***
Resource    NFVICapacityInformationKeywords.robot 
Suite Setup    Check resource existence and get CallbackUri

*** Test Cases ***
Capacity Shortage Notification
    [Documentation]    Test ID: 5.3.6.6.1
    ...    Test title: Capacity Shortage Notification
    ...    Test objective: The objective is to test that Capacity Shortage Notification is delivered with success to the notification consumer.
    ...    Pre-conditions: The consumer has already created an Individual Capacity Threshold resource
    ...    Reference: Clause 10.4.6.3.1 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    POST Capacity Shortage Notification
    Check HTTP Response Status Code Is    204
    
Test the Notification Endpoint - Successful
    [Documentation]    Test ID: 5.3.6.6.2
    ...    Test title: Test the Notification Endpoint - Successful
    ...    Test objective: The objective is to test the Notification Endpoint provided by the notification consumer.
    ...    Pre-conditions: The consumer has already created an Individual Capacity Threshold resource
    ...    Reference: Clause 10.4.6.3.2 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Get reach the notification endpoint
    Check HTTP Response Status Code Is    204
    
Test the Notification Endpoint - UNREACHABLE
    [Documentation]    Test ID: 5.3.6.6.3
    ...    Test title: Test the Notification Endpoint - UNREACHABLE
    ...    Test objective: The objective is to test the Notification Endpoint provided by the notification consumer.
    ...    Pre-conditions: The consumer has already created an Individual Capacity Threshold resource
    ...    Reference: Clause 10.4.6.3.2 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: The notification endpoint is unreachable by the API producer.
    ...    Post-Conditions: none 
    GET reach an unreachable notification endpoint
    Check HTTP Response Status Code Is    422
    Check HTTP Response Body Json Schema Is    ProblemDetails    
    
PUT Notification endpoint - Method Not Implemented
    [Documentation]    Test ID: 5.3.6.6.4
    ...    Test title: PUT Notification endpoint - Method Not Implemented
    ...    Test objective: The objective is to test the PUT method for Notification Endpoint provided by the consumer is not implemented.
    ...    Pre-conditions: A notification endpoint is provided by the API consumer upon subscription.
    ...    Reference: Clause 10.4.6.3.3 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    PUT notification endpoint
    Check HTTP Response Status Code Is    405
    
PATCH Notification endpoint - Method Not Implemented
    [Documentation]    Test ID: 5.3.6.6.5
    ...    Test title: PATCH Notification endpoint - Method Not Implemented
    ...    Test objective: The objective is to test the PATCH method for Notification Endpoint provided by the consumer is not implemented.
    ...    Pre-conditions: A notification endpoint is provided by the API consumer upon subscription.
    ...    Reference: Clause 10.4.6.3.4 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    PATCH notification endpoint
    Check HTTP Response Status Code Is    405

DELETE Notification endpoint - Method Not Implemented
    [Documentation]    Test ID: 5.3.6.6.6
    ...    Test title: DELETE Notification endpoint - Method Not Implemented
    ...    Test objective: The objective is to test the DELETE method for Notification Endpoint provided by the consumer is not implemented.
    ...    Pre-conditions: A notification endpoint is provided by the API consumer upon subscription.
    ...    Reference: Clause 10.4.6.3.5 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    DELETE notification endpoint
    Check HTTP Response Status Code Is    405