*** Settings ***
Resource    NFVICapacityInformationKeywords.robot

*** Test Cases ***
POST Individual VIMs NFVI Capacity Information - Method not implemented
    [Documentation]    Test ID: 5.3.6.3.1
    ...    Test title: POST Individual VIMs NFVI Capacity Information - Method not implemented
    ...    Test objective: The objective is to test that POST method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.3.3.1 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    POST Individual VIMs NFVI Capacity Information
    Check HTTP Response Status Code Is    405
    
GET Information about an Individual VIMs NFVI Capacity Information
    [Documentation]    Test ID: 5.3.6.3.2
    ...    Test title: GET Information about an Individual VIMs NFVI Capacity Information
    ...    Test objective: The objective is to retrieve information about Individual VIMs NFVI Capacity Information
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.3.3.2 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Individual VIMs NFVI Capacity Information
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    NfviCapacityInfo

GET Information about an Individual VIMs NFVI Capacity Information using filter query parameter
    [Documentation]    Test ID: 5.3.6.3.3
    ...    Test title: GET Information about an Individual VIMs NFVI Capacity Information using filter query parameter
    ...    Test objective: The objective is to retrieve information about Individual VIMs NFVI Capacity Information using filter query parameter
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.3.3.2 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Individual VIMs NFVI Capacity Information using filter
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    NfviCapacityInfo
        
GET Information about an Individual VIMs NFVI Capacity Information - NOT FOUND
     [Documentation]    Test ID: 5.3.6.3.4
    ...    Test title: GET Information about an Individual VIMs NFVI Capacity Information - NOT FOUND
    ...    Test objective: The objective is to test that the retrieval of Individual VIMs NFVI Capacity Information fails when using an invalid resource identifier.
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.3.3.2 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Individual VIMs NFVI Capacity Information with Invalid VIM ID
    Check HTTP Response Status Code Is    404
    Check HTTP Response Body Json Schema Is   ProblemDetails

PUT Individual VIMs NFVI Capacity Information - Method not implemented 
     [Documentation]    Test ID: 5.3.6.3.5
    ...    Test title: PUT Individual VIMs NFVI Capacity Information - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.3.3.3 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: VNF Snapshot Package not modified
    PUT Individual VIMs NFVI Capacity Information
    Check HTTP Response Status Code Is    405

PATCH Individual VIMs NFVI Capacity Information - Method Not implemented
    [Documentation]    Test ID: 5.3.6.3.6
    ...    Test title: PATCH Individual VIMs NFVI Capacity Information
    ...    Test objective: The objective is to test that PATCH method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.3.3.4 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: VNF Snapshot Package modified
    PATCH Individual VIMs NFVI Capacity Information
    Check HTTP Response Status Code Is    405

DELETE Individual VIMs NFVI Capacity Information - Method Not implemented 
    [Documentation]    Test ID: 5.3.6.3.7
    ...    Test title: DELETE Individual VIMs NFVI Capacity Information - Method Not implemented
    ...    Test objective: The objective is to test that DELETE method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.3.3.5 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: VNF Snapshot Package deleted
    DELETE Individual VIMs NFVI Capacity Information
    Check HTTP Response Status Code Is    405

GET Information about an Individual VIMs NFVI Capacity Information with permitted authorization scope
    [Documentation]    Test ID: 5.3.6.3.8
    ...    Test title: GET Information about an Individual VIMs NFVI Capacity Information with permitted authorization scope
    ...    Test objective: The objective is to retrieve information about Individual VIMs NFVI Capacity Information with permitted authorization scope
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.3.3.2 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Individual VIMs NFVI Capacity Information with permitted authorization scope
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    NfviCapacityInfo

GET Information about an Individual VIMs NFVI Capacity Information with not permitted authorization scope
    [Documentation]    Test ID: 5.3.6.3.9
    ...    Test title: GET Information about an Individual VIMs NFVI Capacity Information with not permitted authorization scope
    ...    Test objective: The objective is to test that retrieve information about Individual VIMs NFVI Capacity Information fails when using not permitted authorization scope
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.3.3.2 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Individual VIMs NFVI Capacity Information with not permitted authorization scope
    Check HTTP Response Status Code Is    401