*** Settings ***
Resource    NFVICapacityInformationKeywords.robot

*** Test Cases ***
POST Individual CCMs NFVI Capacity Information - Method not implemented
    [Documentation]    Test ID: 5.3.6.7.1
    ...    Test title: POST Individual CCMs NFVI Capacity Information - Method not implemented
    ...    Test objective: The objective is to test that POST method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.3a.3.1 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    POST Individual CCMs NFVI Capacity Information
    Check HTTP Response Status Code Is    405
    
GET Information about an Individual CCMs NFVI Capacity Information
    [Documentation]    Test ID: 5.3.6.7.2
    ...    Test title: GET Information about an Individual CCMs NFVI Capacity Information
    ...    Test objective: The objective is to retrieve information about Individual CCMs NFVI Capacity Information
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.3a.3.2 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Individual CCMs NFVI Capacity Information
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    NfviCapacityInfo

GET Information about an Individual CCMs NFVI Capacity Information using filter query parameter
    [Documentation]    Test ID: 5.3.6.7.3
    ...    Test title: GET Information about an Individual CCMs NFVI Capacity Information using filter query parameter
    ...    Test objective: The objective is to retrieve information about Individual CCMs NFVI Capacity Information using filter query parameter
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.3a.3.2 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Individual CCMs NFVI Capacity Information using filter
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    NfviCapacityInfo
        
GET Information about an Individual CCMs NFVI Capacity Information - NOT FOUND
     [Documentation]    Test ID: 5.3.6.7.4
    ...    Test title: GET Information about an Individual CCMs NFVI Capacity Information - NOT FOUND
    ...    Test objective: The objective is to test that the retrieval of Individual CCMs NFVI Capacity Information fails when using an invalid resource identifier.
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.3a.3.2 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Individual CCMs NFVI Capacity Information with Invalid VIM ID
    Check HTTP Response Status Code Is    404
    Check HTTP Response Body Json Schema Is   ProblemDetails

PUT Individual CCMs NFVI Capacity Information - Method not implemented 
     [Documentation]    Test ID: 5.3.6.7.5
    ...    Test title: PUT Individual CCMs NFVI Capacity Information - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.3a.3.3 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: VNF Snapshot Package not modified
    PUT Individual CCMs NFVI Capacity Information
    Check HTTP Response Status Code Is    405

PATCH Individual CCMs NFVI Capacity Information - Method Not implemented
    [Documentation]    Test ID: 5.3.6.7.6
    ...    Test title: PATCH Individual CCMs NFVI Capacity Information
    ...    Test objective: The objective is to test that PATCH method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.3a.3.4 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: VNF Snapshot Package modified
    PATCH Individual CCMs NFVI Capacity Information
    Check HTTP Response Status Code Is    405

DELETE Individual CCMs NFVI Capacity Information - Method Not implemented 
    [Documentation]    Test ID: 5.3.6.7.7
    ...    Test title: DELETE Individual CCMs NFVI Capacity Information - Method Not implemented
    ...    Test objective: The objective is to test that DELETE method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.3a.3.5 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: VNF Snapshot Package deleted
    DELETE Individual CCMs NFVI Capacity Information
    Check HTTP Response Status Code Is    405

GET Information about an Individual CCMs NFVI Capacity Information with permitted authorization scope
    [Documentation]    Test ID: 5.3.6.7.8
    ...    Test title: GET Information about an Individual CCMs NFVI Capacity Information with permitted authorization scope
    ...    Test objective: The objective is to retrieve information about Individual CCms NFVI Capacity Information with permitted authorization scope
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.3a.3.2 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Individual CCMs NFVI Capacity Information with permitted authorization scope
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    NfviCapacityInfo

GET Information about an Individual CCMs NFVI Capacity Information with not permitted authorization scope
    [Documentation]    Test ID: 5.3.6.7.9
    ...    Test title: GET Information about an Individual CCMs NFVI Capacity Information with not permitted authorization scope
    ...    Test objective: The objective is to test that retrieve information about Individual CCMs NFVI Capacity Information fails when using not permitted authorization scope
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.3a.3.2 - ETSI GS NFV-SOL 005 [3] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Individual CCMs NFVI Capacity Information with not permitted authorization scope
    Check HTTP Response Status Code Is    401