*** Settings ***
Library    String
Resource    environment/variables.txt
Resource    VRQANOperationKeywords.robot
Library    OperatingSystem
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/
Library    REST    ${NFVO_SCHEMA}://${NFVO_HOST}:${NFVO_PORT}    ssl_verify=false
Suite Setup    Check resource existence and get CallbackUri

*** Test Cases ***
Vr Quota Availibility Notification
    [Documentation]    Test ID: 7.3.7.4.1
    ...    Test title: Vr Quota Availibility Notification
    ...    Test objective: The objective is to test that Vr Quota Availibility Notification is delivered with success to the notification consumer
    ...    Pre-conditions: The VNF has subscribed to the Vr Quota Availibility resource
    ...    Reference: Clause 11.4.4.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions:  none
    Post Vr Quota Avail Notification
    Check HTTP Response Status Code Is    204
Test the Notification Endpoint - Successful
    [Documentation]    Test ID: 7.3.7.4.2
    ...    Test title: Test the Notification Endpoint - Successful
    ...    Test objective: The objective is to test the Notification Endpoint provided by the notification consumer.
    ...    Pre-conditions: A notification endpoint is provided by the API consumer upon subscription.
    ...    Reference: Clause 11.4.4.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Get reach the notification endpoint
    Check HTTP Response Status Code Is    204
PUT Notification endpoint - Method Not Implemented
    [Documentation]    Test ID: 7.3.7.4.3
    ...    Test title: PUT Notification endpoint - Method Not Implemented
    ...    Test objective: The objective is to test the PUT method for Notification Endpoint provided by the consumer is not implemented.
    ...    Pre-conditions: A notification endpoint is provided by the API consumer upon subscription.
    ...    Reference: Clause 11.4.4.3.3 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    PUT notification endpoint
    Check HTTP Response Status Code Is    405
PATCH Notification endpoint - Method Not Implemented
    [Documentation]    Test ID: 7.3.7.4.4
    ...    Test title: PATCH Notification endpoint - Method Not Implemented
    ...    Test objective: The objective is to test the PATCH method for Notification Endpoint provided by the consumer is not implemented.
    ...    Pre-conditions: A notification endpoint is provided by the API consumer upon subscription.
    ...    Reference: Clause 11.4.4.3.4 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    PATCH notification endpoint
    Check HTTP Response Status Code Is    405
DELETE Notification endpoint - Method Not Implemented
    [Documentation]    Test ID: 7.3.7.4.5
    ...    Test title: DELETE Notification endpoint - Method Not Implemented
    ...    Test objective: The objective is to test the DELETE method for Notification Endpoint provided by the consumer is not implemented.
    ...    Pre-conditions: A notification endpoint is provided by the API consumer upon subscription.
    ...    Reference: Clause 11.4.4.3.5 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    DELETE notification endpoint
    Check HTTP Response Status Code Is    405