*** Settings ***
Resource    VnfSnapshotPackageManagementKeywords.robot 

*** Test Cases ***
POST VNF Snapshot Package Content - Method not implemented
    [Documentation]    Test ID: 7.3.8.4.1
    ...    Test title: POST VNF Snapshot Package Content - Method not implemented
    ...    Test objective: The objective is to test that POST method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 12.4.4.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    POST VNF Snapshot Package Content
    Check HTTP Response Status Code Is    405
    
GET VNF Snapshot Package Content - Complete File
    [Documentation]    Test ID: 7.3.8.4.2
    ...    Test title: GET Information about an individual VNF Snapshot Package - Complete File
    ...    Test objective: The objective is to fetch the whole content of a VNF snapshot package using GET method.
    ...    Pre-conditions: none
    ...    Reference: Clause 12.4.4.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET VNF Snapshot Package Content - Complete
    Check HTTP Response Status Code Is    200
    Check HTTP Content-Type Header Is Set For Package Content
    
GET VNF Snapshot Package Content - Partial Content
    [Documentation]    Test ID: 7.3.8.4.3
    ...    Test title: GET VNF Snapshot Package Content - Partial Content
    ...    Test objective: The objective is to fetch partial content of a VNF snapshot package by sending a range request using GET method.
    ...    Pre-conditions: none
    ...    Reference: Clause 12.4.4.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: NFVO supports range requests
    ...    Post-Conditions: none
    GET VNF Snapshot Package Content - Range Request
    Check HTTP Response Status Code Is    206
    Check HTTP Content-Type Header Is Set For Package Content
    Check HTTP Content-Range Header Is Set
    Check HTTP Content-Length Header Is Set
    
GET VNF Snapshot Package Content - Range Request Not Supported
    [Documentation]    Test ID: 7.3.8.4.4
    ...    Test title: GET Information about an individual VNF Snapshot Package - Range Request Not Supported
    ...    Test objective: The objective is to test that the whole content of a VNF snapshot package is delivered even with a range request when NFVO does not support range requests.
    ...    Pre-conditions: none
    ...    Reference: Clause 12.4.4.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: NFVO does not support range requests
    ...    Post-Conditions: none
    GET VNF Snapshot Package Content - Range Request
    Check HTTP Response Status Code Is    200
    Check HTTP Content-Type Header Is Set For Package Content
    
GET VNF Snapshot Package Content - Range Not Satisfiable
    [Documentation]    Test ID: 7.3.8.4.5
    ...    Test title: GET Information about an individual VNF Snapshot Package - Range Not Satisfiable
    ...    Test objective: The objective is to test that an error is returned when the byte range passed in the "Range" header does not match any available byte range in the VNF snapshot package file.
    ...    Pre-conditions: none
    ...    Reference: Clause 12.4.4.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: NFVO supports range requests
    ...    Post-Conditions: none
    GET VNF Snapshot Package Content - Invalid Range
    Check HTTP Response Status Code Is    416

GET VNF Snapshot Package Content - Conflict
    [Documentation]    Test ID: 7.3.8.4.6
    ...    Test title: GET Information about an individual VNF Snapshot Package - Conflict
    ...    Test objective: The objective is to test that an error is returned when the "state" of the VNF snapshot package has a value different from "AVAILABLE".
    ...    Pre-conditions: none
    ...    Reference: Clause 12.4.4.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: The "state" of the VNF snapshot package has a value different from "AVAILABLE".
    ...    Post-Conditions: none
    GET VNF Snapshot Package Content - Not Available
    Check HTTP Response Status Code Is    409
    
PUT VNF Snapshot Package Content - Method not implemented 
    [Documentation]    Test ID: 7.3.8.4.7
    ...    Test title: PUT VNF Snapshot Package Content - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 12.4.4.3.3 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: VNF Snapshot Package not modified
    PUT VNF Snapshot Package Content
    Check HTTP Response Status Code Is    405

PATCH VNF Snapshot Package Content - Method Not implemented
    [Documentation]    Test ID: 7.3.8.4.8
    ...    Test title: PATCH VNF Snapshot Package Content
    ...    Test objective: The objective is to test that PATCH method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 12.4.4.3.4 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH VNF Snapshot Package Content
    Check HTTP Response Status Code Is    405

DELETE VNF Snapshot Package Content - Method Not implemented 
    [Documentation]    Test ID: 7.3.8.4.9
    ...    Test title: DELETE VNF Snapshot Package Content - Method Not implemented
    ...    Test objective: The objective is to test that DELETE method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 12.4.4.3.5 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    DELETE VNF Snapshot Package Content
    Check HTTP Response Status Code Is    405