*** Settings ***
Resource    environment/variables.txt
Library    REST    ${VNFM_SCHEMA}://${VNFM_HOST}:${VNFM_PORT}    ssl_verify=false
Library    MockServerLibrary 
Library    OperatingSystem
Library    BuiltIn
Library    JSONLibrary
Library    Collections
Library    JSONSchemaLibrary    schemas/
Library    Process    

*** Keywords ***       
Check HTTP Response Header Contains
    [Arguments]    ${CONTENT_TYPE}
    Should Contain    ${response['headers']}    ${CONTENT_TYPE}
    Log    Header is present

Check HTTP Response Location Header Resource URI
    Log    Going to check
    GET    ${response['headers']['Location']}
    Integer    response status    200
    Log    Received a 200 OK as expected
    ${contentType}=    Output    response headers Content-Type
    Should Contain    ${contentType}    application/json
    ${result}=    Output    response body
    Validate Json    PmSubscription.schema.json    ${result}
    Log    Validated PmSubscription schema

Create Sessions
    Pass Execution If    ${VNFM_CHECKS_NOTIF_ENDPOINT} == 0   MockServer not necessary to run    
    Start Process  java  -jar  ${MOCK_SERVER_JAR}    -serverPort  ${callback_port}  alias=mockInstance
    Wait For Process  handle=mockInstance  timeout=5s  on_timeout=continue
    Create Mock Session  ${callback_uri}:${callback_port}
    
Check Notification Endpoint
    &{notification_request}=  Create Mock Request Matcher	GET  ${callback_endpoint}    
    &{notification_response}=  Create Mock Response	headers="Content-Type: application/json"  status_code=204
    Create Mock Expectation  ${notification_request}  ${notification_response}
    Wait Until Keyword Succeeds    ${total_polling_time}   ${polling_interval}   Verify Mock Expectation    ${notification_request}
    Clear Requests  ${callback_endpoint}
Check LINK in Header
    ${linkURL}=    Get Value From Json    ${response['headers']}    $..Link
    Should Not Be Empty    ${linkURL}
GET reach the notification endpoint  
    Log    Trying to reach the notification endpoint using GET method.
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${callbackResp}
    ${outputResponse}=    Output    response
    Set Global Variable    ${response}    ${outputResponse}
PUT notification endpoint  
    Log    Trying to perform a PUT. This method should not be implemented.
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${callbackResp}
    ${outputResponse}=    Output    response
    Set Global Variable    ${response}    ${outputResponse}
PATCH notification endpoint  
    Log    Trying to perform a PATCH. This method should not be implemented.
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${callbackResp}
    ${outputResponse}=    Output    response
    Set Global Variable    ${response}    ${outputResponse}

DELETE notification endpoint  
    Log    Trying to perform a DELETE. This method should not be implemented.
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${callbackResp}
    ${outputResponse}=    Output    response
    Set Global Variable    ${response}    ${outputResponse}