*** Settings ***
Library    String
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt
Resource          VNFPackageManagementKeywords.robot
Library           OperatingSystem
Library           JSONLibrary
Library           REST    ${NFVO_SCHEMA}://${NFVO_HOST}:${NFVO_PORT}    ssl_verify=false
Suite Setup    Check resource existence and get CallbackUri

*** Test Cases ***
VNF Package Onboarding Notification
    [Documentation]    Test ID: 7.3.3.12.1
    ...    Test title: VNF Package Onboarding Notification
    ...    Test objective: The objective is to test that the POST request triggers VNF Package Onboarding notification.
    ...    Pre-conditions: A VNF package subscription for onboarding notifications is available in the NFVO.
    ...    Reference: Clause 10.4.9.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post VNF Package Onboarding Notification
    Check HTTP Response Status Code Is    204

VNF Package Change Notification
    [Documentation]    Test ID: 7.3.3.12.2
    ...    Test title: VNF Package Change Notification
    ...    Test objective: The objective is to test that the POST request triggers VNF Package Change notification.
    ...    Pre-conditions: A VNF package subscription for change notifications is available in the NFVO.
    ...    Reference: Clause 10.4.9.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post VNF Package Change Notification
    Check HTTP Response Status Code Is    204
Test the Notification Endpoint - Successful
    [Documentation]    Test ID: 7.3.3.12.3
    ...    Test title: Test the Notification Endpoint - Successful
    ...    Test objective: The objective is to test the Notification Endpoint provided by the notification consumer.
    ...    Pre-conditions: A notification endpoint is provided by the API consumer upon subscription.
    ...    Reference: Clause 10.4.9.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Get reach the notification endpoint
    Check HTTP Response Status Code Is    204
PUT Notification endpoint - Method Not Implemented
    [Documentation]    Test ID: 7.3.3.12.4
    ...    Test title: PUT Notification endpoint - Method Not Implemented
    ...    Test objective: The objective is to test the PUT method for Notification Endpoint provided by the consumer is not implemented.
    ...    Pre-conditions: A notification endpoint is provided by the API consumer upon subscription.
    ...    Reference: Clause 10.4.9.3.3 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    PUT notification endpoint
    Check HTTP Response Status Code Is    405
PATCH Notification endpoint - Method Not Implemented
    [Documentation]    Test ID: 7.3.3.12.5
    ...    Test title: PATCH Notification endpoint - Method Not Implemented
    ...    Test objective: The objective is to test the PATCH method for Notification Endpoint provided by the consumer is not implemented.
    ...    Pre-conditions: A notification endpoint is provided by the API consumer upon subscription.
    ...    Reference: Clause 10.4.9.3.4 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    PATCH notification endpoint
    Check HTTP Response Status Code Is    405
DELETE Notification endpoint - Method Not Implemented
    [Documentation]    Test ID: 7.3.3.12.6
    ...    Test title: DELETE Notification endpoint - Method Not Implemented
    ...    Test objective: The objective is to test the DELETE method for Notification Endpoint provided by the consumer is not implemented.
    ...    Pre-conditions: A notification endpoint is provided by the API consumer upon subscription.
    ...    Reference: Clause 10.4.9.3.5 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    DELETE notification endpoint
    Check HTTP Response Status Code Is    405
