*** Settings ***
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt
Resource          VNFPackageManagementKeywords.robot 
Library           JSONLibrary
Library           REST    ${NFVO_SCHEMA}://${NFVO_HOST}:${NFVO_PORT}    ssl_verify=false

*** Test Cases ***
Get Manifest in Individual VNF Package
    [Documentation]    Test ID: 7.3.3.10.1
    ...    Test title: Get Manifest in Individual VNF Package
    ...    Test objective: The objective is to test that the Get request read the content of manifest within a NVF Package and perform a validation that returned content is in plain text format
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 10.4.4a.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Manifest in Individual VNF Package
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Content-Type Is    text/plain

Get Manifest in Individual VNF Package with security information
    [Documentation]    Test ID: 7.3.3.10.2
    ...    Test title: Get Manifest in Individual VNF Package with security information
    ...    Test objective: The objective is to test the retrieval of manifest for an individual VNF package shall also security certificates when requested with "include_signature" parameter, and perform a validation that returned content is in Zip format
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 10.4.4a.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Manifest in Individual VNF Package with security information
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Content-Type Is    application/zip

Get Manifest in Individual VNF Package - Not acceptable
    [Documentation]    Test ID: 7.3.3.10.3
    ...    Test title: Get Manifest in Individual VNF Package - Not acceptable
    ...    Test objective: The objective is to test that retriveal of the of manifest for an individual VNF package fails when request contained an "Accept" header not compatible with the Content type "application/zip" but the "include_signatures" flag was provided, and perform a validation of the JSON schema validation of the failed operation HTTP response
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 10.4.4a.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Manifest in Individual VNF Package
    Check HTTP Response Status Code Is    406
    Check HTTP Response Body Json Schema Is   ProblemDetails

Get Manifest in Individual VNF Package - Conflict
    [Documentation]    Test ID: 7.3.3.10.4
    ...    Test title: Get Manifest in Individual VNF Package - Conflict
    ...    Test objective: The objective is to test that the retrieval of the manifest for an individual VNF package fails due to a conflict when the VNF Package is not in onboarding state ONBOARDED in the NFVO. The test also performs a validation of the JSON schema validation of the failed operation HTTP response
    ...    Pre-conditions: The onboarding state of the VNF package for which the VNFD is requested is different from ONBOARDED.
    ...    Reference: Clause 10.4.4a.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none 
    Get Manifest in Individual VNF Package with conflict due to onboarding state
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is   ProblemDetails

POST Manifest in Individual VNF Package - Method not implemented
    [Documentation]    Test ID: 7.3.3.10.5
    ...    Test title: POST Manifest in Individual VNF Package - Method not implemented
    ...    Test objective: The objective is to test that POST method is not allowed to create new resource
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.4a.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send POST Request for Manifest in individual VNF Package
    Check HTTP Response Status Code Is    405

PUT Manifest in Individual VNF Package - Method not implemented
    [Documentation]    Test ID: 7.3.3.10.6
    ...    Test title: PUT Manifest in Individual VNF Package - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not allowed to modify resource
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 10.4.4a.3.3 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send PUT Request for Manifest in individual VNF Package
    Check HTTP Response Status Code Is    405

PATCH Manifest in Individual VNF Package - Method not implemented
    [Documentation]    Test ID: 7.3.3.10.7
    ...    Test title: PATCH Manifest in Individual VNF Package - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not allowed to update resource
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 10.4.4a.3.4 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send PATCH Request for Manifest in individual VNF Package
    Check HTTP Response Status Code Is    405

DELETE Manifest in Individual VNF Package - Method not implemented
    [Documentation]    Test ID: 7.3.3.10.8
    ...    Test title: DELETE Manifest in Individual VNF Package - Method not implemented
    ...    Test objective: The objective is to test that DELETE  method is not allowed to delete resource
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 10.4.4a.3.5 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: Resource is not deleted by the failed operation
    Send DELETE Request for Manifest in individual VNF Package
    Check HTTP Response Status Code Is    405
    

Get Manifest in Individual OnBoarded VNF Package
    [Documentation]    Test ID: 7.3.3.10.9
    ...    Test title: Get Manifest in Individual OnBoarded VNF Package
    ...    Test objective: The objective is to test that the Get request read the content of manifest within a OnBoarded NVF Package and perform a validation that returned content is in plain text format
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 10.4.4a.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Manifest in Individual OnBoarded VNF Package
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Content-Type Is    text/plain
    
Get Manifest in Individual OnBoarded VNF Package with security information
    [Documentation]    Test ID: 7.3.3.10.10
    ...    Test title: Get Manifest in Individual OnBoarded VNF Package with security information
    ...    Test objective: The objective is to test the retrieval of manifest for an individual OnBoarded VNF package shall also security certificates when requested with "include_signature" parameter, and perform a validation that returned content is in Zip format
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 10.4.4a.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Manifest in Individual OnBoarded VNF Package with security information
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Content-Type Is    application/zip

Get Manifest in Individual OnBoarded VNF Package - Not acceptable
    [Documentation]    Test ID: 7.3.3.10.11
    ...    Test title: Get Manifest in Individual OnBoarded VNF Package - Not acceptable
    ...    Test objective: The objective is to test that retriveal of the of manifest for an individual OnBoarded VNF package fails when request contained an "Accept" header not compatible with the Content type "application/zip" but the "include_signatures" flag was provided, and perform a validation of the JSON schema validation of the failed operation HTTP response
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 10.4.4a.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Manifest in Individual OnBoarded VNF Package
    Check HTTP Response Status Code Is    406
    Check HTTP Response Body Json Schema Is   ProblemDetails

Get Manifest in Individual OnBoarded VNF Package - Conflict
    [Documentation]    Test ID: 7.3.3.10.12
    ...    Test title: Get Manifest in Individual OnBoarded VNF Package - Conflict
    ...    Test objective: The objective is to test that the retrieval of the manifest for an individual OnBoarded VNF package fails due to a conflict when the VNF Package is not in onboarding state ONBOARDED in the NFVO. The test also performs a validation of the JSON schema validation of the failed operation HTTP response
    ...    Pre-conditions: The onboarding state of the VNF package for which the VNFD is requested is different from ONBOARDED.
    ...    Reference: Clause 10.4.4a.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none 
    Get Manifest in Individual OnBoarded VNF Package with conflict due to onboarding state
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is   ProblemDetails

POST Manifest in Individual OnBoarded VNF Package - Method not implemented
    [Documentation]    Test ID: 7.3.3.10.13
    ...    Test title: POST Manifest in Individual OnBoarded VNF Package - Method not implemented
    ...    Test objective: The objective is to test that POST method is not allowed to create new resource
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.4a.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send POST Request for Manifest in individual OnBoarded VNF Package
    Check HTTP Response Status Code Is    405

PUT Manifest in Individual OnBoarded VNF Package - Method not implemented
    [Documentation]    Test ID: 7.3.3.10.14
    ...    Test title: PUT Manifest in Individual OnBoarded VNF Package - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not allowed to modify resource
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 10.4.4a.3.3 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send PUT Request for Manifest in individual OnBoarded VNF Package
    Check HTTP Response Status Code Is    405

PATCH Manifest in Individual OnBoarded VNF Package - Method not implemented
    [Documentation]    Test ID: 7.3.3.10.15
    ...    Test title: PATCH Manifest in Individual OnBoarded VNF Package - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not allowed to update resource
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 10.4.4a.3.4 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send PATCH Request for Manifest in individual OnBoarded VNF Package
    Check HTTP Response Status Code Is    405

DELETE Manifest in Individual OnBoarded VNF Package - Method not implemented
    [Documentation]    Test ID: 7.3.3.10.16
    ...    Test title: DELETE Manifest in Individual OnBoarded VNF Package - Method not implemented
    ...    Test objective: The objective is to test that DELETE  method is not allowed to delete resource
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 10.4.4a.3.5 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: Resource is not deleted by the failed operation
    Send DELETE Request for Manifest in individual OnBoarded VNF Package
    Check HTTP Response Status Code Is    405

Get Manifest in Individual VNF Package with permitted authorization scope 
    [Documentation]    Test ID: 7.3.3.10.17
    ...    Test title: Get Manifest in Individual VNF Package with permitted authorization scope 
    ...    Test objective: The objective is to test that the Get request read the content of manifest within a NVF Package and perform a validation that returned content is in plain text format with permitted authorization scope 
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 10.4.4a.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Manifest in Individual VNF Package with permitted authorization scope
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Content-Type Is    text/plain

Get Manifest in Individual VNF Package with not permitted authorization scope 
    [Documentation]    Test ID: 7.3.3.10.18
    ...    Test title: Get Manifest in Individual VNF Package with not permitted authorization scope 
    ...    Test objective: The objective is to test that the Get request read the content of manifest within a NVF Package and perform a validation that returned content is in plain text format with not permitted authorization scope 
    ...    Pre-conditions: One or more VNF packages are onboarded in the NFVO.
    ...    Reference: Clause 10.4.4a.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Manifest in Individual VNF Package with not permitted authorization scope
    Check HTTP Response Status Code Is    403
    Check HTTP Response Body Json Schema Is   ProblemDetails
