*** Settings ***
Library    String
Resource   environment/variables.txt 
Library    REST    ${NFVO_SCHEMA}://${NFVO_HOST}:${NFVO_PORT}    ssl_verify=false
Library    OperatingSystem
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/
Library    Collections

*** Variables ***
${retry}   2 min
${polling}    10 sec

*** Keywords ***
Wait for individual grant successful notification
    Wait Until Keyword Succeeds    ${retry}   ${polling}    Get an individual grant - Successful
Send Request Grant Request in Synchronous mode
    Log    Request a new Grant for a VNF LCM operation by POST to ${apiRoot}/${apiName}/${apiMajorVersion}/grants
    Pass Execution If    ${SYNC_MODE} == 0    The Granting process is asynchronous mode. Skipping the test
    Set Headers    {"Accept": "${ACCEPT}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Run Keyword If    ${check_descriptors} == 1    PARSE the Descriptor File
    ${template}=    Get File    jsons/grantRequest.json
    ${body}=        Format String   ${template}    vnfInstanceId=${vnfInstanceId}   vnfLcmOpOccId=${vnfLcmOpOccId}    vnfdId=${Descriptor_ID}    flavourId=${Flavour_ID}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/grants    ${body}
    ${body}=    Output    response
    Set Suite Variable    ${response}    ${body}

Send Request Grant Request in Synchronous mode with attribute instantiationLevelId
    Log    Request a new Grant for a VNF LCM operation by POST to ${apiRoot}/${apiName}/${apiMajorVersion}/grants
    Pass Execution If    ${SYNC_MODE} == 0    The Granting process is asynchronous mode. Skipping the test
    Set Headers    {"Accept": "${ACCEPT}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Run Keyword If    ${check_descriptors} == 1    PARSE the Descriptor File
    ${template}=    Get File    jsons/grantRequestWithAttributeInstantiationLevelId.json
    ${body}=        Format String   ${template}    vnfInstanceId=${vnfInstanceId}   vnfLcmOpOccId=${vnfLcmOpOccId}    vnfdId=${Descriptor_ID}    flavourId=${Flavour_ID}    instantiationLevelId=${instantiationLevelId}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/grants    ${body}
    ${body}=    Output    response
    Set Suite Variable    ${response}    ${body}   

Send Request Grant Request in Synchronous mode with attribute targetScaleLevelInfo
    Log    Request a new Grant for a VNF LCM operation by POST to ${apiRoot}/${apiName}/${apiMajorVersion}/grants
    Pass Execution If    ${SYNC_MODE} == 0    The Granting process is asynchronous mode. Skipping the test
    Set Headers    {"Accept": "${ACCEPT}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Run Keyword If    ${check_descriptors} == 1    PARSE the Descriptor File
    ${template}=    Get File    jsons/grantRequestWithAttributeTargetScaleLevelInfo.json
    ${body}=        Format String   ${template}    vnfInstanceId=${vnfInstanceId}   vnfLcmOpOccId=${vnfLcmOpOccId}    vnfdId=${Descriptor_ID}    flavourId=${Flavour_ID}    aspectId=${scaleAspectId}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/grants    ${body}
    ${body}=    Output    response
    Set Suite Variable    ${response}    ${body}

Send Request Grant Request in Synchronous mode with attribute addResources
    Log    Request a new Grant for a VNF LCM operation by POST to ${apiRoot}/${apiName}/${apiMajorVersion}/grants
    Pass Execution If    ${SYNC_MODE} == 0    The Granting process is asynchronous mode. Skipping the test
    Set Headers    {"Accept": "${ACCEPT}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Run Keyword If    ${check_descriptors} == 1    PARSE the Descriptor File
    ${template}=    Get File    jsons/grantRequestWithAttributeAddResources.json
    ${body}=        Format String   ${template}    vnfInstanceId=${vnfInstanceId}   vnfLcmOpOccId=${vnfLcmOpOccId}    vnfdId=${Descriptor_ID}    flavourId=${Flavour_ID}   
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/grants    ${body}
    ${body}=    Output    response
    Set Suite Variable    ${response}    ${body}         
    
Send Request Grant Request in Asynchronous mode
    Log    Request a new Grant for a VNF LCM operation by POST to ${apiRoot}/${apiName}/${apiMajorVersion}/grants
    Pass Execution If    ${SYNC_MODE} == 1    The Granting process is synchronous mode. Skipping the test
    Set Headers    {"Accept": "${ACCEPT}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Run Keyword If    ${check_descriptors} == 1    PARSE the Descriptor File
    ${template}=    Get File    jsons/grantRequest.json
    ${body}=        Format String   ${template}    vnfInstanceId=${vnfInstanceId}   vnfLcmOpOccId=${vnfLcmOpOccId}    vnfdId=${Descriptor_ID}    flavourId=${Flavour_ID}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/grants    ${body}
    ${body}=    Output    response
    Set Suite Variable    ${response}    ${body}
    
Send Request for a new Grant Forbiden Operation   
    Log    Request a new Grant for a VNF LCM operation by POST to ${apiRoot}/${apiName}/${apiMajorVersion}/grants
    Log    The grant request should be rejected
    Set Headers    {"Accept": "${ACCEPT}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Run Keyword If    ${check_descriptors} == 1    PARSE the Descriptor File
    ${template}=    Get File    jsons/grantRejectedRequest.json
    ${body}=        Format String   ${template}    vnfInstanceId=${vnfInstanceId}   vnfLcmOpOccId=${vnfLcmOpOccId}    vnfdId=${Descriptor_ID}    flavourId=${Flavour_ID}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/grants    ${body}
    ${body}=    Output    response
    Set Suite Variable    ${response}    ${body}

Send Request Grant Request in Synchronous mode with permitted authorization scope 
    Log    Request a new Grant for a VNF LCM operation by POST to ${apiRoot}/${apiName}/${apiMajorVersion}/grants with permitted authorization scope 
    Pass Execution If    ${SYNC_MODE} == 0    The Granting process is asynchronous mode. Skipping the test
    Set Headers    {"Accept": "${ACCEPT}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    ${scopeValue}=    Create Dictionary    scopeValue=${GRANT_PERMITTED_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scopeValue}    key=${OAUTH_KEY}    algorithm=${OAUTH_ENCRYPTION_ALGORITHM}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    Run Keyword If    ${check_descriptors} == 1    PARSE the Descriptor File
    ${template}=    Get File    jsons/grantRequest.json
    ${body}=        Format String   ${template}    vnfInstanceId=${vnfInstanceId}   vnfLcmOpOccId=${vnfLcmOpOccId}    vnfdId=${Descriptor_ID}    flavourId=${Flavour_ID}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/grants    ${body}
    ${body}=    Output    response
    Set Suite Variable    ${response}    ${body}
Send Request Grant Request in Synchronous mode with not permitted authorization scope 
    Log    Request a new Grant for a VNF LCM operation by POST to ${apiRoot}/${apiName}/${apiMajorVersion}/grants with not permitted authorization scope 
    Pass Execution If    ${SYNC_MODE} == 0    The Granting process is asynchronous mode. Skipping the test
    Set Headers    {"Accept": "${ACCEPT}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    ${scopeValue}=    Create Dictionary    scopeValue=${GRANT_NOT_PERMITTED_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scopeValue}    key=${OAUTH_KEY}    algorithm=${OAUTH_ENCRYPTION_ALGORITHM}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    Run Keyword If    ${check_descriptors} == 1    PARSE the Descriptor File
    ${template}=    Get File    jsons/grantRequest.json
    ${body}=        Format String   ${template}    vnfInstanceId=${vnfInstanceId}   vnfLcmOpOccId=${vnfLcmOpOccId}    vnfdId=${Descriptor_ID}    flavourId=${Flavour_ID}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/grants    ${body}
    ${body}=    Output    response
    Set Suite Variable    ${response}    ${body}
    
Check HTTP Response Status Code Is
    [Arguments]    ${expected_status}    
    Should Be Equal As Strings    ${response['status']}    ${expected_status}
    Log    Status code validated

Check Operation Occurrence Id existence 
    ${occId}=    Get Value From Json    ${response['headers']}    $..Location
    Should Not Be Empty    ${occId}

Check HTTP Response Header Contains
    [Arguments]    ${CONTENT_TYPE}
    Should Contain    ${response['headers']}    ${CONTENT_TYPE}
    Log    Header is present
    
Check HTTP Response Body Json Schema Is
    [Arguments]    ${input}
    Run Keyword If    '${input}' == 'ProblemDetails'    Should Contain    ${response['headers']['Content-Type']}    application/problem+json
    ...    ELSE    Should Contain    ${response['headers']['Content-Type']}    application/json
    ${schema} =    Catenate    SEPARATOR=    ${input}    .schema.json
    Validate Json    ${schema}    ${response['body']}
    
Get an individual grant - Successful
    log    Trying to read an individual grant
    Set Headers    {"Accept":"${ACCEPT}"}  
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${response['headers']['Location']}
    Log    Validate Status code
    Integer    response status    200
    
Get Grants
    Log    Trying to perform a GET. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"} 
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/grants
    ${body}=    Output    response
    Set Suite Variable    ${response}    ${body}
    
Put Grants
    Log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"} 
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/grants
    ${body}=    Output    response
    Set Suite Variable    ${response}    ${body}
    
Patch Grants
    Log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"} 
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/grants
    ${body}=    Output    response
    Set Suite Variable    ${response}    ${body} 
    
Delete Grants
    Log    Trying to perform a DELETE. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"} 
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/grants
    ${body}=    Output    response
    Set Suite Variable    ${response}    ${body}
    
 
Get individual grant
    log    Trying to read an individual grant
    Set Headers    {"Accept":"${ACCEPT}"}  
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/grants/${grantId}
    ${body}=    Output    response
    Set Suite Variable    ${response}    ${body}
    
Check resource existence
    Set Headers    {"Accept":"${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId} 
    Integer    response status    200
    
Post individual Grant
    log    Trying to read an individual grant
    Pass Execution If    ${SYNC_MODE} == 1   Skipping. Synchronous mode is supported    
    Set Headers    {"Accept":"${ACCEPT}"}  
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/grants/${grantId}
    ${body}=    Output    response
    Set Suite Variable    ${response}    ${body}
    
Put individual Grant
    Log    Trying to perform a GET. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"} 
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/grants/${grantId}
    ${body}=    Output    response
    Set Suite Variable    ${response}    ${body}
    
Patch individual Grant
    Log    Trying to perform a GET. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"} 
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/grants/${grantId}
    ${body}=    Output    response
    Set Suite Variable    ${response}    ${body}
    
Delete individual Grant
    Log    Trying to perform a GET. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"} 
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/grants/${grantId}
    ${body}=    Output    response
    Set Suite Variable    ${response}    ${body}
    
Check HTTP Response Body grant content against VNF Descriptor
    Run Keyword If    ${check_descriptors} == 1    Check Individual grant Content
    
Check Individual grant Content    
    PARSE the Descriptor File
    Match the grant Response Attributes with Descriptors
    
PARSE the Descriptor File
    Run Keyword If  '${descriptorType}'=='SOL001'    Fetch Information from SOL001 descriptor file    ELSE    Fetch Information from SOL006 descriptor file
    
Fetch Information from SOL001 descriptor file
    Import Variables    ${CURDIR}/descriptors/SOL006/VNFD/vnfd_SOL001.yaml    
    @{VDU_labels}=    Create List
    @{VNF_labels}=    Create List
    @{VirtualLink_labels}=    Create List
    @{CP_labels}=    Create List
    @{Storage_labels}=    Create List
    FOR    ${key}    IN    @{node_types.keys()}
        ${node_type}=    Get Variable Value    ${node_types['${key}']['derived_from']}
        ${is_VNF}=    Run Keyword And Return Status    Should Be Equal As Strings    ${node_type}    ${tosca_type_VNF}
        Run Keyword If    ${is_VNF}    Set Global Variable    ${tosca_type_derived_from_VNF}    ${key}
    END  
    ${derived_type_is_used}=    Run Keyword And Return Status    Should not be empty    ${tosca_type_derived_from_VNF}
    Run Keyword If    ${derived_type_is_used}    Set Global Variable    ${tosca_type_VNF}    ${tosca_type_derived_from_VNF}              
    FOR    ${key}    IN    @{topology_template.node_templates.keys()} 
        ${key_type}=    Get Variable Value    ${topology_template.node_templates['${key}'].type}
        ${VDU_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key_type}   ${tosca_type_VDU_compute}
        ${VNF_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key_type}    ${tosca_type_VNF}
        ${Link_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key_type}    ${tosca_type_virtual_link}
        ${VDUcp_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key_type}    ${tosca_type_VDU_cp}
        ${Storage_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key_type}    ${tosca_type_storage}
        Run Keyword If    ${VDU_check}    Append To List    ${VDU_labels}    ${key}
        Run Keyword If    ${VNF_check}    Append To List    ${VNF_labels}    ${key}
        Run Keyword If    ${VNF_check}    Get VNF Attributes from SOL001    ${key}            
        Run Keyword If    ${Link_check}    Append To List    ${VirtualLink_labels}    ${key}
        Run Keyword If    ${VDUcp_check}    Append To List    ${CP_labels}    ${key}
        Run Keyword If    ${Storage_check}    Append To List    ${Storage_labels}    ${key}
    END
    Set Global Variable    @{VDU_IDs}    @{VDU_labels}
    Set Global Variable    @{VNF_IDs}    @{VNF_labels}
    Set Global Variable    @{VirtualLink_IDs}    @{VirtualLink_labels}
    Set Global Variable    @{CP_IDs}    @{CP_labels}
    Set Global Variable    @{Storage_IDs}    @{Storage_labels}

Get VNF Attributes from SOL001
    [Arguments]    ${VNF_label}
    Import Variables    ${CURDIR}/descriptors/SOL006/VNFD/vnfd_SOL001.yaml    
    ${descriptor_id}=    Get Variable Value    ${topology_template.node_templates['${VNF_label}'].properties.descriptor_id}
    ${provider}=    Get Variable Value    ${topology_template.node_templates['${VNF_label}'].properties.provider}
    ${product_name}=    Get Variable Value    ${topology_template.node_templates['${VNF_label}'].properties.product_name}
    ${software_version}=    Get Variable Value    ${topology_template.node_templates['${VNF_label}'].properties.software_version}
    ${descriptor_version}=    Get Variable Value    ${topology_template.node_templates['${VNF_label}'].properties.descriptor_version}
    ${flavour_id}=    Get Variable Value    ${topology_template.node_templates['${VNF_label}'].properties.flavour_id}
    
    Set Global Variable    ${Descriptor_ID}    ${descriptor_id}
    Set Global Variable    ${Provider}    ${provider}
    Set Global Variable    ${Product_Name}    ${product_name}
    Set Global Variable    ${Software_Version}    ${software_version}
    Set Global Variable    ${Descriptor_Version}    ${descriptor_version}
    Set Global Variable    ${Flavour_ID}    ${flavour_id}

    
Fetch Information from SOL006 descriptor file
    Import Variables    ${CURDIR}/descriptors/SOL006/VNFD/vnfd_SOL006.yaml
    ${descriptor_id}=    Get Variable Value    ${nfv.vnfd[0].id}
    ${provider}=    Get Variable Value    ${nfv.vnfd[0].provider}
    ${product_name}=    Get Variable Value    ${nfv.vnfd[0]['product-name']}
    ${software_version}=    Get Variable Value    ${nfv.vnfd[0]['software-version']}
    ${descriptor_version}=    Get Variable Value    ${nfv.vnfd[0].version}    
    ${VDUcount}=    Get Length    ${nfv.vnfd[0].vdu}
    ${extCP_count}=    Get Length    ${nfv.vnfd[0]['ext-cpd']}
    ${virtualLink_count}=    Get length    ${nfv.vnfd[0]['int-virtual-link-desc']}
    ${instantiation_levels}=    Get Length    ${nfv.vnfd[0].df['instantiation-level']}    
    FOR    ${key}    IN    @{nfv.vnfd[0].keys()}
        ${VDU_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key}    vdu
        Run Keyword If    ${VDU_check}    Get VDU IDs    ${VDUcount}
        ${extCP_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key}    ext-cpd
        Run Keyword If    ${extCP_check}    Get External CP IDs    ${extCP_count}
        ${virtualLink_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key}    int-virtual-link-desc
        Run Keyword If    ${virtualLink_check}    Get Virtual Link IDs   ${virtualLink_count}    
        ${DF_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key}    df
        Run Keyword If    ${DF_check}    Get Instantiation Levels    ${instantiation_levels}    
    END
    Set Global Variable    ${Descriptor_ID}    ${descriptor_id}
    Set Global Variable    ${Provider}    ${provider}
    Set Global Variable    ${Product_Name}    ${product_name}
    Set Global Variable    ${Software_Version}    ${software_version}
    Set Global Variable    ${Descriptor_Version}    ${descriptor_version}
    
Get VDU IDs
    [Arguments]    ${count}
    Import Variables    ${CURDIR}/descriptors/SOL006/VNFD/vnfd_SOL006.yaml
    @{VDU_labels}=    Create List
    ${Storage_labels}=    Create List
    ${Compute_labels}=    Create List
    FOR    ${i}    IN RANGE    ${count}
        Append To List    ${VDU_labels}    ${nfv.vnfd[0].vdu[${i}]['id']}
        Append To List    ${Storage_labels}    ${nfv.vnfd[0].vdu[${i}]['virtual-storage-desc']} 
        Append To List    ${Compute_labels}    ${nfv.vnfd[0].vdu[${i}]['virtual-compute-desc']} 
        Get Internal CPs for each VDU    ${i}   
    END
    Set Global Variable    ${VDU_IDs}    ${VDU_labels}
    Set Global Variable    ${Storage_IDs}    ${Storage_labels}
    Set Global Variable    ${Compute_IDs}    ${Compute_labels}
            
Get Internal CPs for each VDU
    [Arguments]    ${vdu}
    Import Variables    ${CURDIR}/descriptors/SOL006/VNFD/vnfd_SOL006.yaml
    ${count}=    Get Length    ${nfv.vnfd[0].vdu[${vdu}]['int-cpd']}    
    ${internal_CPs}=    Create List
    FOR    ${i}    IN RANGE    ${count}
        Append To List    ${internal_CPs}    ${nfv.vnfd[0].vdu[${vdu}]['int-cpd'][${i}]['id']} 
    END
    Set Global Variable    ${internalCP_IDs}    ${internal_CPs}
    
Get External CP IDs
    [Arguments]    ${count} 
    Import Variables    ${CURDIR}/descriptors/SOL006/VNFD/vnfd_SOL006.yaml   
    @{external_CPs}=    Create List
    FOR    ${i}    IN RANGE    ${count}
        Append To List    ${external_CPs}    ${nfv.vnfd[0].ext_cpd[${i}].id} 
    END
    Set Global Variable    ${externalCP_IDs}    ${external_CPs}

Get Virtual Link IDs
    [Arguments]    ${count} 
    Import Variables    ${CURDIR}/descriptors/SOL006/VNFD/vnfd_SOL006.yaml   
    ${VirtualLink_labels}=    Create List
    FOR    ${i}    IN RANGE    ${count}
        Append To List    ${VirtualLink_labels}    ${nfv.vnfd[0]['int-virtual-link-desc'][${i}]['id']} 
    END
    Set Global Variable    ${VirtualLink_IDs}    ${VirtualLink_labels}

Get Instantiation Levels
    [Arguments]    ${count}
    Import Variables    ${CURDIR}/descriptors/SOL006/VNFD/vnfd_SOL006.yaml
    @{Instantiation_Levels}=    Create List
    FOR    ${i}    IN RANGE    ${count}
        Append To List    ${Instantiation_Levels}    ${nfv.vnfd[0].df['instantiation-level'][${i}]['id']} 
    END
    Set Global Variable    ${InstantiationLevel_IDs}    ${Instantiation_Levels}
    
Match the grant Response Attributes with Descriptors
    Run Keyword If  '${descriptorType}'=='SOL006'    List Should Contain Value    ${externalCP_IDs}    ${response['body']['extVirtualLinks'][0]['extCps'][0]['cpdId']}
    Run Keyword If  '${descriptorType}'=='SOL001'    List Should Contain Value    @{CP_IDs}    ${response['body']['extVirtualLinks'][0]['extCps'][0]['cpdId']}
    List Should Contain Value    ${VirtualLink_IDs}    ${response['body']['extManagedVirtualLinkData'][0]['vnfVirtualLinkDescId']}
    List Should Contain value    ${Compute_IDs}    ${response['body']['vimAssets']['computeResourceFlavours'][0]['vnfdVirtualComputeDescId']}

JWT Encode
    [Arguments]    ${payload}    ${key}    ${algorithm}
    ${encoded}=    Evaluate    jwt.encode(${payload}, ${key}, ${algorithm})
    [Return]    ${encoded}