*** Settings ***
Library    String
Resource   environment/variables.txt
Resource   VNFLifecycleOperationGrantingKeywords.robot  
Library    REST    ${NFVO_SCHEMA}://${NFVO_HOST}:${NFVO_PORT}    ssl_verify=false
Library    OperatingSystem
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/
Library    Collections
#Variables    descriptors/SOL001/VNFD/vnfd_SOL001.yaml
#Variables    descriptors/SOL006/VNFD/vnfd_SOL006.yaml
Documentation    This resource represents grants. The client can use this resource to obtain permission
...     from the NFVO to perform a particular VNF lifecycle operation.

*** Variables ***
${retry}   2 min
${polling}    10 sec

*** Test Cases ***
Requests a grant for a particular VNF lifecycle operation - Synchronous mode
    [Documentation]    Test ID: 7.3.2.1.1
    ...    Test title: Requests a grant for a particular VNF lifecycle operation - Synchronous mode
    ...    Test objective: The objective is to request a grant for a particular VNF lifecycle operation and perform a JSON schema validation on the returned grant data structure
    ...    Pre-conditions: none
    ...    Reference: Clause 9.4.2.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: The NFVO can decide immediately what to respond to a grant request
    ...    Post-Conditions: The grant information is available to the VNFM.
    Send Request Grant Request in Synchronous mode
    Check HTTP Response Status Code Is    201
    Check Operation Occurrence Id existence 
    Check HTTP Response Body Json Schema Is    grant

Requests a grant for a particular VNF lifecycle operation - Asynchronous mode
    [Documentation]    Test ID: 7.3.2.1.2
    ...    Test title: Requests a grant for a particular VNF lifecycle operation - Asynchronous mode
    ...    Test objective: The objective is to request a grant for a particular VNF lifecycle operation and perform a JSON schema validation on the returned grant data structure
    ...    Pre-conditions: none
    ...    Reference: Clause 9.4.2.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: The NFVO can not decide immediately what to respond to a grant request
    ...    Post-Conditions: The grant information is available to the VNFM.
    Send Request Grant Request in Asynchronous mode
    Check HTTP Response Status Code Is    202
    Check Operation Occurrence Id existence 
    Check HTTP Response Body Json Schema Is    grant
    Wait for individual grant successful notification 

Requests a grant for a particular VNF lifecycle operation - Forbidden 
    [Documentation]    Test ID: 7.3.2.1.3
    ...    Test title: Requests a grant for a particular VNF lifecycle operation - Forbidden 
    ...    Test objective: The objective is to request a grant for a particular VNF lifecycle operation and the grant is rejected
    ...    Pre-conditions: none
    ...    Reference: Clause 9.4.2.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Request for a new Grant Forbiden Operation
    Check HTTP Response Status Code Is    403
    Check HTTP Response Body Json Schema Is    ProblemDetails

GET Grants - Method not implemented
    [Documentation]    Test ID: 7.3.2.1.4
    ...    Test title: GET Grants - Method not implemented
    ...    Test objective: The objective is to test that GET method is not allowed for Life cycle operation granting 
    ...    Pre-conditions: none
    ...    Reference: Clause 9.4.2.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions:   none
    Get Grants
    Check HTTP Response Status Code Is    405
    
PUT Grants - Method not implemented
    [Documentation]    Test ID: 7.3.2.1.5
    ...    Test title: PUT Grants - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not allowed for Life cycle operation granting 
    ...    Pre-conditions: none
    ...    Reference: Clause 9.4.2.3.3 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Put Grants
    Check HTTP Response Status Code Is    405
    
PATCH Grants - Method not implemented
    [Documentation]    Test ID: 7.3.2.1.6
    ...    Test title: PATCH Grants - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not allowed for Life cycle operation granting  
    ...    Pre-conditions: none
    ...    Reference: Clause 9.4.2.3.4 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none 
    Patch Grants
    Check HTTP Response Status Code Is    405
    
DELETE Grants - Method not implemented
    [Documentation]    Test ID: 7.3.2.1.7
    ...    Test title: DELETE Grants - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not allowed for Life cycle operation granting  
    ...    Pre-conditions: none
    ...    Reference: Clause 9.4.2.3.5 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions:  resources are not deleted
    Delete Grants
    Check HTTP Response Status Code Is    405

Requests a grant for a particular VNF lifecycle operation - Synchronous mode using instantiationLevelId for Target size
    [Documentation]    Test ID: 7.3.2.1.8
    ...    Test title: Requests a grant for a particular VNF lifecycle operation - Synchronous mode using instantiationLevelId for Target size 
    ...    Test objective: The objective is to request a grant for a particular VNF lifecycle operation and perform a JSON schema validation on the returned grant data structure
    ...    Pre-conditions: none
    ...    Reference: Clause 9.4.2.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: The NFVO can decide immediately what to respond to a grant request
    ...    Post-Conditions: The grant information is available to the VNFM.
    Send Request Grant Request in Synchronous mode with attribute instantiationLevelId
    Check HTTP Response Status Code Is    201
    Check Operation Occurrence Id existence 
    Check HTTP Response Body Json Schema Is    grant    

Requests a grant for a particular VNF lifecycle operation - Synchronous mode using targetScaleLevelInfo for Target size
    [Documentation]    Test ID: 7.3.2.1.9
    ...    Test title: Requests a grant for a particular VNF lifecycle operation - Synchronous mode using targetScaleLevelInfo for Target size 
    ...    Test objective: The objective is to request a grant for a particular VNF lifecycle operation and perform a JSON schema validation on the returned grant data structure
    ...    Pre-conditions: none
    ...    Reference: Clause 9.4.2.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: The NFVO can decide immediately what to respond to a grant request
    ...    Post-Conditions: The grant information is available to the VNFM.
    Send Request Grant Request in Synchronous mode with attribute targetScaleLevelInfo
    Check HTTP Response Status Code Is    201
    Check Operation Occurrence Id existence 
    Check HTTP Response Body Json Schema Is    grant    

Requests a grant for a particular VNF lifecycle operation - Synchronous mode using attribute addResources for Target size
    [Documentation]    Test ID: 7.3.2.1.10
    ...    Test title: Requests a grant for a particular VNF lifecycle operation - Synchronous mode using with attribute addResources for Target size 
    ...    Test objective: The objective is to request a grant for a particular VNF lifecycle operation and perform a JSON schema validation on the returned grant data structure
    ...    Pre-conditions: none
    ...    Reference: Clause 9.4.2.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: The NFVO can decide immediately what to respond to a grant request
    ...    Post-Conditions: The grant information is available to the VNFM.
    Send Request Grant Request in Synchronous mode with attribute addResources
    Check HTTP Response Status Code Is    201
    Check Operation Occurrence Id existence 
    Check HTTP Response Body Json Schema Is    grant

Requests a grant for a particular VNF lifecycle operation - Synchronous mode with permitted authorization scope
    [Documentation]    Test ID: 7.3.2.1.11
    ...    Test title: Requests a grant for a particular VNF lifecycle operation - Synchronous mode with permitted authorization scope
    ...    Test objective: The objective is to request a grant for a particular VNF lifecycle operation and perform a JSON schema validation on the returned grant data structure with permitted authorization scope
    ...    Pre-conditions: none
    ...    Reference: Clause 9.4.2.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: The NFVO can decide immediately what to respond to a grant request
    ...    Post-Conditions: The grant information is available to the VNFM.
    Send Request Grant Request in Synchronous mode with permitted authorization scope
    Check HTTP Response Status Code Is    201
    Check Operation Occurrence Id existence 
    Check HTTP Response Body Json Schema Is    grant

Requests a grant for a particular VNF lifecycle operation - Synchronous mode with not permitted authorization scope
    [Documentation]    Test ID: 7.3.2.1.12
    ...    Test title: Requests a grant for a particular VNF lifecycle operation - Synchronous mode with not permitted authorization scope
    ...    Test objective: The objective is to request a grant for a particular VNF lifecycle operation and perform a JSON schema validation on the returned grant data structure with not permitted authorization scope
    ...    Pre-conditions: none
    ...    Reference: Clause 9.4.2.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: The NFVO can decide immediately what to respond to a grant request
    ...    Post-Conditions: The grant information is available to the VNFM.
    Send Request Grant Request in Synchronous mode with not permitted authorization scope
    Check HTTP Response Status Code Is    403
    Check HTTP Response Body Json Schema Is    ProblemDetails

*** Keywords ***
Wait for individual grant successful notification
    Wait Until Keyword Succeeds    ${retry}   ${polling}    Get an individual grant - Successful