*** Settings ***
Resource    VnfLcmMntOperationKeywords.robot

*** Test Cases ***
POST Create a new VNF Snapshot
    [Documentation]    Test ID: 7.3.1.40.1
    ...    Test title: POST Create a new VNF Snapshot
    ...    Test objective: The objective is to create a new VNF snapshot
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.23.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: VNF snapshot is created
    POST Create a new VNF Snapshot
    Check HTTP Response Status Code Is    201
    Check HTTP Response Body Json Schema Is    VnfSnapshotInfo
    Check HTTP Location Header Contains URI of Created Resource

GET information about multiple VNF Snapshots  
    [Documentation]    Test ID: 7.3.1.40.2
    ...    Test title: GET information about multiple VNF Snapshots
    ...    Test objective: The objective is to get information about multiples VNF snapshots
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.23.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple VNF Snapshots
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    VnfSnapshotsInfo
    
GET information about multiple VNF Snapshots Bad Request Invalid attribute-based filtering parameters
    [Documentation]    Test ID: 7.3.1.40.3
    ...    Test title: GET information about multiple VNF Snapshots Bad Request Invalid attribute-based filtering parameters
    ...    Test objective: The objective is to get information about multiples VNF Snapshots with Invalid attribute-based filtering parameters
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.23.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple VNF Snapshots with bad attribute
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is   ProblemDetails

GET information about multiple VNF Snapshots Bad Request Invalid attribute selector
    [Documentation]    Test ID: 7.3.1.40.4
    ...    Test title: GET information about multiple VNF Snapshots Bad Request Invalid attribute selector
    ...    Test objective: The objective is to get information about multiples VNF Snapshots with Invalid attribute-based filtering parameters
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.23.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple VNF Snapshots with bad filter
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is   ProblemDetails

GET information about multiple VNF Snapshots with "all_fields" attribute selector
    [Documentation]    Test ID: 7.3.1.40.5
    ...    Test title: GET information about multiple VNF Snapshots with "all_fields" attribute selector
    ...    Test objective: The objective is to query information about multiple VNF Snapshots
    ...    Pre-conditions:  none
    ...    Reference: Clause 5.4.23.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple VNF Snapshots with all_fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    VnfSnapshotsInfo

GET information about multiple VNF Snapshots with "exclude_default" attribute selector
    [Documentation]    Test ID: 7.3.1.40.6
    ...    Test title: GET information about multiple VNF Snapshots with "exclude_default" attribute selector
    ...    Test objective: The objective is to query information about multiple VNF Snapshots
    ...    Pre-conditions:  none
    ...    Reference: Clause 5.4.23.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple VNF Snapshots with exclude_default attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    VnfSnapshotsInfo
    
GET information about multiple VNF Snapshots with "fields" attribute selector
    [Documentation]    Test ID: 7.3.1.40.7
    ...    Test title: GET information about multiple VNF Snapshots with "fields" attribute selector
    ...    Test objective: The objective is to query information about multiple VNF Snapshots
    ...    Pre-conditions:  none
    ...    Reference: Clause 5.4.23.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple VNF Snapshots with fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    VnfSnapshotsInfo

GET information about multiple VNF Snapshots with "exclude_default" and "fields" attribute selector
    [Documentation]    Test ID: 7.3.1.40.8
    ...    Test title: GET information about multiple VNF Snapshots with "exclude_default" and "fields" attribute selector
    ...    Test objective: The objective is to query information about multiple VNF Snapshots
    ...    Pre-conditions:  none
    ...    Reference: Clause 5.4.23.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple VNF Snapshots with exclude_default and fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    VnfSnapshotsInfo
    
GET information about multiple VNF Snapshots with "exclude_fields" attribute selector
    [Documentation]    Test ID: 7.3.1.40.9
    ...    Test title: GET information about multiple VNF Snapshots with "exclude_fields" attribute selector
    ...    Test objective: The objective is to query information about multiple VNF Snapshots
    ...    Pre-conditions:  none
    ...    Reference: Clause 5.4.23.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple VNF Snapshots with exclude_fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    VnfSnapshotsInfo  
    
GET VNF Snapshots - Bad Request Response too Big
    [Documentation]    Test ID: 7.3.1.40.10
    ...    Test title: GET VNF Snapshots - Bad Request Response too Big
    ...    Test objective: The objective is test that the retrieval of existing VNF Snapshots list fails because response is too big, and perform the JSON schema validation of the failed operation HTTP response.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.23.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: VNFM does not support paged response.
    ...    Post-Conditions: none 
    GET VNF Snapshots without Paging support
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is    ProblemDetails

GET VNF Snapshots as Paged Response
    [Documentation]    Test ID: 7.3.1.40.11
    ...    Test title: GET VNF Snapshots as Paged Response
    ...    Test objective: The objective is to test that GET method retrieves the list of existing VNF Snapshots as paged response.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.23.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: VNFM supports paged response.
    ...    Post-Conditions: none    
    GET VNF Snapshots with Paging support
    Check HTTP Response Status Code Is  200
    Check HTTP Response Header Contains Link
        
PUT VNF Snapshots - Method not implemented
    [Documentation]    Test ID: 7.3.1.40.12
    ...    Test title: PUT VNF Snapshots - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not implemented
    ...    Pre-conditions:  none
    ...    Reference: Clause 5.4.23.3.3 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    PUT VNF Snapshots
    Check HTTP Response Status Code Is    405

PATCH VNF Snapshots - Method not implemented
    [Documentation]    Test ID: 7.3.1.40.13
    ...    Test title: PATCH VNF Snapshots - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not implemented
    ...    Pre-conditions: none 
    ...    Reference: Clause 5.4.23.3.4 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH VNF Snapshots
    Check HTTP Response Status Code Is    405

DELETE VNF Snapshots - Method not implemented
    [Documentation]    Test ID: 7.3.1.40.14
    ...    Test title: DELETE VNF Snapshots - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not implemented
    ...    Pre-conditions: none 
    ...    Reference: Clause 5.4.23.3.5 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: VNF instance not deleted
    DELETE VNF Snapshots
    Check HTTP Response Status Code Is    405
    
GET information about multiple VNF Snapshots using Filter
    [Documentation]    Test ID: 7.3.1.40.15
    ...    Test title: GET information about multiple VNF Snapshots using Filter
    ...    Test objective: The objective is to get information about multiples VNF snapshots using filter
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.23.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple VNF Snapshots using filter
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    VnfSnapshotsInfo

POST Create a new VNF Snapshot with permitted authorization scope
    [Documentation]    Test ID: 7.3.1.40.16
    ...    Test title: POST Create a new VNF Snapshot with permitted authorization scope
    ...    Test objective: The objective is to create a new VNF snapshot with permitted authorization scope
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.23.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: VNF snapshot is created
    POST Create a new VNF Snapshot with permitted authorization scope
    Check HTTP Response Status Code Is    201
    Check HTTP Response Body Json Schema Is    VnfSnapshotInfo
    Check HTTP Location Header Contains URI of Created Resource

POST Create a new VNF Snapshot with not permitted authorization scope
    [Documentation]    Test ID: 7.3.1.40.17
    ...    Test title: POST Create a new VNF Snapshot with not permitted authorization scope
    ...    Test objective: The objective is to create a new VNF snapshot with not permitted authorization scope
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.23.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: VNF snapshot is created
    POST Create a new VNF Snapshot with not permitted authorization scope
    Check HTTP Response Status Code Is    403
    Check HTTP Response Body Json Schema Is   ProblemDetails