*** Settings ***
Resource          environment/variables.txt
Resource          VnfLcmMntOperationKeywords.robot
Library           REST    ${VNFM_SCHEMA}://${VNFM_HOST}:${VNFM_PORT}    ssl_verify=false
Library           OperatingSystem
Library           BuiltIn
Library           Collections
Library           JSONLibrary
Library           Process

*** Test Cases ***
POST Select VNF Deployable Module
    [Documentation]    Test ID: 7.3.1.43.1
    ...    Test title: POST Select VNF Deployable Module
    ...    Test objective: The objective is to select VNF Deployable Module
    ...    Pre-conditions: The VNF instance resource is in INSTANTIATED state
    ...    Reference: Clause 5.4.26.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    POST Select VNF Deployable Modules
    Check HTTP Response Status Code Is    202
    Check HTTP Response Header Contains    Location
    Check Individual VNF LCM operation occurrence operationState is    STARTING

POST Select VNF Deployable Module Not Found
    [Documentation]    Test ID: 7.3.1.43.2
    ...    Test title: POST Select VNF Deployable Module Not Found
    ...    Test objective: The objective is to test that the POST Select VNF Deployable Module fails when the resource is not present.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.26.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    POST Select VNF Deployable Modules Not Existing
    Check HTTP Response Status Code Is    404
    Check HTTP Response Body Json Schema Is    ProblemDetails

POST Select VNF Deployable Module with conflict (Not Instantiated)
    [Documentation]    Test ID: 7.3.1.43.3
    ...    Test title: POST Operate a vnfInstance Conflict (Not-Instantiated)
    ...    Test objective: The objective is to test that the operation fails when there is a conflict with the resource state.
    ...    Pre-conditions: the VNF instance resource is in NOT-INSTANTIATED state
    ...    Reference: Clause 5.4.26.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    POST Select VNF Deployable Modules with conflict
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is    ProblemDetails

GET Select VNF Deployable Module - Method not implemented
    [Documentation]    Test ID: 7.3.1.43.4
    ...    Test title: GET Select VNF Deployable Module - Method not implemented
    ...    Test objective: The objective is to verify that the method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.26.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Select VNF Deployable Modules
    Check HTTP Response Status Code Is    405

PUT Select VNF Deployable Module - Method not implemented
    [Documentation]    Test ID: 7.3.1.43.5
    ...    Test title: PUT Select VNF Deployable Module - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.26.3.3 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    PUT Select VNF Deployable Modules
    Check HTTP Response Status Code Is    405

PATCH Select VNF Deployable Module - Method Not implemented
    [Documentation]    Test ID: 7.3.1.43.6
    ...    Test title: PATCH Select VNF Deployable Module - Method Not implemented
    ...    Test objective: The objective is to test that PATCH method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.26.3.4 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH Select VNF Deployable Modules
    Check HTTP Response Status Code Is    405

DELETE Select VNF Deployable Module - Method Not implemented
    [Documentation]    Test ID: 7.3.1.43.7
    ...    Test title: DELETE Select VNF Deployable Module - Method Not implemented
    ...    Test objective: The objective is to test that DELETE method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.26.3.5 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    DELETE Select VNF Deployable Modules
    Check HTTP Response Status Code Is    405