*** Settings ***
# Suite setup     Expect spec    SOL003-VNFLifecycleManagement-API.yaml
Resource    environment/variables.txt
Library    REST    ${VNFM_SCHEMA}://${VNFM_HOST}:${VNFM_PORT}    ssl_verify=false
Resource    VnfLcmMntOperationKeywords.robot
Library    OperatingSystem
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/

*** Test Cases ***
POST Create a new vnfInstance
    [Documentation]    Test ID: 7.3.1.1.1
    ...    Test title: POST Create a new vnfInstance
    ...    Test objective: The objective is to create a new VNF instance resource
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.2.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: VNF instance created
    POST Create a new vnfInstance
    Check HTTP Response Status Code Is    201
    Check HTTP Response Header Contains    Location
    Check HTTP Response Body Json Schema Is    vnfInstance

GET information about multiple VNF instances  
    [Documentation]    Test ID: 7.3.1.1.2
    ...    Test title: GET information about multiple VNF instances
    ...    Test objective: The objective is to query information about multiple VNF instances
    ...    Pre-conditions:  none
    ...    Reference: Clause 5.4.2.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple vnfInstances
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    vnfInstances

GET information about multiple VNF instances Bad Request Invalid attribute-based filtering parameters
    [Documentation]    Test ID: 7.3.1.1.3
    ...    Test title: GET information about multiple VNF instances Bad Request Invalid attribute-based filtering parameters
    ...    Test objective: The objective is to query information about multiple VNF instances with Invalid attribute-based filtering parameters
    ...    Pre-conditions:  A VNF is instantiated,  a bad filter selector (filter selectors are listed in Table 5.4.2.3.2-1  - ETSI GS NFV-SOL 003 [1] v5.1.1).
    ...    Reference: Clause 5.4.2.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple vnfInstances with bad attribute
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is    ProblemDetails
    

GET information about multiple VNF instances Bad Request Invalid attribute selector
    [Documentation]    Test ID: 7.3.1.1.4
    ...    Test title: GET information about multiple VNF instances Bad Request Invalid attribute selector
    ...    Test objective: The objective is to query information about multiple VNF instances with Invalid attribute selector
    ...    Pre-conditions:  A VNF is instantiated,  a bad attribute selector (attribute selectors are listed in Table 5.4.2.3.2-1  - ETSI GS NFV-SOL 003 [1] v5.1.1).
    ...    Reference: Clause 5.4.2.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple vnfInstances with bad filter
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is    ProblemDetails

GET information about multiple VNF instances with "all_fields" attribute selector
    [Documentation]    Test ID: 7.3.1.1.5
    ...    Test title: GET information about multiple VNF instances with "all_fields" attribute selector
    ...    Test objective: The objective is to query information about multiple VNF instances
    ...    Pre-conditions:  none
    ...    Reference: Clause 5.4.2.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple vnfInstances with all_fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    vnfInstances

GET information about multiple VNF instances with "exclude_default" attribute selector
    [Documentation]    Test ID: 7.3.1.1.6
    ...    Test title: GET information about multiple VNF instances with "exclude_default" attribute selector
    ...    Test objective: The objective is to query information about multiple VNF instances
    ...    Pre-conditions:  none
    ...    Reference: Clause 5.4.2.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple vnfInstances with exclude_default attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    vnfInstances
    
GET information about multiple VNF instances with "fields" attribute selector
    [Documentation]    Test ID: 7.3.1.1.7
    ...    Test title: GET information about multiple VNF instances with "fields" attribute selector
    ...    Test objective: The objective is to query information about multiple VNF instances
    ...    Pre-conditions: none 
    ...    Reference: Clause 5.4.2.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple vnfInstances with fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    vnfInstances

GET information about multiple VNF instances with "exclude_fields" attribute selector
    [Documentation]    Test ID: 7.3.1.1.8
    ...    Test title: GET information about multiple VNF instances with "exclude_fields" attribute selector
    ...    Test objective: The objective is to query information about multiple VNF instances
    ...    Pre-conditions:  none
    ...    Reference: Clause 5.4.2.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple vnfInstances with exclude_fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    vnfInstances  

PUT multiples VNFInstances - Method not implemented
    [Documentation]    Test ID: 7.3.1.1.9
    ...    Test title: PUT multiples VNFInstances - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not implemented
    ...    Pre-conditions:  none
    ...    Reference: Clause 5.4.2.3.3 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    PUT VNFInstances
	Check HTTP Response Status Code Is    405
	
PATCH multiples VNFInstances - Method not implemented
    [Documentation]    Test ID: 7.3.1.1.10
    ...    Test title: PATCH multiples VNFInstances - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not implemented
    ...    Pre-conditions:  none
    ...    Reference: Clause 5.4.2.3.4 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH VNFInstances
	Check HTTP Response Status Code Is    405

DELETE VNFInstances - Method not implemented
    [Documentation]    Test ID: 7.3.1.1.11
    ...    Test title: DELETE multiples VNFInstances - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not implemented
    ...    Pre-conditions: none 
    ...    Reference: Clause 5.4.2.3.5 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    DELETE VNFInstances
	Check HTTP Response Status Code Is    405
	
GET information about multiple VNF instances to get Paged Response
    [Documentation]    Test ID: 7.3.1.1.12
    ...    Test title: GET information about multiple VNF instances to get Paged Response
    ...    Test objective: The objective is to query information about multiple VNF instances to get Paged Response.
    ...    Pre-conditions:  none
    ...    Reference: Clause 5.4.2.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: The VNFM supports response paging for the subscriptions resources
    ...    Post-Conditions: none
    GET multiple vnfInstances
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Contain Link

GET information about multiple VNF instances as a Paged Response with nextpage_opauque_marker parameter 
    [Documentation]    Test ID: 7.3.1.1.12a
    ...    Test title: GET information about multiple VNF instances as a Paged Response with nextpage_opauque_marker parameter 
    ...    Test objective: The objective is to query information about multiple VNF instances as a Paged Response and retrieve the next page using the nextpage_opaque_marker parameter
    ...    Pre-conditions: A request for retrieving multiple VNF instances as a paged response has been successfully issued (Test ID 7.3.1.1.12)
    ...    Reference: Clause 5.4.2.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: The VNFM supports response paging for the VNF instance resources
    ...    Post-Conditions: none 
    Get multiple vnfInstances with nextpage_opaque_marker parameter 
    Check HTTP Response Status Code Is    200

GET information about multiple VNF instances - Bad Request Response too Big
    [Documentation]    Test ID: 7.3.1.1.13
    ...    Test title: GET information about multiple VNF instances - Bad Request Response too Big
    ...    Test objective: The objective is to query information about multiple VNF instances fails because response is too big. The test also checks the JSON schema of the unsuccessful operation HTTP response.
    ...    Pre-conditions:  A VNF is instantiated,  a bad attribute selector (attribute selectors are listed in Table 5.4.2.3.2-1  - ETSI GS NFV-SOL 003 [1] v5.1.1).
    ...    Reference: Clause 5.4.2.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple vnfInstances
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is    ProblemDetails
    
GET information about multiple VNF instances with "exclude_default" and "fields" attribute selector
    [Documentation]    Test ID: 7.3.1.1.14
    ...    Test title: GET information about multiple VNF instances with "exclude_default" and "fields" attribute selector
    ...    Test objective: The objective is to query information about multiple VNF instances
    ...    Pre-conditions: none 
    ...    Reference: Clause 5.4.2.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple vnfInstances with exclude_default and fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    vnfInstances
    
POST Create a new vnfInstance - Unprocessable Content
    [Documentation]    Test ID: 7.3.1.1.15
    ...    Test title: POST Create a new vnfInstance - Unprocessable Content
    ...    Test objective: The objective is to test that correct error code is returned when VNF package referenced by the "vnfdId" attribute in the "CreateVnfRequest" structure is not in the "ENABLED" state or does not exist.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.2.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: The VNF package referenced by the "vnfdId" attribute in the "CreateVnfRequest" structure is not in the "ENABLED" state or does not exist.
    ...    Post-Conditions: none
    POST Create a new vnfInstance - Not ENABLED
    Check HTTP Response Status Code Is    422
    Check HTTP Response Body Json Schema Is    ProblemDetails
    
GET information about multiple VNF instances using Filter
    [Documentation]    Test ID: 7.3.1.1.16
    ...    Test title: GET information about multiple VNF instances using Filter
    ...    Test objective: The objective is to query information about multiple VNF instances using filter
    ...    Pre-conditions:  none
    ...    Reference: Clause 5.4.2.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple vnfInstances using filter
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    vnfInstances

POST Create a new vnfInstance with permitted authorization scope
    [Documentation]    Test ID: 7.3.1.1.17
    ...    Test title: POST Create a new vnfInstance with permitted authorization scope
    ...    Test objective: The objective is to create a new VNF instance resource with permitted authorization scope
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.2.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: VNF instance created
    POST Create a new vnfInstance with permitted authorization scope
    Check HTTP Response Status Code Is    201
    Check HTTP Response Header Contains    Location
    Check HTTP Response Body Json Schema Is    vnfInstance

POST Create a new vnfInstance with not permitted authorization scope
    [Documentation]    Test ID: 7.3.1.1.18
    ...    Test title: POST Create a new vnfInstance with not permitted authorization scope
    ...    Test objective: The objective is to create a new VNF instance resource with not permitted authorization scope
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.2.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: VNF instance created
    POST Create a new vnfInstance with not permitted authorization scope
    Check HTTP Response Status Code Is    403
    Check HTTP Response Body Json Schema Is    ProblemDetails

POST Create a new vnfInstance - UNPROCESSABLE CONTENT
    [Documentation]    Test ID: 7.3.1.1.19
    ...    Test title: POST Create a new vnfInstance - UNPROCESSABLE CONTENT
    ...    Test objective: The objective is to test that a new VNF instance resource is not created when vnfdId of the referenced VNF package is not in ENABLED state or does not exist.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.2.3.1 - ETSI GS NFV-SOL 003 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: vnfdId of the referenced VNF package is not in ENABLED state or does not exist.
    ...    Post-Conditions: VNF instance not created
    POST Create a new vnfInstance with Invalid vnfdId
    Check HTTP Response Status Code Is    422
    Check HTTP Response Body Json Schema Is    ProblemDetails    