*** Settings ***
Resource    environment/variables.txt
Library    REST    ${VNFM_SCHEMA}://${VNFM_HOST}:${VNFM_PORT}     ssl_verify=false
Library    OperatingSystem
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/
Resource    VnfLcmMntOperationKeywords.robot
Suite Setup    Check resource existence

*** Test Cases ***
POST Scale a vnfInstance
    [Documentation]    Test ID: 7.3.1.4.1
    ...    Test title: POST Scale a vnfInstance
    ...    Test objective: The objective is to scale a VNF instance
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.5.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none 
    POST Scale vnfInstance
    Check HTTP Response Status Code Is    202
    Check HTTP Response Header Contains    Location
    Check Individual VNF LCM operation occurrence operationState is    STARTING

POST Scale a vnfInstance Conflict (Not-Instantiated)
    [Documentation]    Test ID: 7.3.1.4.2
    ...    Test title: POST Scale a vnfInstance Conflict (Not-Instantiated)
    ...    Test objective: The objective is to verify that the scale operation cannot be executed 
    ...    Pre-conditions:  VNF instance resource is in NOT-INSTANTIATED state
    ...    Reference: Clause 5.4.5.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    POST Scale vnfInstance with VNF NOT-INSTANTIATED 
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is    ProblemDetails 
    
POST Scale a vnfInstance Not Found
    [Documentation]    Test ID: 7.3.1.4.3
    ...    Test title: POST Scale a vnfInstance Not Found
    ...    Test objective: The objective is to verify that the operation cannot be executed currently, because the VNF instance resource is not found. 
    ...    Pre-conditions: none  
    ...    Reference: Clause 5.4.5.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    POST Scale vnfInstance with not existing VNF
    Check HTTP Response Status Code Is    404
    Check HTTP Response Body Json Schema Is    ProblemDetails 

GET Scale VNFInstance - Method not implemented
    [Documentation]    Test ID: 7.3.1.4.4
    ...    Test title: GET Scale VNFInstance - Method not implemented
    ...    Test objective: The objective is to verify that the method is not implemented
    ...    Pre-conditions:  none
    ...    Reference: Clause 5.4.5.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Scale vnfInstance
    Check HTTP Response Status Code Is    405

PUT Scale VNFInstance - Method not implemented
    [Documentation]    Test ID: 7.3.1.4.5
    ...    Test title: PUT Scale VNFInstance - Method not implemented
    ...    Test objective: The objective is to verify that the method is not implemented
    ...    Pre-conditions: none  
    ...    Reference: Clause 5.4.5.3.3 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    PUT Scale vnfInstance
    Check HTTP Response Status Code Is    405

PATCH Scale VNFInstance - Method not implemented
    [Documentation]    Test ID: 7.3.1.4.6
    ...    Test title: PATCH Scale VNFInstance - Method not implemented
    ...    Test objective: The objective is to verify that the method is not implemented
    ...    Pre-conditions: none 
    ...    Reference: Clause 5.4.5.3.4 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH Scale vnfInstance
    Check HTTP Response Status Code Is    405
    
DELETE Scale VNFInstance - Method not implemented
    [Documentation]    Test ID: 7.3.1.4.7
    ...    Test title: DELETE Scale VNFInstance - Method not implemented
    ...    Test objective: The objective is to verify that the method is not implemented
    ...    Pre-conditions: none  
    ...    Reference: Clause 5.4.5.3.5 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    DELETE Scale vnfInstance
    Check HTTP Response Status Code Is    405

POST Scale a vnfInstance with permitted authorization scope
    [Documentation]    Test ID: 7.3.1.4.8
    ...    Test title: POST Scale a vnfInstance with permitted authorization scope
    ...    Test objective: The objective is to scale a VNF instance with permitted authorization scope
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.5.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none 
    POST Scale vnfInstance with permitted authorization scope
    Check HTTP Response Status Code Is    202
    Check HTTP Response Header Contains    Location
    Check Individual VNF LCM operation occurrence operationState is    STARTING

POST Scale a vnfInstance with not permitted authorization scope
    [Documentation]    Test ID: 7.3.1.4.9
    ...    Test title: POST Scale a vnfInstance with not permitted authorization scope
    ...    Test objective: The objective is to scale a VNF instance with not permitted authorization scope
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.5.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none 
    POST Scale vnfInstance with not permitted authorization scope
    Check HTTP Response Status Code Is    403
    Check HTTP Response Body Json Schema Is    ProblemDetails

POST Scale a vnfInstance Scale Vertical - Compute
    [Documentation]    Test ID: 7.3.1.4.10
    ...    Test title: POST Scale a vnfInstance Scale Vertical - Compute
    ...    Test objective: The objective is to scale a VNF instance with vertical scaling in terms of compute
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.5.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none 
    POST Scale vnfInstance Scale Vertical Compute
    Check HTTP Response Status Code Is    202
    Check HTTP Response Header Contains    Location
    Check Individual VNF LCM operation occurrence operationState is    STARTING

POST Scale a vnfInstance Scale Vertical - Storage
    [Documentation]    Test ID: 7.3.1.4.11
    ...    Test title: POST Scale a vnfInstance Scale Vertical - Storage
    ...    Test objective: The objective is to scale a VNF instance with vertical scaling in terms of storage
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.5.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none 
    POST Scale vnfInstance Scale Vertical Storage
    Check HTTP Response Status Code Is    202
    Check HTTP Response Header Contains    Location
    Check Individual VNF LCM operation occurrence operationState is    STARTING

POST Scale a vnfInstance Scale Vertical - Oscontainer
    [Documentation]    Test ID: 7.3.1.4.12
    ...    Test title: POST Scale a vnfInstance Scale Vertical - Oscontainer
    ...    Test objective: The objective is to scale a VNF instance with vertical scaling in terms of oscontainer
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.5.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none 
    POST Scale vnfInstance Scale Vertical Oscontainer
    Check HTTP Response Status Code Is    202
    Check HTTP Response Header Contains    Location
    Check Individual VNF LCM operation occurrence operationState is    STARTING
*** Keywords ***
Check resource existence
    Set Headers    {"Accept":"${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId} 
    Integer    response status    200