*** Settings ***
Resource    environment/variables.txt
Library    REST    ${VNFM_SCHEMA}://${VNFM_HOST}:${VNFM_PORT}     ssl_verify=false
Library     OperatingSystem
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/
Resource    VnfLcmMntOperationKeywords.robot

Suite Setup    Check resource existence

*** Test Cases ***
POST Operate a vnfInstance
    [Documentation]    Test ID: 7.3.1.9.1
    ...    Test title: POST Operate a vnfInstance
    ...    Test objective: The objective is to test that POST method operate a VNF instance
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.10.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    POST Operate VNF
    Check HTTP Response Status Code Is    202
    Check Operation Occurrence Id existence

POST Operate a vnfInstance Conflict (Not-Instantiated)
    [Documentation]    Test ID: 7.3.1.9.2
    ...    Test title: POST Operate a vnfInstance Conflict (Not-Instantiated)
    ...    Test objective: The objective is to test that the operation cannot be executed currently, due to a conflict with the state of the VNF instance resource. 
    ...    Pre-conditions: the VNF instance resource is in NOT-INSTANTIATED state
    ...    Reference: Clause 5.4.10.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    POST Operate VNF with conflict
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is    ProblemDetails 

POST Operate a vnfInstance Not Found
    [Documentation]    Test ID: 7.3.1.9.3
    ...    Test title: POST Operate a vnfInstance Not Found
    ...    Test objective: The objective is to test that the operation cannot be executed currently, because the resource is not existing
    ...    Pre-conditions: the VNF instance resource is in  not existing
    ...    Reference: Clause 5.4.10.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    POST Operate VNF not existing
    Check HTTP Response Status Code Is    404
    Check HTTP Response Body Json Schema Is    ProblemDetails

GET Operate VNFInstance - Method not implemented
    [Documentation]    Test ID: 7.3.1.9.4
    ...    Test title: GET Operate a vnfInstance - Method not implemented
    ...    Test objective: The objective is to verify that the method is not implemented 
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.10.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Operate VNF
    Check HTTP Response Status Code Is    405

PUT Operate VNFInstance - Method not implemented
    [Documentation]    Test ID: 7.3.1.9.5
    ...    Test title: PUT Operate a vnfInstance - Method not implemented
    ...    Test objective: The objective is to verify that the method is not implemented 
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.10.3.3 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    PUT Operate VNF
    Check HTTP Response Status Code Is    405

PATCH Operate VNFInstance - Method not implemented
    [Documentation]    Test ID: 7.3.1.9.6
    ...    Test title: PATCH Operate a vnfInstance - Method not implemented
    ...    Test objective: The objective is to verify that the method is not implemented 
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.10.3.4 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH Operate VNF
    Check HTTP Response Status Code Is    405
    
DELETE Operate VNFInstance - Method not implemented
    [Documentation]    Test ID: 7.3.1.9.7
    ...    Test title: DELETE Operate a vnfInstance - Method not implemented
    ...    Test objective: The objective is to verify that the method is not implemented 
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.10.3.5 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    DELETE Operate VNF
    Check HTTP Response Status Code Is    405

POST Operate a vnfInstance with permitted authorization scope
    [Documentation]    Test ID: 7.3.1.9.8
    ...    Test title: POST Operate a vnfInstance with permitted authorization scope
    ...    Test objective: The objective is to test that POST method operate a VNF instance with permitted authorization scope
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.10.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    POST Operate VNF with permitted authorization scope
    Check HTTP Response Status Code Is    202
    Check Operation Occurrence Id existence

POST Operate a vnfInstance with not permitted authorization scope
    [Documentation]    Test ID: 7.3.1.9.9
    ...    Test title: POST Operate a vnfInstance with not permitted authorization scope
    ...    Test objective: The objective is to test that POST method operate a VNF instance with not permitted authorization scope
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.10.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    POST Operate VNF with not permitted authorization scope
    Check HTTP Response Status Code Is    403
    Check HTTP Response Body Json Schema Is    ProblemDetails
    
*** Keywords ***
Check resource existence
    Set Headers    {"Accept":"${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId} 
    Integer    response status    200
