*** Setting ***
Suite Setup       Initialize System
Suite Teardown    Terminate All Processes    kill=true
Resource    environment/variables.txt
Resource    VnfLcmMntOperationKeywords.robot
Resource    SubscriptionKeywords.robot
Library    OperatingSystem
Library    MockServerLibrary
Library    Process
Library    BuiltIn
Library    Collections
Library    String
Library    JSONSchemaLibrary    schemas/
Library    JSONLibrary
Library    REST    ${VNFM_SCHEMA}://${VNFM_HOST}:${VNFM_PORT}    ssl_verify=false

*** Test Cases ***
VNF Instantiation
    [Documentation]    Test ID: 7.3.1.26.1
    ...    Test title: VNF Instantiation workflow
    ...    Test objective: The objective is to test the workflow for the instantiation of a VNF instance
    ...    Pre-conditions: VNF instance resources is already created. NFVO is subscribed to VNF LCM Operation Occurrence notifications 
    ...    Reference: Clause 5.4.4 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability:  NFVO is able to receive notifications from VNFM
    ...    Post-Conditions: VNF instance in INSTANTIATED state
    Send VNF Instantiation Request
    Check HTTP Response Status Code Is    202
    Check HTTP Response Header Contains    Location
    Check Operation Occurrence Id existence
    Check Operation Notification For Instantiation  STARTING
    Check Operation Notification For Instantiation  PROCESSING
    Check Operation Notification For Instantiation  COMPLETED
    Check Postcondition VNF Status  INSTANTIATED

VNF Instantiation with attribute instantiationLevelId
    [Documentation]    Test ID: 7.3.1.26.2
    ...    Test title: VNF Instantiation workflow with attribute instantiationLevelId
    ...    Test objective: The objective is to test the workflow for the instantiation of a VNF instance
    ...    Pre-conditions: VNF instance resources is already created. NFVO is subscribed to VNF LCM Operation Occurrence notifications 
    ...    Reference: Clause 5.4.4 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability:  NFVO is able to receive notifications from VNFM
    ...    Post-Conditions: VNF instance in INSTANTIATED state
    Send VNF Instantiation Request with attribute instantiationLevelId
    Check HTTP Response Status Code Is    202
    Check HTTP Response Header Contains    Location
    Check Operation Occurrence Id existence
    Check Operation Notification For Instantiation  STARTING
    Check Operation Notification For Instantiation  PROCESSING
    Check Operation Notification For Instantiation  COMPLETED
    Check Postcondition VNF Status  INSTANTIATED

VNF Instantiation with attribute targetScaleLevelInfo 
    [Documentation]    Test ID: 7.3.1.26.3
    ...    Test title: VNF Instantiation workflow with attribute targetScaleLevelInfo 
    ...    Test objective: The objective is to test the workflow for the instantiation of a VNF instance
    ...    Pre-conditions: VNF instance resources is already created. NFVO is subscribed to VNF LCM Operation Occurrence notifications 
    ...    Reference: Clause 5.4.4 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability:  NFVO is able to receive notifications from VNFM
    ...    Post-Conditions: VNF instance in INSTANTIATED state
    Send VNF Instantiation Request with attribute targetScaleLevelInfo 
    Check HTTP Response Status Code Is    202
    Check HTTP Response Header Contains    Location
    Check Operation Occurrence Id existence
    Check Operation Notification For Instantiation  STARTING
    Check Operation Notification For Instantiation  PROCESSING
    Check Operation Notification For Instantiation  COMPLETED
    Check Postcondition VNF Status  INSTANTIATED    
    
*** Keywords ***
Send VNF Instantiation Request
    Log    Instantiate a VNF Instance
    Set Headers  {"Accept":"${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${body}=    Get File    jsons/instantiateVnfRequest.json
    ${response}=    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/instantiate    ${body}
    
Send VNF Instantiation Request with attribute instantiationLevelId
    Log    Instantiate a VNF Instance
    Set Headers  {"Accept":"${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/instantiateVnfRequestInstantiationLevelId.json
    ${body}=        Format String   ${template}    instantiationLevelId= ${instantiationLevelId}
    ${response}=    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/instantiate    ${body}

Send VNF Instantiation Request with attribute targetScaleLevelInfo 
    Log    Instantiate a VNF Instance
    Set Headers  {"Accept":"${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/instantiateVnfRequestTargetScaleLevelInfo.json
    ${body}=        Format String   ${template}    aspectId=${scaleAspectId}
    ${response}=    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/instantiate    ${body}
    
Check Operation Notification For Instantiation
    [Arguments]    ${status}
    Run Keyword If    ${SKIP_INTERMEDIATE_NOTIFICATION_CHECKS} == 0 or (${SKIP_INTERMEDIATE_NOTIFICATION_CHECKS} == 1 and '${status}' == 'COMPLETED')    Check Operation Notification    VnfLcmOperationOccurrenceNotification   ${status}

Initialize System
    Create Sessions

Check Postcondition VNF Status
    [Arguments]    ${status}
    Log    Retrieve VNF Instance
    Check VNF Instance    ${vnfInstanceId}
    Should Not Be Empty    ${response}
    Check HTTP Response Status Code Is    200
    Should Be Equal    ${response['body']['id']}    ${vnfInstanceId}    
    Check HTTP Response Header Contains    Content-Type
    Check HTTP Response Body Json Schema Is    vnfInstance.schema.json
    Check VNF Status    ${response['body']['instantiationState']}    ${status}