*** Settings ***
Library    String
Library    JSONSchemaLibrary    schemas/
Resource   environment/variables.txt
Resource   VNFIndicatorsKeywords.robot
Library    OperatingSystem
Library    REST    ${VNFM_SCHEMA}://${VNFM_HOST}:${VNFM_PORT}    ssl_verify=false
Suite Setup    Check resource existence and get CallbackUri

*** Test Cases ***
VNF Indicator Value Change Notification
    [Documentation]    Test ID: 7.3.6.8.1
    ...    Test title: VNF Indicator Value Change Notification
    ...    Test objective: The objective is to test that the POST request triggers VNF Indicator Value Change Notification.
    ...    Pre-conditions: A VNF is instantiated, and a subscription for indicator value change notifications is available in the VNFM.
    ...    Reference: Clause 8.4.7.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post VNF Indicator Value Change Notification
    Check HTTP Response Status Code Is    204
    
Supported Indicators Change Notification
    [Documentation]    Test ID: 7.3.6.8.2
    ...    Test title: Supported Indicators Change Notification
    ...    Test objective: The objective is to test that the POST request triggers Supported Indicators Change Notification.
    ...    Pre-conditions: A VNF is instantiated, and a individual subscription resource for supported indicators change notifications is available in the VNFM.
    ...    Reference: Clause 8.4.7.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post Supported Indicators Change Notification
    Check HTTP Response Status Code Is    204
Test the Notification Endpoint - Successful
    [Documentation]    Test ID: 7.3.6.8.3
    ...    Test title: Test the Notification Endpoint - Successful
    ...    Test objective: The objective is to test the Notification Endpoint provided by the notification consumer.
    ...    Pre-conditions: A notification endpoint is provided by the API consumer upon subscription.
    ...    Reference: Clause 8.4.7.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Get reach the notification endpoint
    Check HTTP Response Status Code Is    204
PUT Notification endpoint - Method Not Implemented
    [Documentation]    Test ID: 7.3.6.8.4
    ...    Test title: PUT Notification endpoint - Method Not Implemented
    ...    Test objective: The objective is to test the PUT method for Notification Endpoint provided by the consumer is not implemented.
    ...    Pre-conditions: A notification endpoint is provided by the API consumer upon subscription.
    ...    Reference: Clause 8.4.7.3.3 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    PUT notification endpoint
    Check HTTP Response Status Code Is    405
PATCH Notification endpoint - Method Not Implemented
    [Documentation]    Test ID:7.3.6.8.5
    ...    Test title: PATCH Notification endpoint - Method Not Implemented
    ...    Test objective: The objective is to test the PATCH method for Notification Endpoint provided by the consumer is not implemented.
    ...    Pre-conditions: A notification endpoint is provided by the API consumer upon subscription.
    ...    Reference: Clause 8.4.7.3.4 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    PATCH notification endpoint
    Check HTTP Response Status Code Is    405
DELETE Notification endpoint - Method Not Implemented
    [Documentation]    Test ID: 7.3.6.8.6
    ...    Test title: DELETE Notification endpoint - Method Not Implemented
    ...    Test objective: The objective is to test the DELETE method for Notification Endpoint provided by the consumer is not implemented.
    ...    Pre-conditions: A notification endpoint is provided by the API consumer upon subscription.
    ...    Reference: Clause 8.4.7.3.5 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    DELETE notification endpoint
    Check HTTP Response Status Code Is    405