*** Settings ***
Library    String
Library    OperatingSystem
Resource    environment/variables.txt
Resource    FaultManagement-APIKeyword.robot
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/
Library    REST    ${VNFM_SCHEMA}://${VNFM_HOST}:${VNFM_PORT}        ssl_verify=false
Suite Setup    Check resource existence and get CallbackUri

*** Test Cases ***
VNF Fault Alarm Notification
    [Documentation]    Test ID: 7.3.5.7.1
    ...    Test title: VNF Fault Alarm Notification
    ...    Test objective: The objective is to test that the POST request triggers VNF Fault Alarm Notification.
    ...    Pre-conditions: A VNF instance is instantiated, and a subscription for fault alarm notifications is available in the VNFM.
    ...    Reference: Clause 7.4.6.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post Alarm Notification
    Check HTTP Response Status Code Is    204
    
VNF Fault Alarm Cleared Notification
    [Documentation]    Test ID: 7.3.5.7.2
    ...    Test title: VNF Fault Alarm Cleared Notification
    ...    Test objective: The objective is to test that the POST request triggers VNF Fault Alarm Cleared Notification.
    ...    Pre-conditions: A VNF instance is instantiated, and a subscription for fault alarm cleared notifications is available in the VNFM.
    ...    Reference: Clause 7.4.6.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post Alarm Cleared Notification
    Check HTTP Response Status Code Is    204
    
VNF Fault Alarm List Reulit Notification
    [Documentation]    Test ID: 7.3.5.7.3
    ...    Test title: VNF Fault Alarm List Rebuilt Notification
    ...    Test objective: The objective is to test that the POST request triggers VNF Fault Alarm List Rebuilt Notification.
    ...    Pre-conditions: A VNF instance is instantiated, and a subscription for fault alarm list rebuilt notifications is available in the VNFM.
    ...    Reference: Clause 7.4.6.3.1 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post Alarm List Rebuilt Notification
    Check HTTP Response Status Code Is    204
Test the Notification Endpoint - Successful
    [Documentation]    Test ID: 7.3.5.7.4
    ...    Test title: Test the Notification Endpoint - Successful
    ...    Test objective: The objective is to test the Notification Endpoint provided by the notification consumer.
    ...    Pre-conditions: A notification endpoint is provided by the API consumer upon subscription.
    ...    Reference: Clause 7.4.6.3.2 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Get reach the notification endpoint
    Check HTTP Response Status Code Is    204
PUT Notification endpoint - Method Not Implemented
    [Documentation]    Test ID: 7.3.5.7.5
    ...    Test title: PUT Notification endpoint - Method Not Implemented
    ...    Test objective: The objective is to test the PUT method for Notification Endpoint provided by the consumer is not implemented.
    ...    Pre-conditions: A notification endpoint is provided by the API consumer upon subscription.
    ...    Reference: Clause 7.4.6.3.3 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    PUT notification endpoint
    Check HTTP Response Status Code Is    405
PATCH Notification endpoint - Method Not Implemented
    [Documentation]    Test ID: 7.3.5.7.6
    ...    Test title: PATCH Notification endpoint - Method Not Implemented
    ...    Test objective: The objective is to test the PATCH method for Notification Endpoint provided by the consumer is not implemented.
    ...    Pre-conditions: A notification endpoint is provided by the API consumer upon subscription.
    ...    Reference: Clause 7.4.6.3.4 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    PATCH notification endpoint
    Check HTTP Response Status Code Is    405
DELETE Notification endpoint - Method Not Implemented
    [Documentation]    Test ID: 7.3.5.7.7
    ...    Test title: DELETE Notification endpoint - Method Not Implemented
    ...    Test objective: The objective is to test the DELETE method for Notification Endpoint provided by the consumer is not implemented.
    ...    Pre-conditions: A notification endpoint is provided by the API consumer upon subscription.
    ...    Reference: Clause 7.4.6.3.5 - ETSI GS NFV-SOL 003 [1] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    DELETE notification endpoint
    Check HTTP Response Status Code Is    405