*** Settings ***
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt
Library           JSONLibrary
Library           OperatingSystem
Library           String
Library           REST    ${VNFM_SCHEMA}://${VNFM_HOST}:${VNFM_PORT}    ssl_verify=false
Resource          VNFPerformanceManagementKeywords.robot
Suite Setup    Check resource existence and get CallbackUri

*** Test Cases ***
VNF Performance Information Availability Notification
    [Documentation]    Test ID: 6.3.3.10.1
    ...    Test title: VNF Performance Information Availability Notification
    ...    Test objective: The objective is to test that VNF Performance Information Availability Notification is delivered with success to the notification consumer
    ...    Pre-conditions: A VNF performance job is created, and a subscription for information availability notifications is available in the VNFM.
    ...    Reference: Clause 6.4.9.3.1 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post VNF Performance Information Availability Notification
    Check HTTP Response Status Code Is    204
    
VNF Threshold Crossed Notification
    [Documentation]    Test ID: 6.3.3.10.2
    ...    Test title: VNF Threshold Crossed Notification
    ...    Test objective: The objective is to test that VNF Threshold Crossed Notification is delivered with success to the notification consumer
    ...    Pre-conditions: A VNF performance job is created, and a subscription for Threshold Crossed Notification is available in the VNFM.
    ...    Reference: Clause 6.4.9.3.1 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post VNF Threshold Crossed Notification
    Check HTTP Response Status Code Is    204
Test the Notification Endpoint - Successful
    [Documentation]    Test ID: 6.3.3.10.3
    ...    Test title: Test the Notification Endpoint - Successful
    ...    Test objective: The objective is to test the Notification Endpoint provided by the notification consumer.
    ...    Pre-conditions: A notification endpoint is provided by the API consumer upon subscription.
    ...    Reference: Clause 6.4.9.3.2 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Get reach the notification endpoint
    Check HTTP Response Status Code Is    204
PUT Notification endpoint - Method Not Implemented
    [Documentation]    Test ID: 6.3.3.10.4
    ...    Test title: PUT Notification endpoint - Method Not Implemented
    ...    Test objective: The objective is to test the PUT method for Notification Endpoint provided by the consumer is not implemented.
    ...    Pre-conditions: A notification endpoint is provided by the API consumer upon subscription.
    ...    Reference: Clause 6.4.9.3.3 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    PUT notification endpoint
    Check HTTP Response Status Code Is    405
PATCH Notification endpoint - Method Not Implemented
    [Documentation]    Test ID: 6.3.3.10.5
    ...    Test title: PATCH Notification endpoint - Method Not Implemented
    ...    Test objective: The objective is to test the PATCH method for Notification Endpoint provided by the consumer is not implemented.
    ...    Pre-conditions: A notification endpoint is provided by the API consumer upon subscription.
    ...    Reference: Clause 6.4.9.3.4 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    PATCH notification endpoint
    Check HTTP Response Status Code Is    405
DELETE Notification endpoint - Method Not Implemented
    [Documentation]    Test ID: 6.3.3.10.6
    ...    Test title: DELETE Notification endpoint - Method Not Implemented
    ...    Test objective: The objective is to test the DELETE method for Notification Endpoint provided by the consumer is not implemented.
    ...    Pre-conditions: A notification endpoint is provided by the API consumer upon subscription.
    ...    Reference: Clause 6.4.9.3.5 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none
    DELETE notification endpoint
    Check HTTP Response Status Code Is    405
    
*** Keywords ***
Check resource existence and get CallbackUri
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}	
    Integer    response status    200
    Validate Json    response body    PmJob.schema.json
    Set Global Variable    ${callbackResp}    response body callbackUri
    
Check HTTP Response Status Code Is
    [Arguments]    ${expected_status}
    ${status}=    Convert To Integer    ${expected_status}    
    Should Be Equal    ${response['status']}    ${status} 
    Log    Status code validated
    
Post VNF Performance Information Availability Notification
    log    Trying to perform a POST to get notification
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template} =    Get File    jsons/PerformanceInformationAvaliableNotification.json
    ${body}=        Format String   ${template}    objectInstanceId=${objectInstanceId} 
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	

Post VNF Threshold Crossed Notification
    log    Trying to perform a POST to get notification
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"} 
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template} =    Get File    jsons/ThresholdCrossedNotification.json
    ${body}=        Format String   ${template}    thresholdId=${thresholdId}    objectInstanceId=${objectInstanceId} 
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	
