*** Settings ***
Library     JSONSchemaLibrary    schemas/
Resource    environment/variables.txt    # Generic Parameters
Resource    VNFPerformanceManagementKeywords.robot
Library     JSONLibrary
Library     REST    ${VNFM_SCHEMA}://${VNFM_HOST}:${VNFM_PORT}    ssl_verify=false
Library     OperatingSystem
Library     DependencyLibrary
Library           String

*** Test Cases ***
GET individual VNF Performance Job
    [Documentation]    Test ID: 6.3.3.2.1
    ...    Test title: Get individual VNF Performance Job
    ...    Test objective: The objective is to test the retrieval of an individual VNF performance monitoring job and perform a JSON schema and content validation of the collected job data structure
    ...    Pre-conditions: A VNF instance is instantiated. One or more VNF performance jobs are set in the VNFM.
    ...    Reference: Clause 6.4.3.3.2 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    GET individual VNF Performance Job
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Contains ETag and Last-Modified
    Check HTTP Response Body Json Schema Is   PmJob
    Check HTTP Response Body Pm Job Identifier matches the requested Pm Job

GET individual VNF Performance Job with invalid resource identifier
    [Documentation]    Test ID: 6.3.3.2.2
    ...    Test title: Get individual VNF Performance Job with invalid resource identifier
    ...    Test objective: The objective is to test that the retrieval of an individual VNF performance monitoring job fails when using an invalid resource identifier, and perform the JSON schema validation of the failed operation HTTP response
    ...    Pre-conditions: A VNF instance is instantiated. One or more VNF performance jobs are set in the VNFM.
    ...    Reference: Clause 6.4.3.3.2 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    GET individual VNF Performance Job with invalid resource identifier
    Check HTTP Response Status Code Is    404
    Check HTTP Response Body Json Schema Is   ProblemDetails

DELETE Individual VNF Performance Job
    [Documentation]    Test ID: 6.3.3.2.3
    ...    Test title: Delete Individual VNF Performance Job
    ...    Test objective: The objective is to test the deletion of an individual VNF performance monitoring job
    ...    Pre-conditions: A VNF instance is instantiated. One or more VNF performance jobs are set in the VNFM.
    ...    Reference: Clause 6.4.3.3.5 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: The VNF Performance Job is no more available in the VNFM    
    Send Delete request for individual VNF Performance Job
    Check HTTP Response Status Code Is    204
    Check Postcondition VNF Pm Job is Deleted

DELETE Individual VNF Performance Job with invalid resource identifier
    [Documentation]    Test ID: 6.3.3.2.4
    ...    Test title: Delete individual VNF Performance Job with invalid resource identifier
    ...    Test objective: The objective is to test that the deletion of an individual VNF performance monitoring job fails when using an invalid resource identifier, and perform the JSON schema validation of the failed operation HTTP response
    ...    Pre-conditions: A VNF instance is instantiated. One or more VNF performance jobs are set in the VNFM.
    ...    Reference: Clause 6.4.3.3.5 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Delete request for individual VNF Performance Job with invalid resource identifier
    Check HTTP Response Status Code Is    404
    Check HTTP Response Body Json Schema Is   ProblemDetails

POST Individual VNF Performance Job - Method not implemented
    [Documentation]    Test ID: 6.3.3.2.5
    ...    Test title: POST Individual VNF Performance Job - method not implemented
    ...    Test objective: The objective is to test that POST method is not allowed to create a new VNF Performance Monitoring Job
    ...    Pre-conditions: none
    ...    Reference: Clause 6.4.3.3.1 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Post request for individual VNF Performance Job
    Check HTTP Response Status Code Is    405

PUT Individual VNF Performance Job - Method not implemented
    [Documentation]    Test ID: 6.3.3.2.6
    ...    Test title: PUT Individual VNF Performance Job - method not implemented
    ...    Test objective: The objective is to test that PUT method is not allowed to update an existing VNF Performance Monitoring Job
    ...    Pre-conditions: none
    ...    Reference: Clause 6.4.3.3.3 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Put request for individual VNF Performance Job
    Check HTTP Response Status Code Is    405

PATCH Individual VNF Performance Job
    [Documentation]    Test ID: 6.3.3.2.7
    ...    Test title: PATCH Individual VNF Performance Job
    ...    Test objective: The objective is to test that PATCH method allows to modify an exsisting individual PM job resource.
    ...    Pre-conditions: A VNF instance is instantiated. One or more VNF performance jobs are set in the VNFM.
    ...    Reference: Clause 6.4.3.3.4 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Patch request for individual VNF Performance Job
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Contains ETag and Last-Modified
    Check HTTP Response Body Json Schema Is    PMJobModifications
    
PATCH Individual VNF Performance Job - Precondition failed
    [Documentation]    Test ID: 6.3.3.2.8
    ...    Test title: PATCH Individual VNF Performance Job - Precondition failed
    ...    Test objective: The objective is to attempt to Modify an individual alarm resource, where the precondition was not met
    ...    Pre-conditions:  A VNF instance is instantiated. One or more VNF performance jobs are set in the VNFM.
    ...    Reference: Clause 6.4.3.3.4 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions:  The VNF Performance Job is not modified by the operation
    Send Patch request for individual VNF Performance Job
    Check HTTP Response Status Code Is    412
    Check HTTP Response Body Json Schema Is   ProblemDetails
    Check Postcondition VNF Performance Job is Unmodified (Implicit)

PATCH Individual VNF Performance Job - UNPROCESSABLE CONTENT
    [Documentation]    Test ID: 6.3.3.2.9
    ...    Test title: PATCH Individual VNF Performance Job - UNPROCESSABLE CONTENT
    ...    Test objective: The objective is to test that PATCH method cannot modify an exsisting individual PM job resource when the callback URI provided in the Request body is unreachable by the VNFM.
    ...    Pre-conditions: A VNF instance is instantiated. One or more VNF performance jobs are set in the VNFM.
    ...    Reference: Clause 6.4.3.3.4 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: The VNFM cannot reach the Notification endpoint.
    ...    Post-Conditions: none
    Send Patch request for individual VNF Performance Job with Unreachable Callback URI
    Check HTTP Response Status Code Is    422
    Check HTTP Response Body Json Schema Is    ProblemDetails
DELETE Individual VNF Performance Job with permitted authorization scope
    [Documentation]    Test ID: 6.3.3.2.10
    ...    Test title: Delete Individual VNF Performance Job with permitted authorization scope
    ...    Test objective: The objective is to test the deletion of an individual VNF performance monitoring job with permitted authorization scope
    ...    Pre-conditions: A VNF instance is instantiated. One or more VNF performance jobs are set in the VNFM.
    ...    Reference: Clause 6.4.3.3.5 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: The VNF Performance Job is no more available in the VNFM    
    Send Delete request for individual VNF Performance Job with permitted authorization scope
    Check HTTP Response Status Code Is    204
    Check Postcondition VNF Pm Job is Deleted
DELETE Individual VNF Performance Job with NOT permitted authorization scope
    [Documentation]    Test ID: 6.3.3.2.11
    ...    Test title: Delete Individual VNF Performance Job with NOT permitted authorization scope
    ...    Test objective: The objective is to test the deletion of an individual VNF performance monitoring job with NOT permitted authorization scope
    ...    Pre-conditions: A VNF instance is instantiated. One or more VNF performance jobs are set in the VNFM.
    ...    Reference: Clause 6.4.3.3.5 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: The VNF Performance Job is no more available in the VNFM    
    Send Delete request for individual VNF Performance Job with not permitted authorization scope
    Check HTTP Response Status Code Is    403
    Check HTTP Response Body Json Schema Is   ProblemDetails

*** Keywords ***
GET individual VNF Performance Job
    Log    Trying to get a Pm Job present in the NFVO Catalogue
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

GET individual VNF Performance Job with invalid resource identifier  
    Log    Trying to perform a negative get, using erroneous PM Job identifier
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${erroneousPmJobId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Delete request for individual VNF Performance Job
    Log    Trying to delete an existing PM Job
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    DELETE    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send Delete request for individual VNF Performance Job with invalid resource identifier
    Log    Trying to perform a negative delete, using erroneous PM Job identifier
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    DELETE    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${erroneousPmJobId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Post request for individual VNF Performance Job    
    Log    Trying to perform a POST (method should not be implemented)
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    POST    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${newPmJobId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send Put request for individual VNF Performance Job    
    Log    Trying to perform a POST (method should not be implemented)
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}
    ${origOutput}=    Output    response
    Set Suite Variable    ${origResponse}    ${origOutput}
    PUT    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send Patch request for individual VNF Performance Job    
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Set Headers    {"Version": "${API_VERSION}"} 
    Set Headers  {"Content-Type": "${CONTENT_TYPE_PATCH}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/PMJobModification.json
    ${body}=        Format String   ${template}     callback_uri=${new_callback_uri}:${callback_port}
    PATCH    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}     ${body}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Patch request for individual VNF Performance Job with Unreachable Callback URI    
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Set Headers    {"Version": "${API_VERSION}"} 
    Set Headers  {"Content-Type": "${CONTENT_TYPE_PATCH}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/PMJobModification.json
    ${body}=        Format String   ${template}    callback_uri=${unreachable_callback_uri}
    PATCH    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}     ${body}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Check Postcondition VNF Performance Job is Unmodified (Implicit)
    Log    Check Postcondition VNF PM job is not modified
    GET individual VNF Performance Job
    Log    Check Response matches original VNF Pm Job
    ${pmJob}=    evaluate    json.loads('''${response['body']}''')    json
    Should Be Equal    ${origresponse['body']['id']}    ${pmJob.id}
    Should Be Equal    ${origresponse['body']['criteria']}    ${pmJob.criteria}
    Should Be Equal    ${origresponse['body']['_links']}    ${pmJob._links}

Check Postcondition VNF Pm Job is Deleted
    Log    Check Postcondition
    GET individual VNF Performance Job
    Check HTTP Response Status Code Is    404

Check HTTP Response Body Pm Job Identifier matches the requested Pm Job
    Log    Going to validate Pm Job info retrieved
    Should Be Equal    ${response['body']['id']}    ${pmJobId} 
    Log    Pm Job identifier as expected
    
Check HTTP Response Status Code Is
    [Arguments]    ${expected_status}
    ${status}=    Convert To Integer    ${expected_status}    
    Should Be Equal    ${response['status']}    ${status} 
    Log    Status code validated

Check HTTP Response Header Contains
    [Arguments]    ${CONTENT_TYPE}
    Should Contain    ${response['headers']}    ${CONTENT_TYPE}
    Log    Header is present
    
Check HTTP Response Body Json Schema Is
    [Arguments]    ${input}
    Run Keyword If    '${input}' == 'ProblemDetails'    Should Contain    ${response['headers']['Content-Type']}    application/problem+json
    ...    ELSE    Should Contain    ${response['headers']['Content-Type']}    application/json
    ${schema} =    Catenate    SEPARATOR=    ${input}	.schema.json
    Validate Json    ${schema}    ${response['body']}
    Log    Json Schema Validation OK

Check HTTP Response Header Contains ETag and Last-Modified
    Pass Execution If    ${HEADER_TEST_SUPPORTED} == 0    Headers testing not supported. Skipping the Test.
    Log    ${response['headers']}
    Should Contain    ${response['headers']}    Etag
    Should Contain    ${response['headers']}    Last-Modified
    Log    Etag and Last-Modified Headers are present

