*** Settings ***
#Resource    environment/configuration.txt
Resource    environment/variables.txt
#Resource    environment/scaleVariables.txt
Library    MockServerLibrary
Library    REST    ${VNFM_SCHEMA}://${VNFM_HOST}:${VNFM_PORT}    ssl_verify=false
Library    OperatingSystem
Library    BuiltIn
Library    JSONLibrary
Library    Collections
Library    JSONSchemaLibrary    schemas/
Library    String
Library    Process
Library    jwt
#Variables    descriptors/SOL001/VNFD/vnfd_SOL001.yaml
#Variables    descriptors/SOL006/VNFD/vnfd_SOL006.yaml

*** Keywords ***
Create Sessions 
    Start Process  java  -jar  ${MOCK_SERVER_JAR}    -serverPort  ${callback_port}  alias=mockInstance
    Wait For Process  handle=mockInstance  timeout=5s  on_timeout=continue
    Create Mock Session  ${callback_uri}:${callback_port}
    
Get Vnf Instance 
    [Arguments]    ${vnfInstanceId}
    Set Headers    {"Accept":"${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}
    ${body}=    Output    response body
    [Return]    ${body}

Check HTTP Response Status Code Is
    [Arguments]    ${expected_status}    
    Should Be Equal As Strings   ${response['status']}    ${expected_status}
    Log    Status code validated 

Check Operation Occurrence Id
    ${vnfLcmOpOccId}=    Get Value From Json    ${response['headers']}    $..Location
    Should Not Be Empty    ${vnfLcmOpOccId}

Check HTTP Location Header Contains URI of Created Resource
    ${URI}=    Get Value From Json    ${response['headers']}    $..Location
    Should Not Be Empty    ${URI}

Check HTTP Response Body Json Schema Is
    [Arguments]    ${input}
    Run Keyword If    '${input}' == 'ProblemDetails'    Should Contain    ${response['headers']['Content-Type']}    application/problem+json
    ...    ELSE    Should Contain    ${response['headers']['Content-Type']}    application/json
    ${schema} =    Catenate    SEPARATOR=    ${input}    .schema.json
    Validate Json    ${schema}    ${response['body']}
    Log    Json Schema Validation OK



Check resource Instantiated
    Check VNF Instance    ${vnfInstanceId}
    Check HTTP Response Status Code Is    200
    Check VNF Status    ${response['body']['instantiationState']}    INSTANTIATED

Check resource not Instantiated
    Check VNF Instance    ${vnfInstanceId}
    Check HTTP Response Status Code Is    200
    Check VNF Status    ${response['body']['instantiationState']}    NOT_INSTANTIATED

Check VNF Instance
    [Arguments]    ${vnfId}
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${response}=    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfId}

Check VNF Status
    [Arguments]    ${current}    ${expected}
    Should Be Equal As Strings    ${current}    ${expected}
    Log    VNF Status in the correct status

Check operation resource state is FAILED_TEMP
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs/${vnfLcmOpOccId} 
    String    response body instantiationState    FAILED_TEMP   

Check operation resource state is FINALLY_FAILED      
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs/${vnfLcmOpOccId} 
    String    response body instantiationState    FINALLY_FAILED  
     
Check HTTP Response Header Contains
    [Arguments]    ${CONTENT_TYPE}
    Should Contain    ${response['headers']}    ${CONTENT_TYPE}
    Log    Header is present
         
Check HTTP Response Header Contains ETag and Last-Modified
    Pass Execution If    ${HEADER_TEST_SUPPORTED} == 0    Headers testing not supported. Skipping the Test.
    Log    ${response['headers']}
    Should Contain    ${response['headers']}    ETag
    Should Contain    ${response['headers']}    Last-Modified
    Log    ETag and Last-Modified header are present

Check Individual VNF LCM operation occurrence operationState is
    [Arguments]    ${status}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${opOccResponse}=    Get    ${response['headers']['Location']}
    Log    Validate operationState  
    Should Be Equal as Strings  ${opOccResponse['body']['operationState']}    ${status}
    Log    operationState validated

POST Create a new vnfInstance	
    Log    Create VNF instance by POST to ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Run Keyword If    ${check_descriptors} == 1    PARSE the Descriptor File
    ${template} =    Get File    jsons/createVnfRequest.json
    ${body}=        Format String   ${template}     vnfdId=${Descriptor_ID}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 	

POST Create a new vnfInstance with Invalid vnfdId	
    Log    Create VNF instance by POST to ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances with invalid vnfdId
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template} =    Get File    jsons/createVnfRequest.json
    ${body}=        Format String   ${template}     vnfdId=${invalidVnfdId}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 	

GET multiple vnfInstances	
     Log    Query VNF The GET method queries information about multiple VNF instances.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances 
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 		

GET multiple vnfInstances with bad attribute	
    Log    Query VNF The GET method queries information about multiple VNF instances.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"} 
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances?attribute_not_exist=some_value
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 	

GET multiple vnfInstances with bad filter	
    Log    Query VNF The GET method queries information about multiple VNF instances.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"} 
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances?fields=wrong_field
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 	
GET multiple vnfInstances with all_fields attribute selector
    Log    Query status information about multiple VNF instances, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances?exclude_default
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
GET multiple vnfInstances with exclude_default attribute selector
    Log    Query status information about multiple VNF instances using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances?exclude_default
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
GET multiple vnfInstances with fields attribute selector
    Log    Query status information about multiple VNF instances, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances?fields=${fields}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}	    
GET multiple vnfInstances with exclude_default and fields attribute selector
    Log    Query status information about multiple VNF instances, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances?fields=${fields}&exclude_default
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
GET multiple vnfInstances with exclude_fields attribute selector
    Log    Query status information about multiple VNF instances, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances?exclude_fields=${fields}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output} 	
PUT multiple vnfInstances
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances   	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
PATCH multiple vnfInstances
    Log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfLcmOpOccId}	 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
DELETE multiple vnfInstances
    Log    Trying to perform a DELETE. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfLcmOpOccId} 	 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}   

POST Create a new VNF Snapshot	
    Log    Create VNF snapshot by POST to ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template} =    Get File    jsons/CreateVnfSnapshotInfoRequest.json
    ${body}=        Format String   ${template}     vnfSnapshotPkgId=${vnfSnapshotPkgId}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 	

GET multiple VNF Snapshots	
    Log    Query VNF The GET method queries information about multiple VNF snapshots.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots 
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 		

GET multiple VNF Snapshots with bad attribute	
    Log    Query VNF The GET method queries information about multiple VNF snapshots.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"} 
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots?attribute_not_exist=some_value
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 	

GET multiple VNF Snapshots with bad filter	
    Log    Query VNF The GET method queries information about multiple VNF snapshots.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"} 
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots?fields=wrong_field
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 	
	
GET multiple VNF Snapshots with all_fields attribute selector
    Log    Query status information about multiple VNF snapshots, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots?exclude_default
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
GET multiple VNF Snapshots with exclude_default attribute selector
    Log    Query status information about multiple VNF snapshots using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots?exclude_default
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
GET multiple VNF Snapshots with fields attribute selector
    Log    Query status information about multiple VNF snapshots, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots?fields=${fields}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}	    
    
GET multiple VNF Snapshots with exclude_default and fields attribute selector
    Log    Query status information about multiple VNF snapshots, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots?fields=${fields}&exclude_default
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
GET multiple VNF Snapshots with exclude_fields attribute selector
    Log    Query status information about multiple VNF snapshots, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots?exclude_fields=${fields}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output} 	

GET VNF Snapshots without Paging support
    Run Keyword If    ${PAGING_SUPPORTED} == 0    GET multiple VNF Snapshots
    
GET VNF Snapshots with Paging support
    Run Keyword If    ${PAGING_SUPPORTED} == 1    GET multiple VNF Snapshots
    
Check HTTP Response Header Contains Link
    ${linkURL}=    Get Value From Json    ${response['headers']}    $..Link
    Should Not Be Empty    ${linkURL}

PUT VNF Snapshots
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots   	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
PATCH VNF Snapshots
    Log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots	 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
DELETE VNF Snapshots
    Log    Trying to perform a DELETE. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots 	 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}   

POST individual vnfInstance
    log    Trying to perform a POST. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}    
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}        

GET individual vnfInstance
    log    Trying to get information about an individual VNF instance
    Set Headers    {"Accept":"${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}      
	
PUT individual vnfInstance
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}	  	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
PATCH individual vnfInstance
    log    Trying to modify an individual VNF instance
    Set Headers    {"Accept":"${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE_PATCH}"}
    Set Headers    {"If-Match": "${original_etag}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    #Run Keyword If    ${check_descriptors} == 1    Add VNF Descriptor Content to VNF Instance
    ${body}=    Get File    jsons/VnfInfoModificationRequest.json
    #${body}=        Format String   ${template}     vnfdId=${descriptor_id}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}    ${body}	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
DELETE individual vnfInstance
    log    Trying to delete an individual VNF instance
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

POST individual VNF Snapshot
    log    Trying to perform a POST. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots/${vnfSnapshotInfoId}    
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}        

GET individual VNF Snapshot
    log    Trying to get information about an individual VNF snapshot
    Set Headers    {"Accept":"${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots/${vnfSnapshotInfoId} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}      

GET individual VNF Snapshot with invalid URI
    log    Trying to get information about an individual VNF snapshot
    Set Headers    {"Accept":"${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots/${invalidVnfSnapshotInfoId} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}      
	
PUT individual VNF Snapshot
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots/${vnfSnapshotInfoId} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

PATCH individual VNF Snapshot
    log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots/${vnfSnapshotInfoId} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

DELETE individual VNF Snapshot
    log    Trying to DELETE an individual VNF Snapshot
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots/${vnfSnapshotInfoId} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

DELETE individual VNF Snapshot - CONFLICT
    log    Trying to DELETE an individual VNF Snapshot that is already in use by another operation
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots/${vnfSnapshotInfoId_InUse} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
POST instantiate individual vnfInstance
    Log    Trying to Instantiate a vnf Instance
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/instantiateVnfRequest.json
    ${body}=        Format String   ${template}     flavourId=${flavourId}  
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/instantiate    ${body}	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 	
	
GET instantiate individual vnfInstance
    log    Trying to perform a GET. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/instantiate 
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

PUT instantiate individual vnfInstance
    log    Trying to perform a GET. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/instantiate 
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

PATCH instantiate individual vnfInstance
    log    Trying to perform a GET. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/instantiate 
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

DELETE instantiate individual vnfInstance
    log    Trying to perform a GET. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/instantiate 
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 	
	
POST Scale vnfInstance
    [Arguments]    ${vnf_state}
    [Documentation]    ${vnf_state} differentiate the VNF ID to be used in the different POST requests
    ...    ${vnf_state} == 0 -> VNF in instantiated state
    ...    ${vnf_state} == 1 -> VNF in not_instantiated state
    ...    ${vnf_state} == 2 -> VNF ID not stored
    ...     
    Log    Trying to Instantiate a vnf Instance
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${body}=    Get File    jsons/scaleVnfRequest.json
    Run Keyword If    ${vnf_state} == 0    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${instantiatedVnfInstanceId}/scale    ${body}
    Run Keyword If    ${vnf_state} == 1    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${notInstantiatedVnfInstanceId}/scale    ${body}
    Run Keyword If    ${vnf_state} == 2    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${NOT_EXISTANT_VNF_INSTANCE_ID}/scale    ${body}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/scale    ${body}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/scale    ${body}
	${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 


# POST Scale vnfInstance	
    # Log    Trying to Instantiate a vnf Instance
    # Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    # Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    # Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    # ${template}=    Get File    jsons/scaleVnfRequest.json
    # ${body}=        Format String   ${template}     scaleVnfRequesttype=${scaleVnfRequesttype}    scaleVnfRequestAspect=${scaleVnfRequestAspect} 
    # Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/scale    ${body}
    # ${outputResponse}=    Output    response
	# Set Global Variable    ${response}    ${outputResponse} 
GET Scale vnfInstance				
    Log    Trying to get a scale a vnf Instance
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${body}=    Get File    jsons/scaleVnfRequest.json
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/scale    
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
PUT Scale vnfInstance				
    Log    Trying to modify a scale vnf Instance
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${body}=    Get File    jsons/scaleVnfRequest.json
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/scale   
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
PATCH Scale vnfInstance				
    Log    Trying to modify a scale vnf Instance
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${body}=    Get File    jsons/scaleVnfRequest.json
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/scale   
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 	
DELETE Scale vnfInstance				
    Log    Trying to modify a scale vnf Instance
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${body}=    Get File    jsons/scaleVnfRequest.json
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/scale   
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 	

POST Scale vnfInstance to level with instantiationLevelId
    Log    Trying to scale a vnf Instance to level
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/scaleVnfToLevelRequestWithinstantiationLevelId.json
    ${body}=        Format String   ${template}     instantiationLevelId=${instantiationLevelId} 
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/scale_to_level    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
    
GET Scale vnfInstance to level
    log    Trying to perform a GET. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/scale_to_level 
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}		

PUT Scale vnfInstance to level
    log    Trying to perform a PUT. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/scale_to_level 
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}		

PATCH Scale vnfInstance to level
    log    Trying to perform a PATCH. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/scale_to_level 
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	
	
DELETE Scale vnfInstance to level
    log    Trying to perform a PATCH. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/scale_to_level 
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	

POST Change VNF deployment flavour
    Log    Trying to change the deployment flavour of a VNF instance.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/changeVnfFlavourRequest.json
    ${body}=        Format String   ${template}     newFlavourId=${newFlavourId} 
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/change_flavour    ${body} 
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}  	 
GET Change VNF deployment flavour
    log    Trying to perform a GET. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/change_flavour 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
PUT Change VNF deployment flavour
    log    Trying to perform a PUT. This method should not be implemented 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/change_flavour 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
PATCH Change VNF deployment flavour
    Log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/change_flavour   	 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
DELETE Change VNF deployment flavour
    Log    Trying to perform a DELETE. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/change_flavour   	 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
			
POST Terminate VNF
    Log    Trying to terminate a VNF instance.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/terminateVnfRequest.json
    ${body}=        Format String   ${template}     terminationType=${terminationType} 
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/terminate    ${body}	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}		

GET Terminate VNF
    log    Trying to perform a GET. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/terminate 
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}		

PUT Terminate VNF
    log    Trying to perform a PUT. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/terminate 
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}		

PATCH Terminate VNF
    log    Trying to perform a PATCH. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/terminate 
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	
	
DELETE Terminate VNF
    log    Trying to perform a PATCH. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/terminate 
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	

POST Heal VNF
    Log    Trying to heal a VNF instance.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/healVnfRequest.json
    ${body}=        Format String   ${template}     healingCause=${healingCause} 
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/heal    ${body}		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	

GET Heal VNF
    log    Trying to perform a GET. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/heal  
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}		

PUT Heal VNF
    log    Trying to perform a PUT. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/heal 
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}		

PATCH Heal VNF
    log    Trying to perform a PATCH. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/heal 
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	
	
DELETE Heal VNF
    log    Trying to perform a PATCH. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/heal 
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}			

POST Change External VNF Connectivity
    Log    Trying to change the external connectivity of a VNF instance.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/changeExtVnfConnectivityRequest.json
    ${body}=        Format String   ${template}     CPD_IDs=${CPD_IDs}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/change_ext_conn    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}  

GET Change External VNF Connectivity
    log    Trying to perform a GET. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/change_ext_conn 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
PUT Change External VNF Connectivity
    log    Trying to perform a PUT. This method should not be implemented 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/change_ext_conn  		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
PATCH Change External VNF Connectivity
    Log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/change_ext_conn  	 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
DELETE Change External VNF Connectivity
    Log    Trying to perform a DELETE. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/change_ext_conn  	 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

POST Change Current VNF Package Task
    Log    Trying to change current VNF package task.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/changeCurrentVnfPkgRequest.json
    ${body}=        Format String   ${template}     vnfdId=${vnfdId} 
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/change_vnfpkg    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}  
	
GET Change Current VNF Package Task
    log    Trying to perform a GET. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/change_vnfpkg 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

PUT Change Current VNF Package Task
    log    Trying to perform a PUT. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/change_vnfpkg 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

PATCH Change Current VNF Package Task
    log    Trying to perform a PATCH. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/change_vnfpkg 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
DELETE Change Current VNF Package Task
    log    Trying to perform a DELETE. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/change_vnfpkg 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

POST Select VNF Deployable Modules
    log    Trying to select deployable modules of VNF instance
    Set Headers    {"Accept":"${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/SelectVnfDeployableModulesRequest.json
    ${body}=    Format String    ${template}
    Post    ${apiRoot}/vnflcm/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/select_depl_mods    ${body}
    ${outputResponse}=    Output    response
    Set Global Variable    ${response}    ${outputResponse}

POST Select VNF Deployable Modules Not Existing
    log    Trying to select deployable modules of VNF instance
    Set Headers    {"Accept":"${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/SelectVnfDeployableModulesRequest.json
    ${body}=    Format String    ${template}
    Post    ${apiRoot}/vnflcm/${apiMajorVersion}/vnf_instances/${notExistingVnfInstanceId}/select_depl_mods    ${body}
    ${outputResponse}=    Output    response
    Set Global Variable    ${response}    ${outputResponse}

POST Select VNF Deployable Modules with conflict
    log    Trying to select deployable modules of VNF instance.
    Set Headers    {"Accept":"${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/SelectVnfDeployableModulesRequest.json
    ${body}=    Format String    ${template}
    Post    ${apiRoot}/vnflcm/${apiMajorVersion}/vnf_instances/${notInstantiatedVnfInstanceId}/select_depl_mods    ${body}
    ${outputResponse}=    Output    response
    Set Global Variable    ${response}    ${outputResponse}


GET Select VNF Deployable Modules
    log    Trying to perform a GET. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"} 
    Get    ${apiRoot}/vnflcm/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/select_depl_mods
    ${outputResponse}=    Output    response
    Set Global Variable    ${response}    ${outputResponse}

PUT Select VNF Deployable Modules
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers    {"Accept":"${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/vnflcm/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/select_depl_mods
    ${outputResponse}=    Output    response
    Set Global Variable    ${response}    ${outputResponse}

PATCH Select VNF Deployable Modules
    log    Trying to perform a PATCH. This method should not be implemented
    Set Headers    {"Accept":"${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/vnflcm/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/select_depl_mods
    ${outputResponse}=    Output    response
    Set Global Variable    ${response}    ${outputResponse}

DELETE Select VNF Deployable Modules
    log    Trying to perform a DELETE. This method should not be implemented
    Set Headers    {"Accept":"${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/vnflcm/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/select_depl_mods
    ${outputResponse}=    Output    response
    Set Global Variable    ${response}    ${outputResponse}
    
POST Create VNF Snapshot Task
    Log    Trying to request a snapshot of a VNF instance
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/CreateVnfSnapshotRequest.json
    ${body}=        Format String   ${template}     vnfSnapshotInfoId=${vnfSnapshotInfoId} 
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/create_snapshot    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}  
	
POST Create VNF Snapshot Task NOT SUPPORTED
    Log    Trying to request a snapshot of a VNF instance for which task resource does not exist
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/CreateVnfSnapshotRequest.json
    ${body}=        Format String   ${template}     vnfSnapshotInfoId=${vnfSnapshotInfoId} 
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId_NoSnapshotTask}/create_snapshot    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}  

POST Create VNF Snapshot Task VNF_NOT_INSTANTIATED
    Log    Trying to request a snapshot of a VNF instance which is in NOT_INSTANTIATED state
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/CreateVnfSnapshotRequest.json
    ${body}=        Format String   ${template}     vnfSnapshotInfoId=${vnfSnapshotInfoId} 
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId_NOT_INSTANTIATED}/create_snapshot    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}  
	
POST Create VNF Snapshot Task INVALID IDENTIFIER
    Log    Trying to request a snapshot of a VNF instance with invalid "Individual VNF Snapshot" resource identifier
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/CreateVnfSnapshotRequest.json
    ${body}=        Format String   ${template}     vnfSnapshotInfoId=${invalidVnfSnapshotInfoId} 
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/create_snapshot    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}  
	
GET Create VNF Snapshot Task
    log    Trying to perform a GET. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/create_snapshot 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

PUT Create VNF Snapshot Task
    log    Trying to perform a PUT. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/create_snapshot 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

PATCH Create VNF Snapshot Task
    log    Trying to perform a PATCH. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/create_snapshot 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
DELETE Create VNF Snapshot Task
    log    Trying to perform a DELETE. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/create_snapshot 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
POST Revert to VNF Snapshot Task
    Log    Trying to initiate revert to VNF snapshot task.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/RevertToVnfSnapshotRequest.json
    ${body}=        Format String   ${template}     vnfSnapshotInfoId=${vnfSnapshotInfoId} 
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/revert_to_snapshot    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}  
	
POST Revert to VNF Snapshot Task NOT SUPPORTED
    Log    Trying to revert to a snapshot of a VNF instance for which task resource does not exist
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/RevertToVnfSnapshotRequest.json
    ${body}=        Format String   ${template}     vnfSnapshotInfoId=${vnfSnapshotInfoId} 
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId_NoSnapshotTask}/revert_to_snapshot    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}  

POST Revert to VNF Snapshot Task VNF_NOT_INSTANTIATED
    Log    Trying to revert to a snapshot of a VNF instance which is in NOT_INSTANTIATED state
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/RevertToVnfSnapshotRequest.json
    ${body}=        Format String   ${template}     vnfSnapshotInfoId=${vnfSnapshotInfoId} 
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId_NOT_INSTANTIATED}/revert_to_snapshot    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}  

GET Revert to VNF Snapshot Task
    log    Trying to perform a GET. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/revert_to_snapshot 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

PUT Revert to VNF Snapshot Task
    log    Trying to perform a PUT. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/revert_to_snapshot 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

PATCH Revert to VNF Snapshot Task
    log    Trying to perform a PATCH. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/revert_to_snapshot 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

DELETE Revert to VNF Snapshot Task
    log    Trying to perform a DELETE. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/revert_to_snapshot 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

POST Operate VNF
    Log    Trying to operate a VNF instance.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/operateVnfRequest.json
    ${body}=        Format String   ${template}     changeStateTo=${changeStateTo} 
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/operate    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	

GET Operate VNF
    log    Trying to perform a GET. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/operate  
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}		

PUT Operate VNF
    log    Trying to perform a PUT. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/operate 
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}		

PATCH Operate VNF
    log    Trying to perform a PATCH. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/operate 
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	
	
DELETE Operate VNF
    log    Trying to perform a PATCH. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/operate 
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}		

Post VNF LCM OP occurrences
    log    Trying to perform a POST. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs  	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}		
GET VNF LCM OP occurrences
    Log    Query status information about multiple VNF lifecycle management operation occurrences.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	
GET VNF LCM OP occurrences invalid attribute
    Log    Query status information about multiple VNF lifecycle management operation occurrences.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"} 
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs?attribute_not_exist=some_value	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	
GET VNF LCM OP occurrences invalid filter
    Log    Query status information about multiple VNF lifecycle management operation occurrences.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"} 
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs?fields=wrong_field	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	
PUT VNF LCM OP occurrences	
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
PATCH VNF LCM OP occurrences	
    log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}			
DELETE VNF LCM OP occurrences	
    log    Trying to perform a DELETE. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	
Post Individual VNF LCM OP occurrences
    log    Trying to perform a POST. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs/${vnfLcmOpOccId}	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	
Get Individual VNF LCM OP occurrences
    log    Trying to perform a POST. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs/${vnfLcmOpOccId}	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	
Put Individual VNF LCM OP occurrences
    log    Trying to perform a POST. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs/${vnfLcmOpOccId}	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
Patch Individual VNF LCM OP occurrences
    log    Trying to perform a POST. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch   ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs/${vnfLcmOpOccId}	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
Delete Individual VNF LCM OP occurrences
    log    Trying to perform a POST. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs/${vnfLcmOpOccId}	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}			
Post Retry operation
    Log    Retry a VNF lifecycle operation if that operation has experienced a temporary failure
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Log    Execute Query and validate response
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs/${vnfLcmOpOccId}/retry	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	    
Get Retry operation	
    Log    Trying to perform a GET. This method should not be implemented.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs/${vnfLcmOpOccId}/retry	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	
Put Retry operation	
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs/${vnfLcmOpOccId}/retry	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}		
Patch Retry operation	
    log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs/${vnfLcmOpOccId}/retry	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	
Delete Retry operation    
	log    Trying to perform a DELETE. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs/${vnfLcmOpOccId}/retry	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	
Post Rollback operation
    Log    Rollback a VNF lifecycle operation if that operation has experienced a temporary failure
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Log    Execute Query and validate response
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs/${vnfLcmOpOccId}/rollback
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	    
Get Rollback operation	
    Log    Trying to perform a GET. This method should not be implemented.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs/${vnfLcmOpOccId}/rollback	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	
Put Rollback operation	
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs/${vnfLcmOpOccId}/rollback	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}		
Patch Rollback operation	
    log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs/${vnfLcmOpOccId}/rollback	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	
Delete Rollback operation    
	log    Trying to perform a DELETE. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs/${vnfLcmOpOccId}/rollback	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	
Post Fail operation
    Log    mark as Failed a VNF lifecycle operation if that operation has experienced a failure
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Log    Execute Query and validate response
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs/${vnfLcmOpOccId}/fail
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	    
Get Fail operation	
    Log    Trying to perform a GET. This method should not be implemented.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs/${vnfLcmOpOccId}/fail
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	
Put Fail operation	
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs/${vnfLcmOpOccId}/fail	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}		
Patch Fail operation	
    log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs/${vnfLcmOpOccId}/fail
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	
Delete Fail operation    
	log    Trying to perform a DELETE. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs/${vnfLcmOpOccId}/fail
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	

POST Cancel operation task
    Log    Cancel an ongoing VNF lifecycle operation
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Log    Cancel a VNF lifecycle operation
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs/${vnfLcmOpOccId}/cancel    ${CancelMode}
    Log    Validate Status code
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
    
GET Cancel operation task
    log    Trying to perform a GET. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs/${vnfLcmOpOccId}/cancel 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
PUT Cancel operation task
    log    Trying to perform a PUT. This method should not be implemented 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs/${vnfLcmOpOccId}/cancel  		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
PATCH Cancel operation task
    Log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs/${vnfLcmOpOccId}/cancel  	 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
DELETE Cancel operation task
    Log    Trying to perform a DELETE. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs/${vnfLcmOpOccId}/cancel  	 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}        

Post Create subscription
    Log    Create subscription instance by POST to ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/lccnSubscriptionRequest.json
    ${body}=        Format String   ${template}    vnfdIds=${vnfdIds}     callback_uri=${callback_uri}:${callback_port}    callback_endpoint=${callback_endpoint}
    Log  Creating mock request and response to handle GET operation on notification endpoint
    &{notification_request}=  Create Mock Request Matcher	GET  ${callback_endpoint}
    &{notification_response}=  Create Mock Response	status_code=204
    Log    Issue the subscription request
    Create Mock Expectation  ${notification_request}  ${notification_response}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions    ${body}    allow_redirects=false
	${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	Clear Requests    ${callback_endpoint}

 	
Post Create subscription - DUPLICATION
    Log    Trying to create a subscription with an already created content
    Pass Execution If    ${VNFM_DUPLICATION} == 0    VNFM is not permitting duplication. Skipping the test
    Set Headers    {"Accept":"${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/lccnSubscriptionRequest.json
    ${body}=        Format String   ${template}    vnfdIds=${vnfdIds}     callback_uri=${callback_uri}:${callback_port}    callback_endpoint=${callback_endpoint}
    Log  Creating mock request and response to handle GET operation on notification endpoint
    &{notification_request}=  Create Mock Request Matcher	GET  ${callback_endpoint}
    &{notification_response}=  Create Mock Response	status_code=204
    Log    Issue the subscription request
    Create Mock Expectation  ${notification_request}  ${notification_response}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions    ${body}    allow_redirects=false
	${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	Clear Requests    ${callback_endpoint}
			
Post Create subscription - NO-DUPLICATION	
    Log    Trying to create a subscription with an already created content
    Pass Execution If    ${VNFM_DUPLICATION} == 1    VNFM permits duplication. Skipping the test
    Set Headers    {"Accept":"${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/lccnSubscriptionRequest.json
    ${body}=        Format String   ${template}    vnfdIds=${vnfdIds}     callback_uri=${callback_uri}:${callback_port}    callback_endpoint=${callback_endpoint}
    Log  Creating mock request and response to handle GET operation on notification endpoint
    &{notification_request}=  Create Mock Request Matcher	GET  ${callback_endpoint}
    &{notification_response}=  Create Mock Response	status_code=204
    Log    Issue the subscription request
    Create Mock Expectation  ${notification_request}  ${notification_response}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions    ${body}    allow_redirects=false
	${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	Clear Requests    ${callback_endpoint}
			
Get subscriptions
    Log    Get the list of active subscriptions
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	
Get subscriptions - filter
    Log    Get the list of active subscriptions using a filter
    Set Headers    {"Accept":"${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions?${sub_filter}	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}		
Get subscriptions - invalid filter  
    Log    Get the list of active subscriptions using an invalid filter
    Set Headers    {"Accept":"${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions?${sub_filter_invalid}   
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}		
Get subscriptions with all_fields attribute selector
    Log    Get the list of active subscriptions, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions?exclude_default
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
Get subscriptions with exclude_default attribute selector
    Log    Get the list of active subscriptions, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions?exclude_default
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
Get subscriptions with fields attribute selector
    Log    Get the list of active subscriptions, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions?fields=${fields}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}	
Get subscriptions with exclude_fields attribute selector
    Log    Get the list of active subscriptions, using fields
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions?exclude_fields=${fields}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}	
PUT subscriptions
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions  	   
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	
PATCH subscriptions
    log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions  	   
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}		
DELETE subscriptions
    log    Trying to perform a DELETE. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions  	   
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	
Post Create Individual subscription
    log    Trying to perform a POST. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}  	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}		
Get Individual subscription	
    log    Trying to get information about an individual subscription
    Set Headers    {"Accept":"${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}		
Put Individual subscription	
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId} 
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}		
Patch Individual subscription	
    log    Trying to perform a PATCH. This method should not be implemented
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId} 	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	    
Delete Individual subscription
    log    Try to delete an individual subscription
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}  	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
Put Notification subscription
    log    Trying to perform a PUT. This method should not be implemented
    Put    ${callback_endpoint}	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
Patch Notification subscription
    log    Trying to perform a PATCH. This method should not be implemented
    Patch    ${callback_endpoint}	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
Delete Notification subscription
    log    Trying to perform a DELETE. This method should not be implemented
    Delete    ${callback_endpoint}	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
POST Operation occurrence
    log    The POST method delivers a notification from the server to the client.
    ${json}=	Get File	schemas/NsLcmOperationOccurrenceNotification.schema.json
    ${BODY}=	evaluate	json.loads('''${json}''')	json
    Log  Creating mock request and response to handle NSLcmOperationOccurrenceNotification
    &{req}=  Create Mock Request Matcher	POST  ${callback_endpoint}  body_type="JSON_SCHEMA"    body=${BODY}
    &{rsp}=  Create Mock Response	headers="Content-Type: application/json"  status_code=204
    Create Mock Expectation  ${req}  ${rsp}
    Sleep  ${sleep_interval}
    Log  Verifying results
    Verify Mock Expectation  ${req}
    Log  Cleaning the endpoint
    Clear Requests  ${callback_endpoint} 
POST Id creation
    log    The POST method delivers a notification from the server to the client.
    ${json}=	Get File	schemas/vnfIdentifierCreationNotification.schema.json
    ${BODY}=	evaluate	json.loads('''${json}''')	json
    Log  Creating mock request and response to handle vnfLcmOperationOccurrenceNotification
    &{req}=  Create Mock Request Matcher	POST  ${callback_endpoint}  body_type="JSON_SCHEMA"    body=${BODY}
    &{rsp}=  Create Mock Response	headers="Content-Type: application/json"  status_code=204
    Create Mock Expectation  ${req}  ${rsp}
    Sleep  ${sleep_interval}
    Log  Verifying results
    Verify Mock Expectation  ${req}
    Log  Cleaning the endpoint
    Clear Requests  ${callback_endpoint}
POST Id deletion
    log    The POST method delivers a notification from the server to the client.
    ${json}=	Get File	schemas/vnfIdentifierCreationNotification.schema.json
    ${BODY}=	evaluate	json.loads('''${json}''')	json
    Log  Creating mock request and response to handle vnfLcmOperationOccurrenceNotification
    &{req}=  Create Mock Request Matcher	POST  ${callback_endpoint}  body_type="JSON_SCHEMA"    body=${BODY}
    &{rsp}=  Create Mock Response	headers="Content-Type: application/json"  status_code=204
    Create Mock Expectation  ${req}  ${rsp}
    Sleep  ${sleep_interval}
    Log  Verifying results
    Verify Mock Expectation  ${req}
    Log  Cleaning the endpoint
    Clear Requests  ${callback_endpoint}    
GET test endpoint
    log    The GET method allows the server to test the notification endpoint
    &{req}=  Create Mock Request Matcher	GET  ${callback_endpoint}
    &{rsp}=  Create Mock Response	headers="Content-Type: application/json"  status_code=204
    Create Mock Expectation  ${req}  ${rsp}
    Sleep  ${sleep_interval}
    Verify Mock Expectation  ${req}
    Clear Requests  ${callback_endpoint}   
    
Check Subscription resource exist
    Set Headers    {"Accept":"${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}
    Integer    response status    200

Get VNF LCM Operation occurrences with all_fields attribute selector
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs?all_fields
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    

Get VNF LCM Operation occurrences with exclude_default attribute selector
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs?exclude_default
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Get VNF LCM Operation occurrences with fields attribute selector
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs?fields=${fields}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Get VNF LCM Operation occurrences with exclude_default and fields attribute selector
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs?fields=${fields}&exclude_default
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Get VNF LCM Operation occurrences with exclude_fields attribute selector
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs?exclude_fields=${fields}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output} 	
    
Check HTTP Response Header Contain Link
    ${linkURL}=    Get Value From Json    ${response['headers']}    $..Link
    Should Not Be Empty    ${linkURL}

Check HTTP Response Body vnfInstances content against VNF Descriptor
    #{check_multiple_instances} flag, set to 1 to check multiple instances against descriptors
    Run Keyword If    ${check_multiple_instances} == 1    Check Multiple VNF Instances Content
    
Check Multiple VNF Instances Content
    #${number_of_instances}=    Get Length    ${response['body']}
    #FOR    ${i}    IN RANGE    ${number_of_instances}
    ${response['body']}=    Get Variable Value    ${response['body'][0]}    #Gets the first instance at index 0
    Check Individual VNF Instance Content
    #END

Check HTTP Response Body vnfInstance content against VNF Descriptor
    #${check_descriptors} flag, 1 to check descriptors
    Run Keyword If    ${check_descriptors} == 1    Check Individual VNF Instance Content

Check Individual VNF Instance Content  
    PARSE the Descriptor File
    Match the VNF Instance Response Attributes with Descriptors  
  
PARSE the Descriptor File
    Run Keyword If  '${descriptorType}'=='SOL001'    Fetch Information from SOL001 descriptor file    ELSE    Fetch Information from SOL006 descriptor file
    
Fetch Information from SOL001 descriptor file
    Import Variables    ${CURDIR}/descriptors/SOL001/VNFD/vnfd_SOL001.yaml
    @{VDU_labels}=    Create List
    @{VNF_labels}=    Create List
    @{VirtualLink_labels}=    Create List
    @{CP_labels}=    Create List
    @{Storage_labels}=    Create List

    FOR    ${key}    IN    @{node_types.keys()}
        ${node_type}=    Get Variable Value    ${node_types['${key}']['derived_from']}
        ${is_VNF}=    Run Keyword And Return Status    Should Be Equal As Strings    ${node_type}    ${tosca_type_VNF}
        Run Keyword If    ${is_VNF}    Set Global Variable    ${tosca_type_derived_from_VNF}    ${key}
    END  
    ${derived_type_is_used}=    Run Keyword And Return Status    Should not be empty    ${tosca_type_derived_from_VNF}
    Run Keyword If    ${derived_type_is_used}    Set Global Variable    ${tosca_type_VNF}    ${tosca_type_derived_from_VNF}

    FOR    ${key}    IN    @{topology_template.node_templates.keys()} 
        ${key_type}=    Get Variable Value    ${topology_template.node_templates['${key}'].type}
        ${VDU_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key_type}   ${tosca_type_VDU_compute}
        ${VNF_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key_type}    ${tosca_type_VNF}
        ${Link_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key_type}    ${tosca_type_virtual_link}
        ${VDUcp_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key_type}    ${tosca_type_VDU_cp}
        ${Storage_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key_type}    ${tosca_type_storage}
        Run Keyword If    ${VDU_check}    Append To List    ${VDU_labels}    ${key}
        Run Keyword If    ${VNF_check}    Append To List    ${VNF_labels}    ${key}
        Run Keyword If    ${VNF_check}    Get VNF Attributes from SOL001    ${key}            
        Run Keyword If    ${Link_check}    Append To List    ${VirtualLink_labels}    ${key}
        Run Keyword If    ${VDUcp_check}    Append To List    ${CP_labels}    ${key}
        Run Keyword If    ${Storage_check}    Append To List    ${Storage_labels}    ${key}
    END
    Set Global Variable    @{VDU_IDs}    @{VDU_labels}
    Set Global Variable    @{VNF_IDs}    @{VNF_labels}
    Set Global Variable    @{VirtualLink_IDs}    @{VirtualLink_labels}
    Set Global Variable    @{CP_IDs}    @{CP_labels}
    Set Global Variable    @{Storage_IDs}    @{Storage_labels}

Get VNF Attributes from SOL001
    [Arguments]    ${VNF_label}
    Import Variables    ${CURDIR}/descriptors/SOL001/VNFD/vnfd_SOL001.yaml
    ${descriptor_id}=    Get Variable Value    ${topology_template.node_templates['${VNF_label}'].properties.descriptor_id}
    ${provider}=    Get Variable Value    ${topology_template.node_templates['${VNF_label}'].properties.provider}
    ${product_name}=    Get Variable Value    ${topology_template.node_templates['${VNF_label}'].properties.product_name}
    ${software_version}=    Get Variable Value    ${topology_template.node_templates['${VNF_label}'].properties.software_version}
    ${descriptor_version}=    Get Variable Value    ${topology_template.node_templates['${VNF_label}'].properties.descriptor_version}
    ${flavour_id}=    Get Variable Value    ${topology_template.node_templates['${VNF_label}'].properties.flavour_id}
    
    Set Global Variable    ${Descriptor_ID}    ${descriptor_id}
    Set Global Variable    ${Provider}    ${provider}
    Set Global Variable    ${Product_Name}    ${product_name}
    Set Global Variable    ${Software_Version}    ${software_version}
    Set Global Variable    ${Descriptor_Version}    ${descriptor_version}
    Set Global Variable    ${Flavour_ID}    ${flavour_id}

Fetch Information from SOL006 descriptor file
    Import Variables    ${CURDIR}/descriptors/SOL006/VNFD/vnfd_SOL006.yaml
    ${descriptor_id}=    Get Variable Value    ${nfv.vnfd[0].id}
    ${provider}=    Get Variable Value    ${nfv.vnfd[0].provider}
    ${product_name}=    Get Variable Value    ${nfv.vnfd[0]['product-name']}
    ${software_version}=    Get Variable Value    ${nfv.vnfd[0]['software-version']}
    ${descriptor_version}=    Get Variable Value    ${nfv.vnfd[0].version}    
    ${VDUcount}=    Get Length    ${nfv.vnfd[0].vdu}
    ${extCP_count}=    Get Length    ${nfv.vnfd[0]['ext-cpd']}
    ${virtualLink_count}=    Get length    ${nfv.vnfd[0]['int-virtual-link-desc']}
    ${instantiation_levels}=    Get Length    ${nfv.vnfd[0].df['instantiation-level']}    
    FOR    ${key}    IN    @{nfv.vnfd[0].keys()}
        ${VDU_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key}    vdu
        Run Keyword If    ${VDU_check}    Get VDU IDs    ${VDUcount}
        ${extCP_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key}    ext-cpd
        Run Keyword If    ${extCP_check}    Get External CP IDs    ${extCP_count}
        ${virtualLink_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key}    int-virtual-link-desc
        Run Keyword If    ${virtualLink_check}    Get Virtual Link IDs   ${virtualLink_count}    
        ${DF_check}=    Run Keyword And Return Status    Should Be Equal As Strings    ${key}    df
        Run Keyword If    ${DF_check}    Get Instantiation Levels    ${instantiation_levels}    
    END
    Set Global Variable    ${Descriptor_ID}    ${descriptor_id}
    Set Global Variable    ${Provider}    ${provider}
    Set Global Variable    ${Product_Name}    ${product_name}
    Set Global Variable    ${Software_Version}    ${software_version}
    Set Global Variable    ${Descriptor_Version}    ${descriptor_version}

Get VDU IDs
    [Arguments]    ${count}    
    Import Variables    ${CURDIR}/descriptors/SOL006/VNFD/vnfd_SOL006.yaml
    @{VDU_labels}=    Create List
    ${Storage_labels}=    Create List
    FOR    ${i}    IN RANGE    ${count}
        Append To List    ${VDU_labels}    ${nfv.vnfd[0].vdu[${i}]['id']}
        Append To List    ${Storage_labels}    ${nfv.vnfd[0].vdu[${i}]['virtual-storage-desc']} 
        Get Internal CPs for each VDU    ${i}   
    END
    Set Global Variable    ${VDU_IDs}    ${VDU_labels}
    Set Global Variable    ${Storage_IDs}    ${Storage_labels}
            
Get Internal CPs for each VDU
    [Arguments]    ${vdu}
    Import Variables    ${CURDIR}/descriptors/SOL006/VNFD/vnfd_SOL006.yaml
    ${count}=    Get Length    ${nfv.vnfd[0].vdu[${vdu}]['int-cpd']}    
    ${internal_CPs}=    Create List
    FOR    ${i}    IN RANGE    ${count}
        Append To List    ${internal_CPs}    ${nfv.vnfd[0].vdu[${vdu}]['int-cpd'][${i}]['id']} 
    END
    Set Global Variable    ${internalCP_IDs}    ${internal_CPs}
    
Get External CP IDs
    [Arguments]    ${count}    
    Import Variables    ${CURDIR}/descriptors/SOL006/VNFD/vnfd_SOL006.yaml
    @{external_CPs}=    Create List
    FOR    ${i}    IN RANGE    ${count}
        Append To List    ${external_CPs}    ${nfv.vnfd[0]['ext-cpd'][${i}]['id']} 
    END
    Set Global Variable    ${externalCP_IDs}    ${external_CPs}

Get Virtual Link IDs
    [Arguments]    ${count}    
    Import Variables    ${CURDIR}/descriptors/SOL006/VNFD/vnfd_SOL006.yaml
    ${VirtualLink_labels}=    Create List
    FOR    ${i}    IN RANGE    ${count}
        Append To List    ${VirtualLink_labels}    ${nfv.vnfd[0]['int-virtual-link-desc'][${i}]['id']} 
    END
    Set Global Variable    ${VirtualLink_IDs}    ${VirtualLink_labels}

Get Instantiation Levels
    [Arguments]    ${count}
    Import Variables    ${CURDIR}/descriptors/SOL006/VNFD/vnfd_SOL006.yaml
    @{Instantiation_Levels}=    Create List
    FOR    ${i}    IN RANGE    ${count}
        Append To List    ${Instantiation_Levels}    ${nfv.vnfd[0].df['instantiation-level'][${i}]['id']} 
    END
    Set Global Variable    ${InstantiationLevel_IDs}    ${Instantiation_Levels}

Match the VNF Instance Response Attributes with Descriptors
    #Checking Response attributes with VNF Descriptors
    Should Be Equal As Strings    ${response['body']['vnfdId']}    ${Descriptor_ID}
    Should Be Equal As Strings    ${response['body']['vnfProvider']}    ${Provider}
    Should Be Equal As Strings    ${response['body']['vnfProductName']}    ${Product_Name}
    Should Be Equal As Strings    ${response['body']['vnfSoftwareVersion']}    ${Software_Version}
    Should Be Equal As Strings    ${response['body']['vnfdVersion']}    ${Descriptor_Version}
    Should Be Equal As Strings    ${response['body']['instantiatedVnfInfo']['flavourId']}    ${Flavour_ID}
    List Should Contain Value    ${VDU_IDs}    ${response['body']['instantiatedVnfInfo']['vnfcResourceInfo'][0]['vduId']}        
    Run Keyword If  '${descriptorType}'=='SOL006'    List Should Contain Value    ${externalCP_IDs}    ${response['body']['instantiatedVnfInfo']['extCpInfo'][0]['cpdId']}
    Run Keyword If  '${descriptorType}'=='SOL006'    List Should Contain Value    ${internalCP_IDs}    ${response['body']['instantiatedVnfInfo']['vnfcResourceInfo'][0]['vnfcCpInfo'][0]['cpdId']}
    Run Keyword If  '${descriptorType}'=='SOL001'    List Should Contain Value    @{CP_IDs}    ${response['body']['instantiatedVnfInfo']['extCpInfo'][0]['cpdId']}
    Run Keyword If  '${descriptorType}'=='SOL001'    List Should Contain Value    @{CP_IDs}    ${response['body']['instantiatedVnfInfo']['vnfcResourceInfo'][0]['vnfcCpInfo'][0]['cpdId']}
    List Should Contain value    ${Storage_IDs}    ${response['body']['instantiatedVnfInfo']['virtualStorageResourceInfo'][0]['virtualStorageDescId']}
    List Should Contain Value    ${VirtualLink_IDs}    ${response['body']['instantiatedVnfInfo']['extManagedVirtualLinkInfo'][0]['vnfVirtualLinkDescId']}
    
Check HTTP Response Body vnf LCM OpOCCs content against VNF Descriptor
    #{check_multiple_instances} flag, set to 1 to check multiple instances against descriptors
    Run Keyword If    ${check_multiple_instances} == 1    Check Multiple VNF LCM OpOCCs Content
    
Check Multiple VNF LCM OpOCCs Content
    #${number_of_instances}=    Get Length    ${response['body']}
    #FOR    ${i}    IN RANGE    ${number_of_instances}
    ${response['body']}=    Get Variable Value    ${response['body'][0]}    #Gets the first instance at index 0
    Check Individual VNF LCM Operation Occurence Content
    #END

Check HTTP Response Body vnf LCM OpOCC content against VNF Descriptor
    Run Keyword If    ${check_descriptors} == 1    Check Individual VNF LCM Operation Occurence Content

Check Individual VNF LCM Operation Occurence Content
    PARSE the Descriptor File
    Match the VNF LCM Operation Occurence Response Attributes with Descriptors  

Match the VNF LCM Operation Occurence Response Attributes with Descriptors  
    Should Be Equal As Strings    ${response['body']['changedInfo']['vnfdId']}    ${Descriptor_ID}
    Should Be Equal As Strings    ${response['body']['changedInfo']['vnfdVersion']}    ${Descriptor_Version}
    List Should Contain Value    ${VDU_IDs}    ${response['body']['resourceChanges']['affectedVnfcs'][0]['vduId']}    
    List Should Contain value    ${Storage_IDs}    ${response['body']['resourceChanges']['affectedVirtualStorages'][0]['virtualStorageDescId']}
    List Should Contain Value    ${VirtualLink_IDs}    ${response['body']['resourceChanges']['affectedVirtualLinks'][0]['vnfVirtualLinkDescId']}

POST Instantiate individual vnfInstance with instantiationLevelId
    Log    Trying to Instantiate a vnf Instance with instantiationLevelId
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/instantiateVnfRequestWithInstantiationLevelId.json
    ${body}=        Format String   ${template}     flavourId=${flavourId}     instantiationLevelId=${instantiationLevelId} 
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/instantiate    ${body}	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 	

POST instantiate individual vnfInstance with targetScaleLevelId
    Log    Trying to Instantiate a vnf Instance with targetScaleLevelId
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/instantiateVnfRequestWithTargetScaleLevelInfo.json
    ${body}=        Format String   ${template}     flavourId=${flavourId}    scaleVnfRequestAspect=${scaleVnfRequestAspect}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/instantiate    ${body}	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}     

JWT Encode
    [Arguments]    ${payload}    ${key}    ${algorithm}
    ${encoded}=    Evaluate    jwt.encode(${payload}, ${key}, ${algorithm})
    [Return]    ${encoded}

POST instantiate individual vnfInstance with permitted authorization scope
    Log    Trying to Instantiate a vnf Instance with OAuth Token with permitted values
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    ${scope_value}=    Create Dictionary    scopeValue=vnflcm:v2:instantiate
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    ${template}=    Get File    jsons/instantiateVnfRequest.json
    ${body}=        Format String   ${template}     flavourId=${flavourId}  
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/instantiate    ${body}	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 	

POST instantiate individual vnfInstance with not permitted authorization scope
    Log    Trying to Instantiate a vnf Instance with OAuth Token with not permitted values
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    ${scope_value}=    Create Dictionary    scopeValue=${NEG_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    ${template}=    Get File    jsons/instantiateVnfRequest.json
    ${body}=        Format String   ${template}     flavourId=${flavourId}  
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/instantiate    ${body}	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 	

POST instantiate individual vnfInstance with not valid authorization token
    Log    Trying to Instantiate a vnf Instance with OAuth Token with non authorized tokken
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    ${template}=    Get File    jsons/instantiateVnfRequest.json
    ${body}=        Format String   ${template}     flavourId=${flavourId}  
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/instantiate    ${body}	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 	

POST Scale vnfInstance with permitted authorization scope
    [Arguments]    ${vnf_state}
    [Documentation]    ${vnf_state} differentiate the VNF ID to be used in the different POST requests
    ...    ${vnf_state} == 0 -> VNF in instantiated state
    ...    ${vnf_state} == 1 -> VNF in not_instantiated state
    ...    ${vnf_state} == 2 -> VNF ID not stored
    ...     
    Log    Trying to Instantiate a vnf Instance with permitted authorization scope
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    ${scope_value}=    Create Dictionary    scopeValue=${SCALE_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    ${body}=    Get File    jsons/scaleVnfRequest.json
    Run Keyword If    ${vnf_state} == 0    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${instantiatedVnfInstanceId}/scale    ${body}
    Run Keyword If    ${vnf_state} == 1    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${notInstantiatedVnfInstanceId}/scale    ${body}
    Run Keyword If    ${vnf_state} == 2    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${NOT_EXISTANT_VNF_INSTANCE_ID}/scale    ${body}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/scale    ${body}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/scale    ${body}
	${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

POST Scale vnfInstance with not permitted authorization scope
    [Arguments]    ${vnf_state}
    [Documentation]    ${vnf_state} differentiate the VNF ID to be used in the different POST requests
    ...    ${vnf_state} == 0 -> VNF in instantiated state
    ...    ${vnf_state} == 1 -> VNF in not_instantiated state
    ...    ${vnf_state} == 2 -> VNF ID not stored
    ...     
    Log    Trying to Instantiate a vnf Instance with not permitted authorization scope
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    ${scope_value}=    Create Dictionary    scopeValue=${NEG_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    ${body}=    Get File    jsons/scaleVnfRequest.json
    Run Keyword If    ${vnf_state} == 0    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${instantiatedVnfInstanceId}/scale    ${body}
    Run Keyword If    ${vnf_state} == 1    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${notInstantiatedVnfInstanceId}/scale    ${body}
    Run Keyword If    ${vnf_state} == 2    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${NOT_EXISTANT_VNF_INSTANCE_ID}/scale    ${body}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/scale    ${body}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/scale    ${body}
	${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

POST Scale vnfInstance to level with instantiationLevelId and permitted authorization scope
    Log    Trying to scale a vnf Instance to level using OAuth Token with permited scopes
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    ${scope_value}=    Create Dictionary    scopeValue=${SCALE_TO_LEVEL_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    ${template}=    Get File    jsons/scaleVnfToLevelRequestWithinstantiationLevelId.json
    ${body}=        Format String   ${template}     instantiationLevelId=${instantiationLevelId} 
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/scale_to_level    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

POST Scale vnfInstance to level with instantiationLevelId and not permitted authorization scope
    Log    Trying to scale a vnf Instance to level using OAuth Token with not permited scopes
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    ${scope_value}=    Create Dictionary    scopeValue=${NEG_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    ${template}=    Get File    jsons/scaleVnfToLevelRequestWithinstantiationLevelId.json
    ${body}=        Format String   ${template}     instantiationLevelId=${instantiationLevelId} 
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/scale_to_level    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

POST Change VNF deployment flavour with permited authorization scope
    Log    Trying to change the deployment flavour of a VNF instance with permited authorization scope.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    ${scope_value}=    Create Dictionary    scopeValue=${CHANGE_FLAVOUR_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    ${template}=    Get File    jsons/changeVnfFlavourRequest.json
    ${body}=        Format String   ${template}     newFlavourId=${newFlavourId} 
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/change_flavour    ${body} 
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
POST Change VNF deployment flavour with not permited authorization scope
    Log    Trying to change the deployment flavour of a VNF instance with not permited authorization scope.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    ${scope_value}=    Create Dictionary    scopeValue=${NEG_SCOPE} 
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    ${template}=    Get File    jsons/changeVnfFlavourRequest.json
    ${body}=        Format String   ${template}     newFlavourId=${newFlavourId} 
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/change_flavour    ${body} 
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
POST Terminate VNF with permitted authorization scope
    Log    Trying to terminate a VNF instance with permitted authorization scope.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    ${scope_value}=    Create Dictionary    scopeValue=${TERMINATE_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    ${template}=    Get File    jsons/terminateVnfRequest.json
    ${body}=        Format String   ${template}     terminationType=${terminationType} 
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/terminate    ${body}	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
POST Terminate VNF with not permitted authorization scope
    Log    Trying to terminate a VNF instance with not permitted authorization scope.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    ${scope_value}=    Create Dictionary    scopeValue=${NEG_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    ${template}=    Get File    jsons/terminateVnfRequest.json
    ${body}=        Format String   ${template}     terminationType=${terminationType} 
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/terminate    ${body}	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
POST Heal VNF with permitted authorization scope
    Log    Trying to heal a VNF instance with permitted authorization scope.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    ${scope_value}=    Create Dictionary    scopeValue=${HEAL_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    ${template}=    Get File    jsons/healVnfRequest.json
    ${body}=        Format String   ${template}     healingCause=${healingCause}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/heal    ${body}		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
POST Heal VNF with not permitted authorization scope
    Log    Trying to heal a VNF instance with not permitted authorization scope.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    ${scope_value}=    Create Dictionary    scopeValue=${NEG_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    ${template}=    Get File    jsons/healVnfRequest.json
    ${body}=        Format String   ${template}     healingCause=${healingCause}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/heal    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
POST Change External VNF Connectivity with permitted authorization scope
    Log    Trying to change the external connectivity of a VNF instance with permitted authorization scope.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    ${scope_value}=    Create Dictionary    scopeValue=${CHANGE_EXT_CONN_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    ${template}=    Get File    jsons/changeExtVnfConnectivityRequest.json
    ${body}=        Format String   ${template}     CPD_IDs=${CPD_IDs}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/change_ext_conn    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
POST Change External VNF Connectivity with not permitted authorization scope
    Log    Trying to change the external connectivity of a VNF instance with not permitted authorization scope.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    ${scope_value}=    Create Dictionary    scopeValue=${NEG_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    ${template}=    Get File    jsons/changeExtVnfConnectivityRequest.json
    ${body}=        Format String   ${template}     CPD_IDs=${CPD_IDs}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/change_ext_conn    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
POST Operate VNF with permitted authorization scope
    Log    Trying to operate a VNF instance with permitted authorization scope.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    ${scope_value}=    Create Dictionary    scopeValue=${OPERATE_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    ${template}=    Get File    jsons/operateVnfRequest.json
    ${body}=        Format String   ${template}     changeStateTo=${changeStateTo} 
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/operate    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	
POST Operate VNF with not permitted authorization scope
    Log    Trying to operate a VNF instance with not permitted authorization scope.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    ${scope_value}=    Create Dictionary    scopeValue=${NEG_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    ${template}=    Get File    jsons/operateVnfRequest.json
    ${body}=        Format String   ${template}     changeStateTo=${changeStateTo} 
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/operate    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	
POST Create VNF Snapshot Task with permitted authorization scope
    Log    Trying to request a snapshot of a VNF instance with permitted authorization scope.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    ${scope_value}=    Create Dictionary    scopeValue=${CREATE_SNAPSHOT_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    ${template}=    Get File    jsons/CreateVnfSnapshotRequest.json
    ${body}=        Format String   ${template}     vnfSnapshotInfoId=${vnfSnapshotInfoId} 
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/create_snapshot    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
POST Create VNF Snapshot Task with not permitted authorization scope
    Log    Trying to request a snapshot of a VNF instance with not permitted authorization scope.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    ${scope_value}=    Create Dictionary    scopeValue=${NEG_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    ${template}=    Get File    jsons/CreateVnfSnapshotRequest.json
    ${body}=        Format String   ${template}     vnfSnapshotInfoId=${vnfSnapshotInfoId} 
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/create_snapshot    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
POST Revert to VNF Snapshot Task with permitted authorization scope
    Log    Trying to initiate revert to VNF snapshot task with permitted authorization scope.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    ${scope_value}=    Create Dictionary    scopeValue=${REVERT_TO_SNAPSHOT_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    ${template}=    Get File    jsons/RevertToVnfSnapshotRequest.json
    ${body}=        Format String   ${template}     vnfSnapshotInfoId=${vnfSnapshotInfoId} 
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/revert_to_snapshot    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
POST Revert to VNF Snapshot Task with not permitted authorization scope
    Log    Trying to initiate revert to VNF snapshot task with not permitted authorization scope.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    ${scope_value}=    Create Dictionary    scopeValue=${NEG_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    ${template}=    Get File    jsons/RevertToVnfSnapshotRequest.json
    ${body}=        Format String   ${template}     vnfSnapshotInfoId=${vnfSnapshotInfoId} 
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/revert_to_snapshot    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
POST Change Current VNF Package Task with permitted authorization scope
    Log    Trying to change current VNF package task with permitted authorization scope.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    ${scope_value}=    Create Dictionary    scopeValue=${CHANGE_VNFPKG_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    ${template}=    Get File    jsons/changeCurrentVnfPkgRequest.json
    ${body}=        Format String   ${template}     vnfdId=${vnfdId} 
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/change_vnfpkg    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}  
POST Change Current VNF Package Task with not permitted authorization scope
    Log    Trying to change current VNF package task with not permitted authorization scope.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    ${scope_value}=    Create Dictionary    scopeValue=${NEG_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    ${template}=    Get File    jsons/changeCurrentVnfPkgRequest.json
    ${body}=        Format String   ${template}     vnfdId=${vnfdId} 
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId}/change_vnfpkg    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}  
POST Create a new vnfInstance with permitted authorization scope
    Log    Create VNF instance by POST to ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances with permitted authorization scope.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    ${scope_value}=    Create Dictionary    scopeValue=${VNF_INSTANCE_INFO_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    Run Keyword If    ${check_descriptors} == 1    PARSE the Descriptor File
    ${template} =    Get File    jsons/createVnfRequest.json
    ${body}=        Format String   ${template}     vnfdId=${Descriptor_ID}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 	
POST Create a new vnfInstance with not permitted authorization scope
    Log    Create VNF instance by POST to ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances with not permitted authorization scope.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    ${scope_value}=    Create Dictionary    scopeValue=${NEG_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    Run Keyword If    ${check_descriptors} == 1    PARSE the Descriptor File
    ${template} =    Get File    jsons/createVnfRequest.json
    ${body}=        Format String   ${template}     vnfdId=${Descriptor_ID}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
GET individual vnfInstance with permitted authorization scope
    log    Trying to get information about an individual VNF instance with permitted authorization scope.
    Set Headers    {"Accept":"${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    ${scope_value}=    Create Dictionary    scopeValue=${VNF_INSTANCE_INFO_READONLY_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
GET individual vnfInstance with not permitted authorization scope
    log    Trying to get information about an individual VNF instance with not permitted authorization scope.
    Set Headers    {"Accept":"${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    ${scope_value}=    Create Dictionary    scopeValue=${NEG_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
GET VNF LCM OP occurrences with permitted authorization scope
    Log    Query status information about multiple VNF lifecycle management operation occurrences with permitted authorization scope.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    ${scope_value}=    Create Dictionary    scopeValue=${OPERATION_OCCURANCE_READONLY_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	
GET VNF LCM OP occurrences with not permitted authorization scope
    Log    Query status information about multiple VNF lifecycle management operation occurrences with not permitted authorization scope.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    ${scope_value}=    Create Dictionary    scopeValue=${NEG_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	
Get Individual VNF LCM OP occurrences with permitted authorization scope
    log    Query status information about an individual VNF lifecycle management operation occurrence with permitted authorization scope.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    ${scope_value}=    Create Dictionary    scopeValue=${OPERATION_OCCURANCE_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs/${vnfLcmOpOccId}	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	
Get Individual VNF LCM OP occurrences with not permitted authorization scope
    log    Query status information about an individual VNF lifecycle management operation occurrence with not permitted authorization scope.
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    ${scope_value}=    Create Dictionary    scopeValue=${NEG_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs/${vnfLcmOpOccId}	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
Post Retry operation with permitted authorization scope
    Log    Retry a VNF lifecycle operation if that operation has experienced a temporary failure with permitted authorization scope.
    ${scope_value}=    Create Dictionary    scopeValue=${OPERATION_OCCURANCE_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    Log    Execute Query and validate response
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs/${vnfLcmOpOccId}/retry	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
Post Retry operation with not permitted authorization scope
    Log    Retry a VNF lifecycle operation if that operation has experienced a temporary failure with not permitted authorization scope.
    ${scope_value}=    Create Dictionary    scopeValue=${NEG_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    Log    Execute Query and validate response
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs/${vnfLcmOpOccId}/retry	
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
Post Rollback operation with permitted authorization scope
    Log    Rollback a VNF lifecycle operation if that operation has experienced a temporary failure with permitted autorization scope.
    ${scope_value}=    Create Dictionary    scopeValue=${OPERATION_OCCURANCE_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    Log    Execute Query and validate response
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs/${vnfLcmOpOccId}/rollback
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
Post Rollback operation with not permitted authorization scope
    Log    Rollback a VNF lifecycle operation if that operation has experienced a temporary failure with not permitted autorization scope.
    ${scope_value}=    Create Dictionary    scopeValue=${NEG_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    Log    Execute Query and validate response
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs/${vnfLcmOpOccId}/rollback
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
Post Fail operation with permitted authorization scope
    Log    mark as Failed a VNF lifecycle operation if that operation has experienced a failure with permitted authorization scope
    ${scope_value}=    Create Dictionary    scopeValue=${OPERATION_OCCURANCE_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    Log    Execute Query and validate response
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs/${vnfLcmOpOccId}/fail
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
Post Fail operation with not permitted authorization scope
    Log    mark as Failed a VNF lifecycle operation if that operation has experienced a failure with not permitted authorization scope
    ${scope_value}=    Create Dictionary    scopeValue=${NEG_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    Log    Execute Query and validate response
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs/${vnfLcmOpOccId}/fail
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
POST Cancel operation task with permitted authorization scope
    Log    Cancel an ongoing VNF lifecycle operation with permitted authorization scope.
    ${scope_value}=    Create Dictionary    scopeValue=${OPERATION_OCCURANCE_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    Log    Cancel a VNF lifecycle operation
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs/${vnfLcmOpOccId}/cancel    ${CancelMode}
    Log    Validate Status code
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
POST Cancel operation task with not permitted authorization scope
    Log    Cancel an ongoing VNF lifecycle operation
    ${scope_value}=    Create Dictionary    scopeValue=${NEG_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    Log    Cancel a VNF lifecycle operation with not permitted authorization scope
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs/${vnfLcmOpOccId}/cancel    ${CancelMode}
    Log    Validate Status code
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
Post Create subscription with permitted authorization scope
    Log    Create subscription instance by POST to ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions with permitted authorization scope
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    ${scope_value}=    Create Dictionary    scopeValue=${SUBSCRIPTIONS_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    ${template}=    Get File    jsons/lccnSubscriptionRequest.json
    ${body}=        Format String   ${template}    vnfdIds=${vnfdIds}     callback_uri=${callback_uri}:${callback_port}    callback_endpoint=${callback_endpoint}
    Log  Creating mock request and response to handle GET operation on notification endpoint
    &{notification_request}=  Create Mock Request Matcher	GET  ${callback_endpoint}
    &{notification_response}=  Create Mock Response	status_code=204
    Log    Issue the subscription request
    Create Mock Expectation  ${notification_request}  ${notification_response}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions    ${body}    allow_redirects=false
	${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	Clear Requests    ${callback_endpoint}
Post Create subscription with not permitted authorization scope
    Log    Create subscription instance by POST to ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions with not permitted authorization scope
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    ${scope_value}=    Create Dictionary    scopeValue=${NEG_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    ${template}=    Get File    jsons/lccnSubscriptionRequest.json
    ${body}=        Format String   ${template}    vnfdIds=${vnfdIds}     callback_uri=${callback_uri}:${callback_port}    callback_endpoint=${callback_endpoint}
    Log  Creating mock request and response to handle GET operation on notification endpoint
    &{notification_request}=  Create Mock Request Matcher	GET  ${callback_endpoint}
    &{notification_response}=  Create Mock Response	status_code=204
    Log    Issue the subscription request
    Create Mock Expectation  ${notification_request}  ${notification_response}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions    ${body}    allow_redirects=false
	${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	Clear Requests    ${callback_endpoint}
GET individual VNF Snapshot with permitted authorization scope
    log    Trying to get information about an individual VNF snapshot with permitted authorization scope
    Set Headers    {"Accept":"${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    ${scope_value}=    Create Dictionary    scopeValue=${VNF_SNAPSHOT_INFO_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots/${vnfSnapshotInfoId} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}     
GET individual VNF Snapshot with not permitted authorization scope
    log    Trying to get information about an individual VNF snapshot with not permitted authorization scope
    Set Headers    {"Accept":"${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    ${scope_value}=    Create Dictionary    scopeValue=${NEG_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots/${vnfSnapshotInfoId} 		
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}  
Get Individual subscription with permitted authorization scope
    log    Trying to get information about an individual subscription with permitted authorization scope
    Set Headers    {"Accept":"${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    ${scope_value}=    Create Dictionary    scopeValue=${SUBSCRIPTIONS_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	
Get Individual subscription with not permitted authorization scope
    log    Trying to get information about an individual subscription with not permitted authorization scope
    Set Headers    {"Accept":"${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    ${scope_value}=    Create Dictionary    scopeValue=${NEG_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	
POST Create a new VNF Snapshot with permitted authorization scope
    Log    Create VNF snapshot by POST to ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots with permitted authorization scope
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    ${scope_value}=    Create Dictionary    scopeValue=${VNF_SNAPSHOT_INFO_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    ${template} =    Get File    jsons/CreateVnfSnapshotInfoRequest.json
    ${body}=        Format String   ${template}     vnfSnapshotPkgId=${vnfSnapshotPkgId}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 	
POST Create a new VNF Snapshot with not permitted authorization scope
    Log    Create VNF snapshot by POST to ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots with not permitted authorization scope
    Set Headers  {"Accept":"${ACCEPT}"}  
    Set Headers  {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    ${scope_value}=    Create Dictionary    scopeValue=${NEG_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    ${template} =    Get File    jsons/CreateVnfSnapshotInfoRequest.json
    ${body}=        Format String   ${template}     vnfSnapshotPkgId=${vnfSnapshotPkgId}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_snapshots    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
GET reach the notification endpoint  
    Log    Trying to reach the notification endpoint using GET method.
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${callbackResp}
    ${outputResponse}=    Output    response
    Set Global Variable    ${response}    ${outputResponse}
PUT notification endpoint  
    Log    Trying to perform a PUT. This method should not be implemented.
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${callbackResp}
    ${outputResponse}=    Output    response
    Set Global Variable    ${response}    ${outputResponse}
PATCH notification endpoint  
    Log    Trying to perform a PATCH. This method should not be implemented.
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${callbackResp}
    ${outputResponse}=    Output    response
    Set Global Variable    ${response}    ${outputResponse}

DELETE notification endpoint  
    Log    Trying to perform a DELETE. This method should not be implemented.
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${callbackResp}
    ${outputResponse}=    Output    response
    Set Global Variable    ${response}    ${outputResponse}
    
Check operation resource state is ROLLED_BACK
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_lcm_op_occs/${vnfLcmOpOccId} 
    String    response body instantiationState    ROLLED_BACK   

Check HTTP Response Header Contain Link to next page
    ${linkURL}=    Get Value From Json    ${response['headers']}    $..Link
    Should Not Be Empty    ${linkURL}
    Log    Check that Link header contains rel set to next
    Should Contain    ${linkURL}    rel="next"
    Log    Check that Link header contains URI to next page between <>
    ${linkHeaderUri}=    Get Regexp Matches    ${linkURL}    (?<=\<)(.*?)(?=\>)
    ${length}=    Get Length    ${linkHeaderUri}    
    Should Be Equal As Integers    ${length}   0
    Set Global Variable    ${nextPageUri}    ${linkHeaderUri[0]} 

Get multiple vnfInstances with nextpage_opaque_marker parameter
    Log    Get next page of subscriptions
    Set Headers  {"Accept":"${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Log    Execute Query using the URI provided in the previous GET request and validate response
    Get    ${nextPageUri}
    ${outputResponse}=    Output    response
    Set Global Variable    ${response}    ${outputResponse}
