*** Settings ***
Resource    environment/variables.txt  
Resource    VnfLcmOperationKeywords.robot
Library    REST    ${VNFM_SCHEMA}://${VNFM_HOST}:${VNFM_PORT}     ssl_verify=false
Library    OperatingSystem
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/

*** Test Cases ***
POST Create a new vnfInstance
    [Documentation]    Test ID: 6.3.5.1.1
    ...    Test title: POST Create a new vnfInstance
    ...    Test objective: The objective is to create a new VNF instance resource
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.2.3.1 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: VNF instance created
    POST Create a new vnfInstance
    Check HTTP Response Status Code Is    201
    Check HTTP Response Header Contains    Location
    Check HTTP Response Body Json Schema Is    vnfInstance
    Check HTTP Response Body vnfInstance content against VNF Descriptor

GET information about multiple VNF instances  
    [Documentation]    Test ID: 6.3.5.1.2
    ...    Test title: GET information about multiple VNF instances
    ...    Test objective: The objective is to get information about multiples VNF instances
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.2.3.2 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple vnfInstances
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    vnfInstances
    Check HTTP Response Body vnfInstances content against VNF Descriptor    
    
GET information about multiple VNF instances Bad Request Invalid attribute-based filtering parameters
    [Documentation]    Test ID: 6.3.5.1.3
    ...    Test title: GET information about multiple VNF instances Bad Request Invalid attribute-based filtering parameters
    ...    Test objective: The objective is to get information about multiples VNF instances with Invalid attribute-based filtering parameters
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.2.3.2 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple vnfInstances with bad attribute
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is   ProblemDetails

GET information about multiple VNF instances Bad Request Invalid attribute selector
    [Documentation]    Test ID: 6.3.5.1.4
    ...    Test title: GET information about multiple VNF instances Bad Request Invalid attribute selector
    ...    Test objective: The objective is to get information about multiples VNF instances with Invalid attribute-based filtering parameters
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.2.3.2 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple vnfInstances with bad filter
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is   ProblemDetails

GET information about multiple VNF instances with "all_fields" attribute selector
    [Documentation]    Test ID: 6.3.5.1.5
    ...    Test title: GET information about multiple VNF instances with "all_fields" attribute selector
    ...    Test objective: The objective is to query information about multiple VNF instances
    ...    Pre-conditions:  none
    ...    Reference: Clause 5.4.2.3.2 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple vnfInstances with all_fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    vnfInstances

GET information about multiple VNF instances with "exclude_default" attribute selector
    [Documentation]    Test ID: 6.3.5.1.6
    ...    Test title: GET information about multiple VNF instances with "exclude_default" attribute selector
    ...    Test objective: The objective is to query information about multiple VNF instances
    ...    Pre-conditions:  none
    ...    Reference: Clause 5.4.2.3.2 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple vnfInstances with exclude_default attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    vnfInstances
    
GET information about multiple VNF instances with "fields" attribute selector
    [Documentation]    Test ID: 6.3.5.1.7
    ...    Test title: GET information about multiple VNF instances with "fields" attribute selector
    ...    Test objective: The objective is to query information about multiple VNF instances
    ...    Pre-conditions:  none
    ...    Reference: Clause 5.4.2.3.2 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple vnfInstances with fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    vnfInstances

GET information about multiple VNF instances with "exclude_fields" attribute selector
    [Documentation]    Test ID: 6.3.5.1.8
    ...    Test title: GET information about multiple VNF instances with "exclude_fields" attribute selector
    ...    Test objective: The objective is to query information about multiple VNF instances
    ...    Pre-conditions:  none
    ...    Reference: Clause 5.4.2.3.2 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple vnfInstances with exclude_fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    vnfInstances  
        
PUT VNFInstances - Method not implemented
    [Documentation]    Test ID: 6.3.5.1.9
    ...    Test title: PUT VNFInstances - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not implemented
    ...    Pre-conditions:  none
    ...    Reference: Clause 5.4.2.3.3 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none
    PUT multiple vnfInstances
    Check HTTP Response Status Code Is    405

PATCH VNFInstances - Method not implemented
    [Documentation]    Test ID: 6.3.5.1.10
    ...    Test title: PATCH VNFInstances - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not implemented
    ...    Pre-conditions: none 
    ...    Reference: Clause 5.4.2.3.4 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH multiple vnfInstances
    Check HTTP Response Status Code Is    405

DELETE VNFInstances - Method not implemented
    [Documentation]    Test ID: 6.3.5.1.11
    ...    Test title: DELETE VNFInstances - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not implemented
    ...    Pre-conditions: none 
    ...    Reference: Clause 5.4.2.3.5 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: VNF instance not deleted
    DELETE multiple vnfInstances
    Check HTTP Response Status Code Is    405
    
GET information about multiple VNF instances with "exclude_default" and "fields" attribute selector
    [Documentation]    Test ID: 6.3.5.1.12
    ...    Test title: GET information about multiple VNF instances with "exclude_default" and "fields" attribute selector
    ...    Test objective: The objective is to query information about multiple VNF instances
    ...    Pre-conditions:  none
    ...    Reference: Clause 5.4.2.3.2 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple vnfInstances with exclude_default and fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    vnfInstances
    
POST Create a new vnfInstance - UNPROCESSABLE CONTENT
    [Documentation]    Test ID: 6.3.5.1.13
    ...    Test title: POST Create a new vnfInstance - UNPROCESSABLE CONTENT
    ...    Test objective: The objective is to test that a new VNF instance resource is not created when 
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.2.3.1 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: vnfdId of the referenced VNF package is not in ENABLED state or does not exist.
    ...    Post-Conditions: VNF instance created
    POST Create a new vnfInstance with Invalid vnfdId
    Check HTTP Response Status Code Is    422
    Check HTTP Response Body Json Schema Is    ProblemDetails    
POST Create a new vnfInstance with permitted authorization scope
    [Documentation]    Test ID: 6.3.5.1.14
    ...    Test title: POST Create a new vnfInstance with permitted authorization scope
    ...    Test objective: The objective is to create a new VNF instance resource with permitted authorization scope
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.2.3.1 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: VNF instance created
    POST Create a new vnfInstance with permitted authorization scope
    Check HTTP Response Status Code Is    201
    Check HTTP Response Header Contains    Location
    Check HTTP Response Body Json Schema Is    vnfInstance
    Check HTTP Response Body vnfInstance content against VNF Descriptor
POST Create a new vnfInstance with not permitted authorization scope
    [Documentation]    Test ID: 6.3.5.1.15
    ...    Test title: POST Create a new vnfInstance with not permitted authorization scope
    ...    Test objective: The objective is to create a new VNF instance resource with not permitted authorization scope
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.2.3.1 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: VNF instance created
    POST Create a new vnfInstance with not permitted authorization scope
    Check HTTP Response Status Code Is    403
    Check HTTP Response Body Json Schema Is    ProblemDetails
GET information about multiple VNF instances - Bad Request Response too big
    [Documentation]    Test ID: 6.3.5.1.16
    ...    Test title: GET information about multiple VNF instances - Bad Request Response too big
    ...    Test objective: The objective is to test that GET method fail retrieving information about multiple VNF instances because Response is too big.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.2.3.2 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none 
    GET multiple vnfInstances
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is    ProblemDetails

GET information about multiple VNF instances to get Paged Response
    [Documentation]    Test ID: 6.3.5.1.17
    ...    Test title: GET information about multiple VNF instances to get Paged Response
    ...    Test objective: The objective is to query information about multiple VNF instances to get Paged Response.
    ...    Pre-conditions:  none
    ...    Reference: Clause 5.4.2.3.2 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: The VNFM supports response paging for the subscriptions resources
    ...    Post-Conditions: none
    GET multiple vnfInstances
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Contain Link to next page

GET information about multiple VNF instances as a Paged Response with nextpage_opauque_marker parameter 
    [Documentation]    Test ID: 6.3.5.1.17a
    ...    Test title: GET information about multiple VNF instances as a Paged Response with nextpage_opauque_marker parameter 
    ...    Test objective: The objective is to query information about multiple VNF instances as a Paged Response and retrieve the next page using the nextpage_opaque_marker parameter
    ...    Pre-conditions: A request for retrieving multiple VNF instances as a paged response has been successfully issued (Test ID 6.3.5.1.17)
    ...    Reference: Clause 5.4.2.3.2 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: The VNFM supports response paging for the VNF instance resources
    ...    Post-Conditions: none 
    Get multiple vnfInstances with nextpage_opaque_marker parameter 
    Check HTTP Response Status Code Is    200