*** Settings ***
Resource    environment/variables.txt 
Resource    VnfLcmOperationKeywords.robot
Library    REST    ${VNFM_SCHEMA}://${VNFM_HOST}:${VNFM_PORT}        ssl_verify=false
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/
*** Test Cases ***
Post Individual VNF LCM OP occurrences - Method not implemented
    [Documentation]    Test ID: 6.3.5.12.1
    ...    Test title: Post Individual VNF LCM OP occurrences - Method not implemented
    ...    Test objective: The objective is to test that POST method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.13.3.1 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post Individual VNF LCM OP occurrences
    Check HTTP Response Status Code Is    405
    
Get status information about individual VNF instances 
    [Documentation]    Test ID: 6.3.5.12.2
    ...    Test title: Get status information about individual VNF instances
    ...    Test objective: The objective is to test that this method retrieve status information about a VNF lifecycle management operation occurrence 
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.13.3.2 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none 
    Get Individual VNF LCM OP occurrences
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    vnfLcmOpOcc 
    Check HTTP Response Body vnf LCM OpOCC content against VNF Descriptor

PUT status information about multiple VNF instances - Method not implemented
    [Documentation]    Test ID: 6.3.5.12.3
    ...    Test title: PUT status information about multiple VNF instances - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.13.3.3 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none  
    PUT Individual VNF LCM OP occurrences
    Check HTTP Response Status Code Is    405

PATCH status information about multiple VNF instances - Method not implemented 
    [Documentation]    Test ID: 6.3.5.12.4
    ...    Test title: PATCH status information about multiple VNF instances - Method not implemented 
    ...    Test objective: The objective is to test that PATCH method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.13.3.4 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none      
    PATCH Individual VNF LCM OP occurrences
    Check HTTP Response Status Code Is    405
    
DELETE status information about multiple VNF instances - Method not implemented 
    [Documentation]    Test ID: 6.3.5.12.5
    ...    Test title: DELETE status information about multiple VNF instances - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.13.3.5 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none  
    DELETE Individual VNF LCM OP occurrences
    Check HTTP Response Status Code Is    405

Get status information about individual VNF instances with permitted authorization scope
    [Documentation]    Test ID: 6.3.5.12.6
    ...    Test title: Get status information about individual VNF instances with permitted authorization scope
    ...    Test objective: The objective is to test that this method retrieve status information about a VNF lifecycle management operation occurrence with permitted authorization scope
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.13.3.2 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none 
    Get Individual VNF LCM OP occurrences with permitted authorization scope
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    vnfLcmOpOcc 
    Check HTTP Response Body vnf LCM OpOCC content against VNF Descriptor

Get status information about individual VNF instances with not permitted authorization scope
    [Documentation]    Test ID: 6.3.5.12.7
    ...    Test title: Get status information about individual VNF instances with not permitted authorization scope
    ...    Test objective: The objective is to test that this method retrieve status information about a VNF lifecycle management operation occurrence with not permitted authorization scope
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.13.3.2 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none 
    Get Individual VNF LCM OP occurrences with not permitted authorization scope
    Check HTTP Response Status Code Is    403
    Check HTTP Response Body Json Schema Is    ProblemDetails

Get Individual VNF LCM Operation occurrences - Not Found
    [Documentation]    Test ID: 6.3.5.12.8
    ...    Test title: Get status information about individual VNF instances - Not Found
    ...    Test objective: The objective is to test that the retrieval of VNF lifecycle management operation occurrence fails when instance is not present. 
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.13.3.2 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none 
    Get Individual VNF LCM OP occurrences
    Check HTTP Response Status Code Is    404 
    Check HTTP Response Body Json Schema Is    ProblemDetails