*** Settings ***
Resource    environment/variables.txt 
Resource    VnfLcmOperationKeywords.robot
Library    REST    ${VNFM_SCHEMA}://${VNFM_HOST}:${VNFM_PORT}     ssl_verify=false
Library    DependencyLibrary
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/

*** Test Cases ***
POST Fail operation task  
    [Documentation]    Test ID: 6.3.5.15.1
    ...    Test title: POST Fail operation task
    ...    Test objective: The objective is to test that POST method mark as "finally failed" a VNF lifecycle operation if that operation has experienced a failure
    ...    Pre-conditions: the "VNF LCM operation occurrence" resource is in "FAILED_TEMP" state.
    ...    Reference: Clause 5.4.16.3.1 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post Fail operation
    Check HTTP Response Status Code Is    200
    Check Operation Occurrence Id
    Check operation resource state is FINALLY_FAILED

POST Fail operation task Conflict (Not-FAILED_TEMP)
    [Documentation]    Test ID: 6.3.5.15.2
    ...    Test title: POST Fail operation task Conflict (Not-FAILED_TEMP)
    ...    Test objective: The objective is to test that POST method cannot mark as "finally failed" due to confilct with the state of LCM Operation Occurrence
    ...    Pre-conditions: the "VNF LCM operation occurrence" resource is not in "FAILED_TEMP" state.
    ...    Reference: Clause 5.4.16.3.1 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none     
    Post Fail operation
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is    ProblemDetails

POST Fail operation task Not Found
    [Documentation]    Test ID: 6.3.5.15.3
    ...    Test title: POST Fail operation task Not Found
    ...    Test objective: The objective is to test that POST method cannot mark as "finally failed" a VNF lifecycle operation because the operation is not supported
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.16.3.1 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none  
    Post Fail operation
    Check HTTP Response Status Code Is    404
    Check HTTP Response Body Json Schema Is    ProblemDetails

GET Fail operation task - Method not implemented
     [Documentation]    Test ID: 6.3.5.15.4
    ...    Test title: GET Fail operation task- Method not implemented
    ...    Test objective: The objective is to verify that the method is not implemented 
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.16.3.2 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Fail operation
    Check HTTP Response Status Code Is    405

PUT Fail operation task - Method not implemented
     [Documentation]    Test ID: 6.3.5.15.5
    ...    Test title: PUT Fail operation task- Method not implemented
    ...    Test objective: The objective is to verify that the method is not implemented 
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.16.3.3 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none 
    Put Fail operation
    Check HTTP Response Status Code Is    405

PATCH Fail operation task - Method not implemented
     [Documentation]    Test ID: 6.3.5.15.6
    ...    Test title: PATCH Fail operation task - Method not implemented
    ...    Test objective: The objective is to verify that the method is not implemented 
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.16.3.4 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none 
    Patch Fail operation
    Check HTTP Response Status Code Is    405
    
DELETE Fail operation task - Method not implemented
     [Documentation]    Test ID: 6.3.5.15.7
    ...    Test title: DELETE Fail operation task- Method not implemented
    ...    Test objective: The objective is to verify that the method is not implemented 
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.16.3.5 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none
    Delete Fail operation
    Check HTTP Response Status Code Is    405
POST Fail operation task with permitted authorization scope
    [Documentation]    Test ID: 6.3.5.15.8
    ...    Test title: POST Fail operation task with permitted authorization scope with permitted authorization scope
    ...    Test objective: The objective is to test that POST method mark as "finally failed" a VNF lifecycle operation if that operation has experienced a failure with permitted authorization scope
    ...    Pre-conditions: the "VNF LCM operation occurrence" resource is in "FAILED_TEMP" state.
    ...    Reference: Clause 5.4.16.3.1 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post Fail operation with permitted authorization scope
    Check HTTP Response Status Code Is    200
    Check Operation Occurrence Id
    Check operation resource state is FINALLY_FAILED
POST Fail operation task with not permitted authorization scope
    [Documentation]    Test ID: 6.3.5.15.9
    ...    Test title: POST Fail operation task with permitted authorization scope with not permitted authorization scope
    ...    Test objective: The objective is to test that POST method mark as "finally failed" a VNF lifecycle operation if that operation has experienced a failure with not permitted authorization scope
    ...    Pre-conditions: the "VNF LCM operation occurrence" resource is in "FAILED_TEMP" state.
    ...    Reference: Clause 5.4.16.3.1 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post Fail operation with permitted authorization scope
    Check HTTP Response Status Code Is    403
    Check HTTP Response Body Json Schema Is    ProblemDetails
