*** Settings ***
Resource    environment/variables.txt 
Resource    VnfLcmOperationKeywords.robot
Library    REST    ${VNFM_SCHEMA}://${VNFM_HOST}:${VNFM_PORT}     ssl_verify=false
Library    OperatingSystem
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/
Suite Setup    Check resource existence

*** Test Cases ***
POST Create VNF Snapshot Task 
    [Documentation]    Test ID: 6.3.5.23.1
    ...    Test title: POST Create VNF Snapshot Task
    ...    Test objective: The objective is to test that POST method requests taking a snapshot of a VNF instance.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.21.3.1 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: in response header Location shall not be null         
    POST Create VNF Snapshot Task
    Check HTTP Response Status Code Is    202
    Check HTTP Response Header Contains    Location
    Check Operation Occurrence Id

POST Create VNF Snapshot Task - NOT FOUND
    [Documentation]    Test ID: 6.3.5.23.2
    ...    Test title: POST Create VNF Snapshot Task - NOT FOUND
    ...    Test objective: The objective is to test that the POST method cannot request for a snapshot if the task is not supported for the VNF instance represented by the parent resource. 
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.21.3.1 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: Task is not supported for the VNF instance represented by the parent resource.
    ...    Post-Conditions: none
    POST Create VNF Snapshot Task NOT SUPPORTED
    Check HTTP Response Status Code Is    404
    Check HTTP Response Body Json Schema Is    ProblemDetails 

POST Create VNF Snapshot Task - CONFLICT
    [Documentation]    Test ID: 6.3.5.23.3
    ...    Test title: POST Create VNF Snapshot Task - CONFLICT
    ...    Test objective: The objective is to test that the POST method cannot request for a snapshot when the VNF instance is in NOT_INSTANTIATED state. 
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.21.3.1 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: VNF instance is in NOT_INSTANTIATED state.
    ...    Post-Conditions: none
    POST Create VNF Snapshot Task VNF_NOT_INSTANTIATED
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is    ProblemDetails 

POST Create VNF Snapshot Task - UNPROCESSABLE CONTENT
    [Documentation]    Test ID: 6.3.5.23.4
    ...    Test title: POST Create VNF Snapshot Task - UNPROCESSABLE CONTENT
    ...    Test objective: The objective is to test that the POST method cannot request for a snapshot when the provided identifier of the target "Individual VNF snapshot" resource for the VNF snapshot is invalid. 
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.21.3.1 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: The identifier of the target "Individual VNF snapshot" resource for the VNF snapshot is invalid.
    ...    Post-Conditions: none
    POST Create VNF Snapshot Task INVALID IDENTIFIER
    Check HTTP Response Status Code Is    422
    Check HTTP Response Body Json Schema Is    ProblemDetails 
    
GET Create VNF Snapshot Task - Method not implemented
    [Documentation]    Test ID: 6.3.5.23.5
    ...    Test title: GET Create VNF Snapshot Task - Method not implemented
    ...    Test objective: The objective is to test that GET method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.21.3.2 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none 
    GET Create VNF Snapshot Task
    Check HTTP Response Status Code Is    405

PUT Create VNF Snapshot Task - Method not implemented
    [Documentation]    Test ID: 6.3.5.23.6
    ...    Test title: PUT Create VNF Snapshot Task - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.21.3.3 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none 
    PUT Create VNF Snapshot Task
    Check HTTP Response Status Code Is    405

PATCH Create VNF Snapshot Task - Method not implemented
    [Documentation]    Test ID: 6.3.5.23.7
    ...    Test title: PATCH Create VNF Snapshot Task - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.21.3.4 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none 
    PATCH Create VNF Snapshot Task
    Check HTTP Response Status Code Is    405
    
DELETE Create VNF Snapshot Task - Method not implemented
    [Documentation]    Test ID: 6.3.5.23.8
    ...    Test title: DELETE Create VNF Snapshot Task - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.21.3.5 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: none 
    DELETE Create VNF Snapshot Task
    Check HTTP Response Status Code Is    405
POST Create VNF Snapshot Task with permitted authorization scope
    [Documentation]    Test ID: 6.3.5.23.9
    ...    Test title: POST Create VNF Snapshot Task with permitted authorization scope
    ...    Test objective: The objective is to test that POST method requests taking a snapshot of a VNF instance with permitted authorization scope.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.21.3.1 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: in response header Location shall not be null         
    POST Create VNF Snapshot Task with permitted authorization scope
    Check HTTP Response Status Code Is    202
    Check HTTP Response Header Contains    Location
    Check Operation Occurrence Id
POST Create VNF Snapshot Task with not permitted authorization scope
    [Documentation]    Test ID: 6.3.5.23.10
    ...    Test title: POST Create VNF Snapshot Task with not permitted authorization scope
    ...    Test objective: The objective is to test that POST method requests taking a snapshot of a VNF instance with not permitted authorization scope.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.21.3.1 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VE
    ...    Applicability: none
    ...    Post-Conditions: in response header Location shall not be null         
    POST Create VNF Snapshot Task with not permitted authorization scope
    Check HTTP Response Status Code Is    403
    Check HTTP Response Body Json Schema Is    ProblemDetails

*** Keywords ***
Check resource existence
    Set Headers    {"Accept":"${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances/${vnfInstanceId} 
    Integer    response status    200