*** Settings ***
Library    String
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt    # Generic Parameters
Library           OperatingSystem
Library           REST    ${EM-VNF_SCHEMA}://${EM-VNF_HOST}:${EM-VNF_PORT}    ssl_verify=false
Suite Setup    Check resource existence and get CallbackUri

*** Test Cases ***
VNF Indicator Value Change Notification
    [Documentation]    Test ID: 6.3.2.8.1
    ...    Test title: VNF Indicator Value Change Notification
    ...    Test objective: The objective is to test that the POST request triggers VNF Indicator Value Change Notification .
    ...    Pre-conditions: A VNF is instantiated, and a subscription for indicator value change notifications is available in the VNF.
    ...    Reference: Clause 8.4.7.3.1 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post Value Change Notification
    Check HTTP Response Status Code Is    204

Supported Indicators Change Notification
    [Documentation]    Test ID: 6.3.2.8.2
    ...    Test title: Supported Indicators Change Notification
    ...    Test objective: The objective is to test that the POST request triggers Supported Indicators Change Notification .
    ...    Pre-conditions: A VNF is instantiated, and a subscription for supported indicators change notifications is available in the VNF.
    ...    Reference: Clause 8.4.7.3.1 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Post Supported Indicators Change Notification
    Check HTTP Response Status Code Is    204
    
Test the Notification Endpoint - Successful
    [Documentation]    Test ID: 6.3.2.8.3
    ...    Test title: Test the Notification Endpoint - Successful
    ...    Test objective: The objective is to test the Notification Endpoint provided by the notification consumer.
    ...    Pre-conditions: A notification endpoint is provided by the API consumer upon subscription.
    ...    Reference: Clause 8.4.7.3.2 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    Get reach the notification endpoint
    Check HTTP Response Status Code Is    204
    
Test the Notification Endpoint - NOT FOUND
    [Documentation]    Test ID: 6.3.2.8.4
    ...    Test title: Test the Notification Endpoint - UNREACHABLE
    ...    Test objective: The objective is to test the Notification Endpoint provided by the notification consumer.
    ...    Pre-conditions: A notification endpoint is provided by the API consumer upon subscription.
    ...    Reference: Clause 8.4.7.3.2 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: The notification endpoint is unreachable by the API producer.
    ...    Post-Conditions: none 
    GET reach an unreachable notification endpoint
    Check HTTP Response Status Code Is    404
    Check HTTP Response Body Json Schema Is    ProblemDetails    
    
PUT Notification endpoint - Method Not Implemented
    [Documentation]    Test ID: 6.3.2.8.5
    ...    Test title: PUT Notification endpoint - Method Not Implemented
    ...    Test objective: The objective is to test the PUT method for Notification Endpoint provided by the consumer is not implemented.
    ...    Pre-conditions: A notification endpoint is provided by the API consumer upon subscription.
    ...    Reference: Clause 8.4.7.3.3 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    PUT notification endpoint
    Check HTTP Response Status Code Is    405
    
PATCH Notification endpoint - Method Not Implemented
    [Documentation]    Test ID: 6.3.2.8.6
    ...    Test title: PATCH Notification endpoint - Method Not Implemented
    ...    Test objective: The objective is to test the PATCH method for Notification Endpoint provided by the consumer is not implemented.
    ...    Pre-conditions: A notification endpoint is provided by the API consumer upon subscription.
    ...    Reference: Clause 8.4.7.3.4 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    PATCH notification endpoint
    Check HTTP Response Status Code Is    405

DELETE Notification endpoint - Method Not Implemented
    [Documentation]    Test ID: 6.3.2.8.7
    ...    Test title: DELETE Notification endpoint - Method Not Implemented
    ...    Test objective: The objective is to test the DELETE method for Notification Endpoint provided by the consumer is not implemented.
    ...    Pre-conditions: A notification endpoint is provided by the API consumer upon subscription.
    ...    Reference: Clause 8.4.7.3.5 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    DELETE notification endpoint
    Check HTTP Response Status Code Is    405
    
*** Keywords ***
Check resource existence and get CallbackUri
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}	
    Integer    response status    200
    Validate Json    response body    VnfIndicatorSubscription.schema.json
    Set Global Variable    ${callbackResp}    response body callbackUri
    
Check HTTP Response Status Code Is
    [Arguments]    ${expected_status}    
    Should Be Equal As Strings    ${response['status']}    ${expected_status}
    Log    Status code validated 
       
Post Value Change Notification
    log    Trying to perform a POST to get notification
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template} =    Get File    jsons/ValueChangeNotification.json
    ${body}=        Format String   ${template}    subscriptionId=${subscriptionId}    indicatorId=${indicatorId}    vnfInstanceId=${vnfInstanceId}
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
Post Supported Indicators Change Notification
    log    Trying to perform a POST to get notification
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template} =    Get File    jsons/SupportedIndicatorsChangeNotification.json
    ${body}=        Format String   ${template}    subscriptionId=${subscriptionId}    indicatorId=${indicatorId}    vnfInstanceId=${vnfInstanceId}
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
GET reach the notification endpoint  
    Log    Trying to reach the notification endpoint using GET method.
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${callbackResp}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
GET reach an unreachable notification endpoint  
    Log    Trying to reach the notification endpoint using GET method.
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    GET    ${unreachable_callback_uri}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

Check HTTP Response Body Json Schema Is
    [Arguments]    ${input}
    Should Contain    ${response['headers']['Content-Type']}    application/json
    ${schema} =    Catenate    SEPARATOR=    ${input}	.schema.json
    Validate Json    ${schema}    ${response['body']}
    Log    Json Schema Validation OK

PUT notification endpoint  
    Log    Trying to perform a PUT. This method should not be implemented.
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${callbackResp}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

PATCH notification endpoint  
    Log    Trying to perform a PATCH. This method should not be implemented.
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${callbackResp}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

DELETE notification endpoint  
    Log    Trying to perform a DELETE. This method should not be implemented.
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Version": "${API_VERSION}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${callbackResp}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}