*** Settings ***
Resource    environment/variables.txt  
Library    REST    ${VNFM_SCHEMA}://${VNFM_HOST}:${VNFM_PORT}     ssl_verify=false
Library    OperatingSystem
Library    JSONLibrary
Library    JSONSchemaLibrary    schemas/
Library    DependencyLibrary
Library    jwt

*** Variables **
${original_etag}    1234

*** Test Cases ***
POST Alarm - Method not implemented
    [Documentation]    Test ID: 6.3.4.2.1
    ...    Test title: POST Alarm - Method not implemented
    ...    Test objective: The objective is to test that the method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 7.4.3.3.1 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    POST Alarm Task
    Check HTTP Response Status Code Is    405

GET information about an individual alarm
    [Documentation]    Test ID: 6.3.4.2.2
    ...    Test title: GET information about an individual alarm
    ...    Test objective: The objective is to read an individual alarm.
    ...    Pre-conditions: The related alarm exists
    ...    Reference: Clause 7.4.3.3.2  - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none 
    ...    Post-Conditions: none
    GET Alarm Task
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Contains ETag and Last-Modified
    Check HTTP Response Body Json Schema Is    alarm
    
PUT Individual Alarm - Method not implemented
     [Documentation]    Test ID: 6.3.4.2.3
    ...    Test title: PUT Individual Alarm - Method not implemented
    ...    Test objective: The objective is to test that the method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 7.4.3.3.3 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    PUT Alarm Task
    Check HTTP Response Status Code Is    405

PATCH Individual Alarm
    [Documentation]    Test ID: 6.3.4.2.4
    ...    Test title: PATCH Individual Alarm
    ...    Test objective: The objective is to Modify an individual alarm resource
    ...    Pre-conditions: The related alarm exists
    ...    Reference: Clause 7.4.3.3.4 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH Alarm Task
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Contains ETag and Last-Modified
    Check HTTP Response Body Json Schema Is     alarmModifications
    
PATCH Individual Alarm - Precondition failed
    [Documentation]    Test ID: 6.3.4.2.5
    ...    Test title: PATCH Individual Alarm - Precondition failed
    ...    Test objective: The objective is to attempt to Modify an individual alarm resource, where the precondition was not met
    ...    Pre-conditions: The related alarm exists
    ...    Reference: Clause 7.4.3.3.4 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: The alarm resource is not modified
    PATCH Alarm Task with wrong precondition
    Check HTTP Response Status Code Is    412
    Check HTTP Response Body Json Schema Is     ProblemDetails
    Check Postcondition VNF individual alarm Unmodified (Implicit)
    
PATCH Individual Alarm - Conflict
    [Documentation]    Test ID: 6.3.4.2.6
    ...    Test title: PATCH Individual Alarm - Conflict
    ...    Test objective: The objective is to Modify an individual alarm resource
    ...    Pre-conditions: The related alarm exists
    ...    Reference: Clause 7.4.3.3.4 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: The alarm resource is not modified
    PATCH Alarm Task
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is     ProblemDetails
    Check Postcondition VNF individual alarm Unmodified (Implicit)
    
DELETE Individual Alarm - Method not implemented
    [Documentation]    Test ID: 6.3.4.2.7
    ...    Test title: DELETE Individual Alarm - Method not implemented
    ...    Test objective: The objective is to test that the method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 7.4.3.3.5 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    DELETE Alarm Task
    Check HTTP Response Status Code Is    405
    
GET information about an individual alarm - Not Found
    [Documentation]    Test ID: 6.3.4.2.8
    ...    Test title: GET information about an individual alarm - Not Found
    ...    Test objective: The objective is to test that GET method fail retrieving status information about individaual Alarms when alarm is not present.
    ...    Pre-conditions: The related alarm doesnot exists
    ...    Reference: Clause 7.4.3.3.2  - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none   
    GET Alarm Task
    Check HTTP Response Status Code Is    404
    Check HTTP Response Body Json Schema Is     ProblemDetails
PATCH Individual Alarm with permitted authorization scope
    [Documentation]    Test ID: 6.3.4.2.9
    ...    Test title: PATCH Individual Alarm with permitted authorization scope
    ...    Test objective: The objective is to Modify an individual alarm resource with permitted authorization scope
    ...    Pre-conditions: The related alarm exists
    ...    Reference: Clause 7.4.3.3.4 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH Alarm Task with permitted authorization scope
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Contains ETag and Last-Modified
    Check HTTP Response Body Json Schema Is     alarmModifications
PATCH Individual Alarm with NOT permitted authorization scope
    [Documentation]    Test ID: 6.3.4.2.10
    ...    Test title: PATCH Individual Alarm with NOT permitted authorization scope
    ...    Test objective: The objective is to Modify an individual alarm resource with NOT permitted authorization scope
    ...    Pre-conditions: The related alarm exists
    ...    Reference: Clause 7.4.3.3.4 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH Alarm Task with not permitted authorization scope
    Check HTTP Response Status Code Is    403
    Check HTTP Response Body Json Schema Is     ProblemDetails

*** Keywords ***
POST Alarm Task
    log    Trying to perform a POST. This method should not be implemented
    Set Headers    {"Accept": "${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/alarms/${alarmId}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
PUT Alarm Task
    log    Trying to perform a PUT. This method should not be implemented
    Set Headers    {"Accept": "${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${body}=    Get File    jsons/alarmModifications.json
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/alarms/${alarmId}     ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
PATCH Alarm Task
    log    Trying to perform a PATCH. This method modifies an individual alarm resource
    Set Headers    {"Accept": "${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"} 
    Set Headers  {"Content-Type": "${CONTENT_TYPE_PATCH}"}
    Set Headers  {"If-Match": "${original_etag[0]}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${body}=    Get File    jsons/alarmModifications.json
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/alarms/${alarmId}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
PATCH Alarm Task with wrong precondition
    log    Trying to perform a PATCH. This method modifies an individual alarm resource
    Set Headers    {"Accept": "${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"} 
    Set Headers  {"Content-Type": "${CONTENT_TYPE_PATCH}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${body}=    Get File    jsons/alarmModifications.json
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/alarms/${alarmId}
    ${origOutput}=    Output    response
    Set Suite Variable    ${origResponse}    ${origOutput}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/alarms/${alarmId}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	
DELETE Alarm Task
    log    Trying to perform a DELETE. This method should not be implemented
    Set Headers    {"Accept": "${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/alarms/${alarmId}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}			
GET Alarm Task	
	Log    Query VNF The GET method queries information about individual alarm.
    Set Headers    {"Accept": "${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/alarms/${alarmId}
    ${etag}    Output    response headers ETag
    Set Suite Variable    &{original_etag}    ${etag}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

Check HTTP Response Header Contains ETag and Last-Modified
    Pass Execution If    ${HEADER_TEST_SUPPORTED} == 0    Headers testing not supported. Skipping the Test.
    Log    ${response['headers']}
    Should Contain    ${response['headers']}    Etag
    Should Contain    ${response['headers']}    Last-Modified
    Log    Etag and Last-Modified Headers are present
GET Alarm Task with filter
	Log    Query VNF The GET method queries information about individual alarm with filters.
    Set Headers    {"Accept": "${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/alarms?${alarm_filter}=${managedObjectId} 
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	
GET Alarm Task with invalid filter
	Log    Query VNF The GET method queries information about individual alarm with filters.
    Set Headers    {"Accept": "${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"}  
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/alarms?${invalid_alarm_filter}=${managedObjectId} 
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}	
Check HTTP Response Status Code Is
    [Arguments]    ${expected_status}    
    Should Be Equal As Strings    ${response['status']}    ${expected_status}
    Log    Status code validated 
    
Check HTTP Response Body Json Schema Is
    [Arguments]    ${input}
    Run Keyword If    '${input}' == 'ProblemDetails'    Should Contain    ${response['headers']['Content-Type']}    application/problem+json
    ...    ELSE    Should Contain    ${response['headers']['Content-Type']}    application/json
    ${schema} =    Catenate    SEPARATOR=    ${input}	.schema.json
    Validate Json    ${schema}    ${response['body']}
    Log    Json Schema Validation OK
    
Check Postcondition VNF individual alarm Unmodified (Implicit)
    Log    Check Postcondition subscription is not modified
    GET Alarm Task
    Should Be Equal As Strings    ${origResponse['body']['callbackUri']}    ${response['body']['callbackUri']}

Check HTTP Response Header Contains
    [Arguments]    ${CONTENT_TYPE}
    Should Contain    ${response['headers']}    ${CONTENT_TYPE}
    Log    Header is present
JWT Encode
    [Arguments]    ${payload}    ${key}    ${algorithm}
    ${encoded}=    Evaluate    jwt.encode(${payload}, ${key}, ${algorithm})
    [Return]    ${encoded}
PATCH Alarm Task with permitted authorization scope
    log    Trying to perform a PATCH. This method modifies an individual alarm resource with permitted authorization scope
    Set Headers    {"Accept": "${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"} 
    Set Headers  {"Content-Type": "${CONTENT_TYPE_PATCH}"}
    Set Headers  {"If-Match": "${original_etag[0]}"}
    ${scope_value}=    Create Dictionary    scopeValue=${ALARMS_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    ${body}=    Get File    jsons/alarmModifications.json
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/alarms/${alarmId}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
PATCH Alarm Task with not permitted authorization scope
    log    Trying to perform a PATCH. This method modifies an individual alarm resource with not permitted authorization scope
    Set Headers    {"Accept": "${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"} 
    Set Headers  {"Content-Type": "${CONTENT_TYPE_PATCH}"}
    Set Headers  {"If-Match": "${original_etag[0]}"}
    ${scope_value}=    Create Dictionary    scopeValue=${NEG_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    ${body}=    Get File    jsons/alarmModifications.json
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/alarms/${alarmId}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

