*** Settings ***
Resource    environment/variables.txt 
Library    REST    ${VNFM_SCHEMA}://${VNFM_HOST}:${VNFM_PORT}    ssl_verify=false
Library    JSONSchemaLibrary
Library    OperatingSystem
Library    jwt
Library    String
Suite Setup    Check resource existence

*** Test Cases ***
Escalate the perceived severity 
    [Documentation]    Test ID: 6.3.4.3.1
    ...    Test title: Escalate the perceived severity
    ...    Test objective: To enable the consumer to escalate the perceived severity of an alarm that is represented by an individual alarm resource.
    ...    Pre-conditions: The resource representing the individual alarm has been created
    ...    Reference: Clause 7.4.4.3.1 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    Post escalate severity
    Check HTTP Response Status Code Is    204
    
GET Escalate the perceived severity - Method not implemented
    [Documentation]    Test ID: 6.3.4.3.2
    ...    Test title: GET Escalate the perceived severity - Method not implemented
    ...    Test objective: The objective is to test that the GET HTTP method not implemented for escalate perceived severity
    ...    Pre-conditions: none
    ...    Reference: Clause 7.4.4.3.2 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions:   none
    Get escalate severity
    Check HTTP Response Status Code Is    405

PUT Escalate the perceived severity - Method not implemented
    [Documentation]    Test ID: 6.3.4.3.3
    ...    Test title: PUT Escalate the perceived severity - Method not implemented
    ...    Test objective: The objective is to test that the PUT HTTP method not implemented for escalate perceived severity
    ...    Pre-conditions: none 
    ...    Reference: Clause 7.4.4.3.3 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    Put escalate severity
    Check HTTP Response Status Code Is    405
    
PATCH Escalate the perceived severity - Method not implemented
    [Documentation]    Test ID: 6.3.4.3.4
    ...    Test title: PATCH Escalate the perceived severity - Method not implemented
    ...    Test objective: The objective is to test that the PATCH HTTP method not implemented for escalate perceived severity
    ...    Pre-conditions: none
    ...    Reference: Clause 7.4.4.3.4 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH escalate severity
    Check HTTP Response Status Code Is    405
    
DELETE Escalate the perceived severity - Method not implemented
    [Documentation]    Test ID: 6.3.4.3.5
    ...    Test title: DELETE Escalate the perceived severity - Method not implemented
    ...    Test objective: The objective is to test that the DELETE HTTP method not implemented for escalate perceived severity
    ...    Pre-conditions: none
    ...    Reference: Clause 7.4.4.3.5 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    Delete escalate severity
    Check HTTP Response Status Code Is    405
Escalate the perceived severity with permitted authorization scope
    [Documentation]    Test ID: 6.3.4.3.6
    ...    Test title: Escalate the perceived severity with permitted authorization scope
    ...    Test objective: To enable the consumer to escalate the perceived severity of an alarm that is represented by an individual alarm resource with permitted authorization scope.
    ...    Pre-conditions: The resource representing the individual alarm has been created
    ...    Reference: Clause 7.4.4.3.1 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    POST escalate severity with permitted authorization scope
    Check HTTP Response Status Code Is    204
Escalate the perceived severity with NOT permitted authorization scope
    [Documentation]    Test ID: 6.3.4.3.7
    ...    Test title: Escalate the perceived severity with NOT permitted authorization scope
    ...    Test objective: To enable the consumer to escalate the perceived severity of an alarm that is represented by an individual alarm resource with NOT permitted authorization scope.
    ...    Pre-conditions: The resource representing the individual alarm has been created
    ...    Reference: Clause 7.4.4.3.1 - ETSI GS NFV-SOL 002 [2] v5.1.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    POST escalate severity with not permitted authorization scope
    Check HTTP Response Status Code Is    403

*** Keywords ***
Check resource existence
    Set Headers    {"Accept":"${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"}  
    Set Headers    {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/alarms/${alarmId}
    Integer    response status    200
POST escalate severity
    Log    escalate the perceived severity of an alarm with the VNFM
    Set Headers    {"Accept": "${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/EscalatePerceivedSeverity.json
    ${body}=    Format String    ${template}    perceivedSeverity=${PerceivedSeverity}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/alarms/${alarmId}/escalate    ${body}  
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
	
GET escalate severity
    log    Trying to perform a GET. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/alarms/${alarmId}/escalate 
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
PUT escalate severity	
	log    Trying to perform a PUT. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion}/alarms/${alarmId}/escalate    
     ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
PATCH escalate severity
    log    Trying to perform a PATCH. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion}/alarms/${alarmId}/escalate  
     ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
DELETE escalate severity        
    log    Trying to perform a DELETE. This method should not be implemented
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion}/alarms/${alarmId}/escalate  
     ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
Check HTTP Response Status Code Is
    [Arguments]    ${expected_status}    
    Should Be Equal As Strings    ${response['status']}    ${expected_status}
    Log    Status code validated 
    
Check HTTP Response Body Json Schema Is
    [Arguments]    ${input}
    Should Contain    ${response['headers']['Content-Type']}    application/json
    ${schema} =    Catenate    SEPARATOR=    ${input}	.schema.json
    Validate Json    ${schema}    ${response['body']}
    Log    Json Schema Validation OK
JWT Encode
    [Arguments]    ${payload}    ${key}    ${algorithm}
    ${encoded}=    Evaluate    jwt.encode(${payload}, ${key}, ${algorithm})
    [Return]    ${encoded}
POST escalate severity with permitted authorization scope
    Log    escalate the perceived severity of an alarm with the VNFM with permitted authorization scope
    Set Headers    {"Accept": "${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    ${scope_value}=    Create Dictionary    scopeValue=${ESCALATE_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    ${template}=    Get File    jsons/EscalatePerceivedSeverity.json
    ${body}=    Format String    ${template}    perceivedSeverity=${PerceivedSeverity}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/alarms/${alarmId}/escalate    ${body}  
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
POST escalate severity with not permitted authorization scope
    Log    escalate the perceived severity of an alarm with the VNFM with not permitted authorization scope
    Set Headers    {"Accept": "${ACCEPT}"}
    Set Headers    {"Version": "${API_VERSION}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE}"}
    ${scope_value}=    Create Dictionary    scopeValue=${NEG_SCOPE}
    ${authorizationToken}=    JWT Encode    payload=${scope_value}    key=''    algorithm=${OAUTH_Encryption_ALGORITHM}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${authorizationToken}"}
    ${template}=    Get File    jsons/EscalatePerceivedSeverity.json
    ${body}=    Format String    ${template}    perceivedSeverity=${PerceivedSeverity}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion}/alarms/${alarmId}/escalate    ${body}  
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}