# NFV API Conformance Test Specification (NFV-TST 010)

This repository hosts the NFV API Conformance test specification for 
the APIs defined in ETSI NFV GS [SOL002](https://www.etsi.org/deliver/etsi_gs/NFV-SOL/001_099/002/05.01.01_60/gs_NFV-SOL002v050101p.pdf), 
[SOL003](https://www.etsi.org/deliver/etsi_gs/NFV-SOL/001_099/003/05.01.01_60/gs_NFV-SOL003v050101p.pdf), 
[SOL005](https://www.etsi.org/deliver/etsi_gs/NFV-SOL/001_099/005/05.01.01_60/gs_NFV-SOL005v050101p.pdf),
[SOL009](https://www.etsi.org/deliver/etsi_gs/NFV-SOL/001_099/009/05.01.01_60/gs_NFV-SOL009v050101p.pdf) in their versions v5.1.1, and 
[SOL011](https://www.etsi.org/deliver/etsi_gs/NFV-SOL/001_099/011/04.05.01_60/gs_NFV-SOL011v040501p.pdf), 
[SOL012](https://www.etsi.org/deliver/etsi_gs/NFV-SOL/001_099/012/04.05.01_60/gs_NFV-SOL012v040501p.pdf) in their versions 4.5.1.

More information and download is available at DGS/NFV-TST010ed511.

## Available versions

The NFV API Conformance test specification is available in the following versions:

| TST010 Version       | SOL Specifications                                                                      | API Conformance Tests                                                      |
|----------------------|-----------------------------------------------------------------------------------------|-----------------------------------------------------------|
| v2.4.1             | SOL002 SOL003 SOL005 v2.4.1                                                      | [v2.4.1](https://forge.etsi.org/rep/nfv/api-tests/tree/2.4.1/) |
| v2.4.1-maintenance | SOL002 SOL003 SOL005 v2.4.1                                                      | [v2.4.1-fix-plu](https://forge.etsi.org/rep/nfv/api-tests/tree/2.4.1-fix-plu/) |
| v2.6.1             | SOL002 SOL003 SOL005 v2.6.1                                                      | [v2.6.1](https://forge.etsi.org/rep/nfv/api-tests/tree/2.6.1/) |
| v2.6.1-maintenance | SOL002 SOL003 SOL005 v2.6.1                                                      | [v2.6.1-fix-plu](https://forge.etsi.org/rep/nfv/api-tests/tree/2.6.1-fix-plu/) |
| v2.7.1             | SOL002 SOL003 SOL005 v2.7.1                                                      | [v2.7.1](https://forge.etsi.org/rep/nfv/api-tests/tree/2.7.1/) |
| v2.7.1-maintenance | SOL002 SOL003 SOL005 v2.7.1                                                      | [v2.7.1-fix-plu](https://forge.etsi.org/rep/nfv/api-tests/tree/2.7.1-fix-plu/)
| v2.8.1             | SOL002 SOL003 SOL005 v2.8.1                                                      | [v2.8.1](https://forge.etsi.org/rep/nfv/api-tests/tree/2.8.1/) |
| v2.8.1-maintenance | SOL002 SOL003 SOL005 v2.8.1                                                      | [v2.8.1-fix-plu](https://forge.etsi.org/rep/nfv/api-tests/tree/2.8.1-fix-plu/)|
| v3.3.1             | SOL002 SOL003 SOL005 v3.3.1<br>SOL009 SOL011 v3.3.1<br>SOL012 v3.4.1             | [v3.3.1](https://forge.etsi.org/rep/nfv/api-tests/tree/3.3.1/) |
| v3.3.1-maintenance | SOL002 SOL003 SOL005 v3.3.1<br>SOL009 SOL011 v3.3.1<br>SOL012 v3.4.1             | [v3.3.1-fix-plu](https://forge.etsi.org/rep/nfv/api-tests/tree/3.3.1-fix-plu/) |
| v3.5.1         | SOL002 SOL003 SOL005 v3.5.1<br>SOL009 v3.5.1<br>SOL011 v3.3.1<br>SOL012 v3.4.1       | [v3.5.1](https://forge.etsi.org/rep/nfv/api-tests/tree/3.5.1/) |
| v3.5.1-maintenance | SOL002 SOL003 SOL005 v3.5.1<br>SOL009 v3.5.1<br>SOL011 v3.3.1<br>SOL012 v3.4.1   | [v3.5.1-fix-plu](https://forge.etsi.org/rep/nfv/api-tests/tree/3.5.1-fix-plu/) |
| v3.6.1         | SOL002 SOL003 SOL005 v3.6.1<br>SOL009 v3.6.1<br>SOL011 v3.3.1<br>SOL012 v3.4.1       | [v3.6.1](https://forge.etsi.org/rep/nfv/api-tests/tree/3.6.1/) |
| v3.6.1-maintenance | SOL002 SOL003 SOL005 v3.6.1<br>SOL009 v3.6.1<br>SOL011 v3.3.1<br>SOL012 v3.4.1   | [v3.6.1-fix-plu](https://forge.etsi.org/rep/nfv/api-tests/tree/3.6.1-fix-plu/) |
| v4.3.1         | SOL002 SOL003 SOL005 v4.3.1<br>SOL009               v4.3.1<br>SOL011               v3.3.1<br>SOL012               v3.4.1 | [v4.3.1](https://forge.etsi.org/rep/nfv/api-tests/tree/4.3.1/) |
| v4.3.1-maintenance | SOL002 SOL003 SOL005 v4.3.1<br>SOL009               v4.3.1<br>SOL011               v3.3.1<br>SOL012               v3.4.1 | [v4.3.1-fix-plu](https://forge.etsi.org/rep/nfv/api-tests/tree/4.3.1-fix-plu/) |
| v4.4.1         | SOL002 SOL003 SOL005 v4.4.1<br>SOL009               v4.4.1<br>SOL011               v4.4.1<br>SOL012               v4.4.1 | [v4.4.1](https://forge.etsi.org/rep/nfv/api-tests/tree/4.4.1/)|
| v4.5.1         | SOL002 SOL003 SOL005 v4.5.1<br>SOL009               v4.5.1<br>SOL011               v4.5.1<br>SOL012               v4.5.1 | [v4.5.1](https://forge.etsi.org/rep/nfv/api-tests/tree/4.5.1/)|
| v5.1.1         | SOL002 SOL003 SOL005 v5.1.1<br>SOL009               v5.1.1<br>SOL011               v4.5.1<br>SOL012               v4.5.1 | [v5.1.1](https://forge.etsi.org/rep/nfv/api-tests/tree/5.1.1/)|

## Test Specification Overview

The Test Specification is built as a collection of [Robot Framework](robotframework.org/) Test Description. [Robot Framework](robotframework.org/) is a generic test automation framework for acceptance testing and acceptance test-driven development.

More information at [NFV API Conformance Test Specification wiki](https://forge.etsi.org/rep/nfv/api-tests/wikis/NFV-API-Conformance-Test-Specification).

## How to raise issues

Please report errors, bugs or other issues [here](https://forge.etsi.org/rep/nfv/api-tests/issues).

## Test suite maintenance procedure

The Test Specification Robot code is implemented as the combination of:
- high-level Robot code, which for each test implements the sequence of test steps in the form of Robot keywords, and is reported as-is as part of the Test Documentation in the NFV-TST 010 documents 
- low-level Robot code, which implements the actual logic of the test steps in Robot language

The Test Specification is maintained according to the following procedure:
- tags in the form "x.y.z" refer to the Robot Tests aligned with related NFV-TST 010 version "x.y.z"
- branches "x.y.z-fix-plu" are used for Robot Tests maintenance for versions "x.y.z", and fix issues as reported [here](https://forge.etsi.org/rep/nfv/api-tests/issues):
    - only issues that affect the low-level Robot code are fixed in "x.y.z-fix-plu" branches
    - issues that affect the high-level Robot code (and therefore affecting the Test Documentation as per NFV-TST 010 version "x.y.z") are fixed in the first available subsequent version to "x.y.z" of the Test Specification

## How to contribute

ETSI Forge uses Gitlab to manage submissions to the repository.
For more information on setting up your environment and contributing, you may refer to the [ETSI Forge wiki](https://forge.etsi.org/wiki/index.php/Main_Page).


