*** Settings ***
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt
Library           REST    ${NFVMANO_SCHEMA}://${NFVMANO_HOST}:${NFVMANO_PORT}    ssl_verify=false
Library           OperatingSystem
Library           JSONLibrary
Resource          NFVMANOCimKeywords.robot

*** Test Cases ***
GET Individual Subscription
    [Documentation]    Test ID: 8.3.1.11.1
    ...    Test title: GET Individual  Subscription
    ...    Test objective: The objective is to test the retrieval of individual subscription and perform a JSON schema and content validation of the returned subscription data structure
    ...    Pre-conditions: At least one subscription is available in the NFV-MANO.
    ...    Reference: clause 5.5.5.3.2 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get Individual Subscription
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   CimSubscription
    Check HTTP Response Body Subscription Identifier matches the requested Subscription

GET Individual Subscription - invalid resource identifier
    [Documentation]    Test ID: 8.3.1.11.2
    ...    Test title: GET Individual Subscription - invalid resource identifier
    ...    Test objective: The objective is to test that the retrieval of an individual subscription fails when using an invalid resource identifier
    ...    Pre-conditions: At least one subscription is available in the NFV-MANO.
    ...    Reference: clause 5.5.5.3.2 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET individual Subscription with invalid resource identifier
    Check HTTP Response Status Code Is    404

DELETE Individual Subscription
    [Documentation]    Test ID: 8.3.1.11.3
    ...    Test title: DELETE Individual Subscription
    ...    Test objective: The objective is to test the deletion of an individual subscription
    ...    Pre-conditions: At least one subscription is available in the NFV-MANO.
    ...    Reference: clause 5.5.5.3.5 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: The is not available anymore in the NFV-MANO    
    Send Delete request for individual Subscription
    Check HTTP Response Status Code Is    204
    Check Postcondition Subscription is Deleted

DELETE Individual Subscription - invalid resource identifier
    [Documentation]    Test ID: 8.3.1.11.4
    ...    Test title: DELETE Individual Subscription - invalid resource identifier
    ...    Test objective: The objective is to test that the deletion of an individual  subscription fails when using an invalid resource identifier
    ...    Pre-conditions: At least one subscription is available in the NFV-MANO.
    ...    Reference: clause 5.5.5.3.5 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none   
    Send Delete request for individual Subscription with invalid resource identifier
    Check HTTP Response Status Code Is    404

POST Individual Subscription - Method not implemented
    [Documentation]    Test ID: 8.3.1.11.5
    ...    Test title: POST Individual Subscription - Method not implemented
    ...    Test objective: The objective is to test that POST method is not allowed to create a new Subscription
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.5.3.1 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: The VNF Performance Subscription is not created on the NFV-MANO
    Send Post request for individual Subscription
    Check HTTP Response Status Code Is    405
    Check Postcondition Subscription is not Created

PUT Individual Subscription - Method not implemented
    [Documentation]    Test ID: 8.3.1.11.6
    ...    Test title: PUT Individual Subscription - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not allowed to update an existing subscription
    ...    Pre-conditions: At least one subscription is available in the NFV-MANO.
    ...    Reference: clause 5.5.5.3.3 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: The subscription is not modified by the operation
    Send Put request for individual Subscription
    Check HTTP Response Status Code Is    405
    Check Postcondition Subscription is Unmodified (Implicit)

PATCH Individual Subscription - Method not implemented
    [Documentation]    Test ID: 8.3.1.11.7
    ...    Test title: PATCH Individual Subscription - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not allowed to modify an existing subscription
    ...    Pre-conditions: At least one subscription is available in the NFV-MANO.
    ...    Reference: clause 5.5.5.3.4 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: The subscription is not modified by the operation
    Send Patch request for individual Subscription
    Check HTTP Response Status Code Is    405
    Check Postcondition Subscription is Unmodified (Implicit)
