** Settings ***
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt
Library           JSONLibrary
Library           OperatingSystem
Resource          NFVMANOCimKeywords.robot
Library           REST    ${NFVMANO_SCHEMA}://${NFVMANO_HOST}:${NFVMANO_PORT}    ssl_verify=false
Library           MockServerLibrary

*** Test Cases ***
POST Individual NFV-MANO Service Interface - Method not implemented
    [Documentation]    Test ID: 8.3.1.6.1
    ...    Test title: POST Individual NFV-MANO Service Interface - Method not implemented
    ...    Test objective: The objective is to test that POST method is not implemeted.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.11.3.1 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Post request for Individual NFV-MANO Service Interface
    Check HTTP Response Status Code Is    405
    
GET Individual NFV-MANO Service Interface
    [Documentation]    Test ID: 8.3.1.6.2
    ...    Test title: GET Individual NFV-MANO Service Interface
    ...    Test objective: The objective is to query status information about an NFV-MANO service interface of the producer NFV-MANO functional entity by reading an "Individual NFV-MANO service interface" resource.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.11.3.2 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions:  none
    Get Individual NFV-MANO Service Interface
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    ManoServiceInterface
    
PUT Individual NFV-MANO Service Interface - Method not implemented
    [Documentation]    Test ID: 8.3.1.6.3
    ...    Test title: PUT Individual NFV-MANO Service Interface - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not implemeted.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.11.3.3 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Put request for Individual NFV-MANO Service Interface
    Check HTTP Response Status Code Is    405
    
PATCH Individual NFV-MANO Service Interface
    [Documentation]    Test ID: 8.3.1.6.4
    ...    Test title: PATCH Individual NFV-MANO Service Interface
    ...    Test objective: This method modifies the Individual NFV-MANO Service Interface resource
    ...    Pre-conditions: Individual NFV-MANO Service Interface resource is already created.
    ...    Reference: clause 5.5.11.3.4 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: The Individual NFV-MANO Service Interface is modified by the operation
    Send Patch request for Individual NFV-MANO Service Interface
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   ManoServiceInterfaceModifications
    
PATCH Individual NFV-MANO Service Interface - Conflict
    [Documentation]    Test ID: 8.3.1.6.5
    ...    Test title: PATCH Individual NFV-MANO Service Interface - Conflict
    ...    Test objective: The objective is to test that the modification of the Individual NFV-MANO Service Interface resource failed due to a conflict with the state of the Individual NFV-MANO Service Interface resource and perform the JSON schema validation of the failed operation HTTP response.
    ...    Pre-conditions: Individual NFV-MANO Service Interface resource is already created.
    ...    Reference: clause 5.5.11.3.4 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: The Individual NFV-MANO Service Interface is not modified by the operation
    Send Patch request for Individual NFV-MANO Service Interface
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is   ProblemDetails
    
PATCH Individual NFV-MANO Service Interface - PreCondition Failed
    [Documentation]    Test ID: 8.3.1.6.6
    ...    Test title: PATCH Individual NFV-MANO Service Interface - PreCondition Failed
    ...    Test objective: The objective is to test that the modification of the Individual NFV-MANO Service Interface resource failed because precondition given in an HTTP request header is not fulfilled and perform the JSON schema validation of the failed operation HTTP response.
    ...    Pre-conditions: Individual NFV-MANO Service Interface resource is already created.
    ...    Reference: clause 5.5.11.3.4 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: The Individual NFV-MANO Service Interface is not modified by the operation
    Send Patch request for Individual NFV-MANO Service Interface
    Check HTTP Response Status Code Is    412
    Check HTTP Response Body Json Schema Is   ProblemDetails
    
DELETE Individual NFV-MANO Service Interface - Method not implemented
    [Documentation]    Test ID: 8.3.1.6.7
    ...    Test title: DELETE Individual NFV-MANO Service Interface - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not implemeted.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.11.3.5 - ETSI GS NFV-SOL 009 [5] V3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Delete request for Individual NFV-MANO Service Interface
    Check HTTP Response Status Code Is    405