*** Settings ***
Resource    FaultManagement-APIKeyword.robot

*** Test Cases ***
POST Individual Alarm - Method not implemented
     [Documentation]    Test ID: 8.3.3.2.1
    ...    Test title: POST Individual Alarm - Method not implemented
    ...    Test objective: The objective is to test that Post method is not allowed to create fault management individual alarm on NFV-MANO 
    ...    Pre-conditions: none
    ...    Reference: clause 7.5.4.3.1 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none  
    Send POST request for fault management Individual Alarm
    Check HTTP Response Status Code Is    405   

Get information about an fault management individual alarm
    [Documentation]    Test ID: 8.3.3.2.2
    ...    Test title: Get information about an fault management individual alarm
    ...    Test objective: The objective is to retrieve information about an individual alarm and perform a JSON schema and content validation of the returned alarm data structure
    ...    Pre-conditions: The related alarm exists
    ...    Reference: clause 7.5.4.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions:  none 
    GET Fault Management Individual Alarm
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    alarm
    
Get information about an fault management individual alarm - Not Found
    [Documentation]    Test ID: 8.3.3.2.3
    ...    Test title: Get information about an fault management individual alarm
    ...    Test objective: The objective is to test the retrieval of information about an individual alarm fails when the resource is not present.
    ...    Pre-conditions: none
    ...    Reference: clause 7.5.4.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Fault Management Individual Alarm
    Check HTTP Response Status Code Is    404
    Check HTTP Response Body Json Schema Is    ProblemDetails

PUT Individual Alarm - Method not implemented
    [Documentation]    Test ID: 8.3.3.2.4
    ...    Test title: PUT Individual Alarm - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not allowed to for fault management individual alarm on NFV-MANO 
    ...    Pre-conditions: none
    ...    Reference: clause 7.5.4.3.3 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions:  none 
    PUT Fault Management Individual Alarm
    Check HTTP Response Status Code Is    405

PATCH Fault Management Individual Alarm
    [Documentation]    Test ID: 8.3.3.2.5
    ...    Test title: PATCH Fault Management Individual Alarm
    ...    Test objective: The objective is to Modify an individual alarm resource, and perform a JSON schema validation of the returned alarm data structure.
    ...    Pre-conditions: The related alarm exists
    ...    Reference: clause 7.5.4.3.4 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: Alarm is modified.
    PATCH Fault Management Individual Alarm
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is  AlarmModification

Modify an individual alarm resource - Precondition failed
    [Documentation]    Test ID: 8.3.3.2.6
    ...    Test title: Modify an individual alarm resource - Precondition failed
    ...    Test objective: The objective is to test that an individual alarm resource cannot be modified if the alarm is already in the state that is requested to be set, and perform a JSON schema validation of the returned data structure.
    ...    Pre-conditions: The related alarm exists
    ...    Reference: clause 7.5.4.3.4 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: Alarm is not modified.
    PATCH Fault Management Individual Alarm - precondition failed
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is  ProblemDetails
    Check Postcondition fault management individual alarm exists  

Modify an individual alarm resource - Conflict
    [Documentation]    Test ID: 8.3.3.2.7
    ...    Test title: Modify an individual alarm resource - Conflict
    ...    Test objective: The objective is to test that an individual alarm resource cannot be modified if the resource was modified by another entity , and perform a JSON schema validation of the returned data structure.
    ...    Pre-conditions: The related alarm exists
    ...    Reference: clause 7.5.4.3.4 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: Alarm is not modified.
    PATCH Fault Management Individual Alarm Conflict
    Check HTTP Response Status Code Is    412
    Check HTTP Response Body Json Schema Is     ProblemDetails
    Check Postcondition fault management individual alarm exists

DELETE Individual Alarm - Method not implemented
     [Documentation]    Test ID: 8.3.3.2.8
    ...    Test title: DELETE Individual Alarm - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not allowed to delete fault management individual alarm on NFV-MANO.
    ...    Pre-conditions: none
    ...    Reference: clause 7.5.4.3.5 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    DELETE Fault Management Individual Alarm
    Check HTTP Response Status Code Is    405