*** Settings ***
Documentation     This Clause defines all the resources and methods provided by the NS LCM coordination interface.
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt    # Generic Parameters
Resource          NSLCMCoordKeywords.robot
Library           JSONLibrary
Library           REST    ${NFVO_SCHEMA}://${NFVO_HOST}:${NFVO_PORT}    ssl_verify=false
Library           OperatingSystem

*** Test Cases ***
Request a Coordination of an LCM operation occurrence synchronously 
    [Documentation]    Test ID: 5.3.8.2.1
    ...    Test title:  Request a Coordination of an LCM operation occurrence synchronously
    ...    Test objective: The objective is to test the synchronous request for the coordination of an LCM operation occurrence and perform the JSON schema validation of the returned structure
    ...    Pre-conditions: The status of the related LCM opeation occurrence is "PROCESSING"
    ...    Reference: Clause 12.4.2.3.1 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_OSS/BSS
    ...    Applicability: none
    ...    Post-Conditions: A Individual coordination action resource is successfully created on the NFVO
    Send Post Request for coordination of an LCM operation occurrence
    Check HTTP Response Status Code Is    201
    Check HTTP Response Header Contains    Location
    Check HTTP Response Body Json Schema Is   LcmCoord
    Check Postcondition LcmCoord Exists


Request a Coordination of an LCM operation occurrence asynchronously 
    [Documentation]    Test ID: 5.3.8.2.2
    ...    Test title:  Request a Coordination of an LCM operation occurrence asynchronously
    ...    Test objective: The objective is to test the asynchronous request for the coordination of an LCM operation occurrence and perform the validation of the headers returned
    ...    Pre-conditions: The status of the related LCM opeation occurrence is "PROCESSING"
    ...    Reference: Clause 12.4.2.3.1 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_OSS/BSS
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Post Request for coordination of an LCM operation occurrence 
    Check HTTP Response Status Code Is    202
    Check HTTP Response Header Contains    Location

Request a Coordination of an LCM operation occurrence - FORBIDDEN
    [Documentation]    Test ID: 5.3.8.2.3
    ...    Test title:  Request a Coordination of an LCM operation occurrence - FORBIDDEN
    ...    Test objective: The objective is to test the failure of a request for the coordination of an LCM operation occurrence
    ...    Pre-conditions: The status of the related LCM opeation occurrence is "PROCESSING". The request is performed by a user that has not the grant to run this operation
    ...    Reference: Clause 12.4.2.3.1 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_OSS/BSS
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Post Request for coordination of an LCM operation occurrence - forbidden
    Check HTTP Response Status Code Is    403
    Check HTTP Response Body Json Schema Is    ProblemDetails
    
Request a Coordination of an LCM operation occurrence - CONFLICT
    [Documentation]    Test ID: 5.3.8.2.3
    ...    Test title:  Request a Coordination of an LCM operation occurrence - CONFLICT
    ...    Test objective: The objective is to test the failure of a request for the coordination of an LCM operation occurrence
    ...    Pre-conditions: The status of the related LCM opeation occurrence is not "PROCESSING"
    ...    Reference: Clause 12.4.2.3.1 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_OSS/BSS
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Post Request for coordination of an LCM operation occurrence - conflict
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is    ProblemDetails
    

Request a Coordination of an LCM operation occurrence synchronously - Service Unavailable
    [Documentation]    Test ID: 5.3.8.2.4
    ...    Test title:  Request a Coordination of an LCM operation occurrence synchronously - Service Unavailable
    ...    Test objective: The objective is to test the request for the coordination of an LCM operation occurrence and the verify that the NFVO cannot perform immediately the request, but can perform it sometime in the future.
    ...    Pre-conditions: The status of the related LCM opeation occurrence is "PROCESSING" but API producer cannot perform immediately the request
    ...    Reference: Clause 12.4.2.3.1 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_OSS/BSS
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Post Request for coordination of an LCM operation occurrence synchronously - service unavailable
    Check HTTP Response Status Code Is    503
    Check HTTP Response Header Contains    Retry-After
    

Request a Coordination of an LCM operation occurrence without authentication
    [Documentation]    Test ID: 5.3.8.2.5
    ...    Test title:  Request a Coordination of an LCM operation occurrence without authentication
    ...    Test objective: The objective is to test the failure of the request for the coordination of an LCM operation occurrence without providing an authentication token
    ...    Pre-conditions: The status of the related LCM opeation occurrence is "PROCESSING"
    ...    Reference: Clause 12.4.2.3.1 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_OSS/BSS
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Post Request for coordination of an LCM operation occurrence without authorization token
    Check HTTP Response Status Code Is    401
    

GET all Coordinations of an LCM operation occurrence - method not implemented
    [Documentation]    Test ID: 5.3.8.2.6
    ...    Test title: GET all Coordinations of an LCM operation occurrence - method not implemented
    ...    Test objective: The objective is to test that the GET method is not allowed to retrieve coordination requests information
    ...    Pre-conditions: The status of the related LCM opeation occurrence is "PROCESSING"
    ...    Reference: Clause 12.4.2.3.2 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_OSS/BSS
    ...    Applicability: none
    ...    Post-Conditions: none
    GET all Coordinations of an LCM operation occurrence
    Check HTTP Response Status Code Is    405


PUT all Coordinations of an LCM operation occurrence - method not implemented
    [Documentation]    Test ID: 5.3.8.2.7
    ...    Test title: PUT all Coordinations of an LCM operation occurrence - method not implemented
    ...    Test objective: The objective is to test that the PUT method is not allowed to modify coordination requests information
    ...    Pre-conditions: The status of the related LCM opeation occurrence is "PROCESSING"
    ...    Reference: Clause 12.4.2.3.3 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_OSS/BSS
    ...    Applicability: none
    ...    Post-Conditions: none
    PUT all Coordinations of an LCM operation occurrence
    Check HTTP Response Status Code Is    405


PATCH all Coordinations of an LCM operation occurrence - method not implemented
    [Documentation]    Test ID: 5.3.8.2.8
    ...    Test title: PATCH all Coordinations of an LCM operation occurrence - method not implemented
    ...    Test objective: The objective is to test that the PATCH method is not allowed to modify coordination requests information
    ...    Pre-conditions: The status of the related LCM opeation occurrence is "PROCESSING"
    ...    Reference: Clause 12.4.2.3.4 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_OSS/BSS
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH all Coordinations of an LCM operation occurrence
    Check HTTP Response Status Code Is    405


DELETE all Coordinations of an LCM operation occurrence - method not implemented
    [Documentation]    Test ID: 5.3.8.2.9
    ...    Test title: DELETE all Coordinations of an LCM operation occurrence - method not implemented
    ...    Test objective: The objective is to test that the DELETE method is not allowed to remove coordination requests information
    ...    Pre-conditions: The status of the related LCM opeation occurrence is "PROCESSING"
    ...    Reference: Clause 12.4.2.3.5 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_OSS/BSS
    ...    Applicability: none
    ...    Post-Conditions: none
    DELETE all Coordinations of an LCM operation occurrence
    Check HTTP Response Status Code Is    405