*** Settings ***
Resource   environment/variables.txt 
Resource   PolicyManagementKeywords.robot  

*** Test Cases ***
POST Individual Subscription - Method not implemented
    [Documentation]    Test ID: 10.3.1.7.1
    ...    Test title: POST Individual Subscription - Method not implemented
    ...    Test objective: The objective is to test that POST method is not implemented for this resource.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.8.3.1 - ETSI GS NFV-SOL 012 [7] v3.4.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    POST Individual Subscription
    Check HTTP Response Status Code Is    405

GET Information about an individual subscription - Successful
     [Documentation]    Test ID: 10.3.1.7.2
    ...    Test title: GET Information about an individual subscription - Successful
    ...    Test objective: The objective is to test the retrieval of Policy Management subscription and perform a JSON schema validation of the returned PolicySubscription data structure
    ...    Pre-conditions: At least one policy management subscription is available in the NFV-MANO.
    ...    Reference: Clause 5.5.8.3.2 - ETSI GS NFV-SOL 012 [7] v3.4.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Individual subscription
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   PolicySubscription
    
GET Information about an individual subscription - NOT FOUND
     [Documentation]    Test ID: 10.3.1.7.3
    ...    Test title: GET Information about an individual subscription - NOT FOUND
    ...    Test objective: The objective is to test that the retrieval of individual Policy Management subscription fails when using an invalid resource identifier.
    ...    Pre-conditions: At least one Policy Management subscription is available in the NFV-MANO.
    ...    Reference: Clause 5.5.8.3.2 - ETSI GS NFV-SOL 012 [7] v3.4.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Individual subscription with Invalid URI
    Check HTTP Response Status Code Is    404
    Check HTTP Response Body Json Schema Is   ProblemDetails

PUT an individual subscription - Method not implemented
     [Documentation]    Test ID: 10.3.1.7.4
    ...    Test title: PUT an individual subscription - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not implemented for this resource.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.8.3.3 - ETSI GS NFV-SOL 012 [7] v3.4.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    PUT Individual Subscription
    Check HTTP Response Status Code Is    405

PATCH an individual subscription - Method not implemented
     [Documentation]    Test ID: 10.3.1.7.5
    ...    Test title: PATCH an individual subscription - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not implemented for this resource.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.5.8.3.4 - ETSI GS NFV-SOL 012 [7] v3.4.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH Individual Subscription
    Check HTTP Response Status Code Is    405
    
DELETE an individual subscription
     [Documentation]    Test ID: 10.3.1.7.6
    ...    Test title: DELETE an individual subscription
    ...    Test objective: The objective is to test that DELETE method deletes an individual subscription
    ...    Pre-conditions: At least one policy management subscription is available in the NFV-MANO.
    ...    Reference: Clause 5.5.8.3.5 - ETSI GS NFV-SOL 012 [7] v3.4.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: The Policy Management subscription is no longer available in the NFV-MANO.
    DELETE Individual Subscription
    Check HTTP Response Status Code Is    204
    Check Postcondition Individual Subscription is Deleted