*** Setting ***
Resource    environment/variables.txt
Suite Setup    Create Sessions
Suite Teardown    Terminate All Processes    kill=true
Library    MockServerLibrary
Library    Process
Library    OperatingSystem
Library    BuiltIn
Library    Collections
Library    String


*** Test Cases ***
Information Changed Notification
    [Documentation]    Test ID: 8.3.1.12.1
    ...    Test title: Information Changed Notification
    ...    Test objective: The objective is to test the dispatch of Information Changed Notification when configuration or information is changed in the NFV-MANO, and perform a JSON schema and content validation of the delivered notification. The action that triggers the notification under test is an explicit test step, but it is not performed by the test system.
    ...    Pre-conditions: A subscription for information availability notifications is available in the NFV-MANO.
    ...    Reference: clause 5.5.6.3.1 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none 
    Trigger the availability of Information Changed Notification (external action) 
    Check Information Changed Notification Available Http POST Request Body Json Schema Is    InformationChangedNotification
    Check Information Changed Notification Available Http POST Request Body notificationType attribute Is    InformationChangedNotification

Change State Notification
    [Documentation]    Test ID: 8.3.1.12.2
    ...    Test title: Change State Notification
    ...    Test objective: The objective is to test the dispatch of Change State Notification when state changes of the NFV-MANO functional entity and its managed objects, and perform a JSON schema and content validation of the delivered notification. The action that triggers the notification under test is an explicit test step, but it is not performed by the test system.
    ...    Pre-conditions: A performance job is created, and a state change subscription is available in the NFV-MANO.
    ...    Reference: clause 5.5.6.3.1 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANOz
    ...    Applicability: none
    ...    Post-Conditions: none 
    Trigger the cross of Change State (external action) 
    Check Change State Notification Http POST Request Body Json Schema Is    ChangeStateNotification
    Check Change State Notification Http POST Request Body notificationType attribute Is    ChangeStateNotification


*** Keywords ***
Trigger the availability of Information Changed Notification (external action) 
    #do nothing
    Log    do nothing

Trigger the cross of Change State (external action) 
    #do nothing
    Log    do nothing   
  
Check Information Changed Notification Available Http POST Request Body Json Schema Is    
    [Arguments]    ${element}
    ${schema}=  Get File    schemas/${element}.schema.json
    Configure Notification Forward    ${schema}    ${callback_endpoint}    ${callback_endpoint_fwd}

Check Information Changed Notification Available Http POST Request Body notificationType attribute Is
    [Arguments]    ${type}
    Configure Notification Information Changed Notification Available Handler    ${callback_endpoint_fwd}    ${type}
    Wait Until Keyword Succeeds    2 min   10 sec   Verify Mock Expectation    ${notification_request}
    Clear Requests    ${callback_endpoint}
    Clear Requests    ${callback_endpoint_fwd}

Check Change State Notification Http POST Request Body Json Schema Is    
    [Arguments]    ${element}
    ${schema}=  Get File    schemas/${element}.schema.json
    Configure Notification Forward    ${schema}    ${callback_endpoint}    ${callback_endpoint_fwd}
    

Check Change State Notification Http POST Request Body notificationType attribute Is
    [Arguments]    ${type}
    Configure Notification State Crossed Handler    ${callback_endpoint_fwd}    ${type}
    Wait Until Keyword Succeeds    2 min   10 sec   Verify Mock Expectation    ${notification_request}
    Clear Requests    ${callback_endpoint}
    Clear Requests    ${callback_endpoint_fwd}
    
    
Check Change State Notification Http POST Request Body changeType attribute Is
    [Arguments]    ${type}
    #do nothing
    Log    do nothing 
    
    
Configure Notification Information Changed Notification Available Handler
    [Arguments]    ${endpoint}    ${type}
    ${json}=    evaluate    {}
    set to dictionary    ${json}    notificationType    ${type}    
    ${BODY}=    evaluate    json.dumps(${json})    json
    Log  Creating mock request and response to handle status notification
    &{req}=  Create Mock Request Matcher    POST  ${endpoint}  body_type="JSON"    body=${BODY}
    Set Global Variable    ${notification_request}    ${req}   
    &{notification_response}=  Create Mock Response    status_code=204
    Create Mock Expectation  ${notification_request}  ${notification_response}

Configure Notification State Crossed Handler
    [Arguments]    ${endpoint}    ${type}
    ${json}=    evaluate    {}
    set to dictionary   ${json}    notificationType    ${type}
    ${BODY}=    evaluate    json.dumps(${json})    json
    Log  Creating mock request and response to handle status notification
    &{req}=  Create Mock Request Matcher    POST  ${endpoint}  body_type="JSON"    body=${BODY}
    Set Global Variable    ${notification_request}    ${req}   
    &{notification_response}=  Create Mock Response    status_code=204
    Create Mock Expectation  ${notification_request}  ${notification_response}
  
Configure Notification Forward
    [Arguments]    ${schema}    ${endpoint}    ${endpoint_fwd}    
    Log  Creating mock Http POST forward to handle ${schema}
    &{notification_tmp}=  Create Mock Request Matcher   POST  ${endpoint}  body_type="JSON_SCHEMA"    body=${schema}
    &{notification_fwd}=  Create Mock Http Forward  ${endpoint_fwd}
    Create Mock Expectation With Http Forward  ${notification_tmp}  ${notification_fwd}

Create Sessions
    Start Process  java  -jar  ${MOCK_SERVER_JAR}  -serverPort  ${callback_port}  alias=mockInstance
    Wait For Process  handle=mockInstance  timeout=5s  on_timeout=continue
    Create Mock Session  ${callback_uri}:${callback_port}
