*** Settings ***
Library     String
Library     JSONSchemaLibrary    schemas/
Resource    environment/variables.txt
Library     DependencyLibrary
Library     JSONLibrary
Library     OperatingSystem
Library     REST    ${NFVMANO_SCHEMA}://${NFVMANO_HOST}:${NFVMANO_PORT}    ssl_verify=false
Library     MockServerLibrary
Library     Process
Library     BuiltIn
Library     Collections


*** Keywords ***
GET all NFV-MANO Performance Monitoring Jobs
    Log    Trying to get all PM Jobs present in the NFV-MANO
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
GET Performance Monitoring Jobs with malformed authorization token
    Pass Execution If    ${AUTH_USAGE} == 0    Skipping test as NFVO is not supporting authentication
    Log    The GET method queries using invalid token
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"${AUTHORIZATION_HEADER}": "${BAD_AUTHORIZATION}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

GET Performance Monitoring Jobs without authorization token
    Pass Execution If    ${AUTH_USAGE} == 0    Skipping test as it is not supporting authentication
    Log    The GET method queries omitting token
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

GET Performance Monitoring Jobs with expired or revoked authorization token
    Pass Execution If    ${AUTH_USAGE} == 0    Skipping test as it is not supporting authentication
    Log    The GET method queries  using invalid token
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"${AUTHORIZATION_HEADER}": "${NEG_AUTHORIZATION_TOKEN}"}
    Log    Execute Query and validate response
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
GET NFV-MANO Performance Monitoring Jobs with attribute-based filter
    Log    Trying to get all PM Jobs present in the NFV-MANO, using filter params
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs?${POS_FILTER}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

GET NFV-MANO Performance Monitoring Jobs with all_fields attribute selector
    Log    Trying to get all PM Jobs present in the NFV-MANO, using 'all_fields' filter
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs?all_fields
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

GET NFV-MANO Performance Monitoring Jobs with exclude_default attribute selector
    Log    Trying to get all NFV-MANO Packages present in the NFV-MANO, using filter params
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs?exclude_default
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

GET NFV-MANO Performance Monitoring Jobs with fields attribute selector
    Log    Trying to get all NFV-MANO Packages present in the NFV-MANO, using filter params
    Pass Execution If    ${FIELD_USAGE} == 0    Skipping test as NFV-MANO is not supporting 'fields'
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs?fields=${fields}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
GET NFV-MANO Performance Monitoring Jobs with fields and exclude_default attribute selector
    Log    Trying to get all NFV-MANO Packages present in the NFV-MANO, using filter params
    Pass Execution If    ${FIELD_USAGE} == 0    Skipping test as NFV-MANO is not supporting 'fields'
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs?exclude_default&fields=${fields}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

GET NFV-MANO Performance Monitoring Jobs with exclude_fields attribute selector
    Log    Trying to get all NFV-MANO Packages present in the NFV-MANO, using filter params
    Pass Execution If    ${FIELD_USAGE} == 0    Skipping test as NFV-MANO is not supporting 'fields'
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs?fields=${fields}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

GET NFV-MANO Performance Monitoring Jobs with invalid attribute-based filter
    Log    Trying to get all PM Jobs present in the NFV-MANO, using an erroneous filter param
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs?${NEG_FILTER}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

GET NFV-MANO Performance Monitoring Jobs with invalid attribute selector	
    Log    Query VNF The GET method queries information about multiple VNF instances.
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"} 
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/vnf_instances?fields=wrong_field
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

Send Post Request to create new NFV-MANO Performance Monitoring Job
    Log    Creating a new PM Job
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/CreatePmJobRequest.json
    ${body}=        Format String   ${template}     objectInstanceIds=${objectInstanceIds}    callbackUri=${callback_uri}
    Check GET response from Notification Endpoint
    POST    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs    ${body}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Post Request to create new NFV-MANO Performance Monitoring Job - Unreachable Endpoint
    Log    Creating a new PM Job for unreachable notification endpoint
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/CreatePmJobRequest.json
    ${body}=        Format String   ${template}     objectInstanceIds=${objectInstanceIds}    callbackUri=${callback_uri}
    Check GET response from Unreachable Notification Endpoint
    POST    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs    ${body}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send PUT Request for all NFV-MANO Performance Monitoring Jobs 
    Log    Trying to perform a PUT. This method should not be implemented
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    PUT    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send PATCH Request for all NFV-MANO Performance Monitoring Jobs 
    Log    Trying to perform a PUT. This method should not be implemented
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    PATCH    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send DELETE Request for all NFV-MANO Performance Monitoring Jobs 
    Log    Trying to perform a PUT. This method should not be implemented
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    PATCH    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Check Postcondition PmJob Exists
    Log    Checking that Pm Job exists
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${response['body']['id']}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    PmJob
 
Check GET response from Notification Endpoint
    Log  Creating mock request and response to handle GET operation on notification endpoint
    &{notification_request}=  Create Mock Request Matcher	GET  ${callback_uri}
    &{notification_response}=  Create Mock Response	status_code=204
    Log    Issue the subscription request
    Create Mock Expectation  ${notification_request}  ${notification_response}
    Wait Until Keyword Succeeds    ${total_polling_time}   ${polling_interval}   Verify Mock Expectation    ${notification_request}
    Clear Requests  ${callback_uri}

Check GET response from Unreachable Notification Endpoint
    Log    Creating mock request and response to handle GET operation on unreachable notification endpoint
    &{notification_request}=    Create Mock Request Matcher    GET    ${unreachable_callback_uri}
    &{notification_response}=    Create Mock Response    status_code=404
    Log    Issue the subscription request
    Create Mock Expectation    ${notification_request}    ${notification_response}
    Wait Until Keyword Succeeds    ${total_polling_time}   ${polling_interval}   Verify Mock Expectation    ${notification_request}
    Clear Requests  ${unreachable_callback_uri}

Check HTTP Response Status Code Is
    [Arguments]    ${expected_status}
    ${status}=    Convert To Integer    ${expected_status}    
    Should Be Equal    ${response['status']}    ${status} 
    Log    Status code validated

Check HTTP Response Header Contains
    [Arguments]    ${CONTENT_TYPE}
    Should Contain    ${response['headers']}    ${CONTENT_TYPE}
    Log    Header is present
    
Check HTTP Response Body Json Schema Is
    [Arguments]    ${input}
    Run Keyword If    '${input}' == 'ProblemDetails'    Should Contain    ${response['headers']['Content-Type']}    application/problem+json
    ...    ELSE    Should Contain    ${response['headers']['Content-Type']}    application/json
    ${schema} =    Catenate    SEPARATOR=    ${input}    .schema.json
    Validate Json    ${schema}    ${response['body']}
    Log    Json Schema Validation OK
    
Check HTTP Response Header Contains Link
    ${linkURL}=    Get Value From Json    ${response['headers']}    $..Link
    Should Not Be Empty    ${linkURL}

GET individual NFV-MANO Performance Job
    Log    Trying to get a Pm Job 
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

GET individual NFV-MANO Performance Job with invalid resource identifier  
    Log    Trying to perform a negative get, using erroneous PM Job identifier
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${erroneousPmJobId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Delete request for individual NFV-MANO Performance Job
    Log    Trying to delete an existing PM Job
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    DELETE    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send Delete request for individual NFV-MANO Performance Job with invalid resource identifier
    Log    Trying to perform a negative delete, using erroneous PM Job identifier
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    DELETE    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${erroneousPmJobId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Post request for individual NFV-MANO Performance Job    
    Log    Trying to perform a POST (method should not be implemented)
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    POST    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${newPmJobId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send Put request for individual NFV-MANO Performance Job    
    Log    Trying to perform a POST (method should not be implemented)
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}
    ${origOutput}=    Output    response
    Set Suite Variable    ${origResponse}    ${origOutput}
    PUT    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send Patch request for individual NFV-MANO Performance Job    
    Log    Trying to perform a PATCH on PM Job
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE_PATCH}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    Check GET response from Notification Endpoint
    ${template}=    Get File    jsons/PmJobModifications.json
    ${body}=    Format String    ${template}    callbackUri=${callback_uri}
    PATCH    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}    ${body}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Patch request for individual NFV-MANO Performance Job - Etag mismatch
    Log    Trying to perform a PATCH on PM Job
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE_PATCH}"}
    Set Headers    {"If-Match": "${invalid_etag}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    Check GET response from Notification Endpoint
    ${template}=    Get File    jsons/PmJobModifications.json
    ${body}=    Format String    ${template}    callbackUri=${callback_uri}
    PATCH    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}    ${body}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Patch request for individual NFV_MANO Performance Job with unprocessable entity
    Set Headers  {"Accept":"${ACCEPT_JSON}"} 
    Set Headers  {"Content-Type": "${CONTENT_TYPE_PATCH}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template}=    Get File    jsons/PmJobModifications.json
    ${body}=        Format String   ${template}    callbackUri=${unreachable_callback_uri}:${callback_port}
    PATCH    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}     ${body}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Check Postcondition NFV-MANO Pm Job is Deleted
    Log    Check Postcondition
    GET individual NFV-MANO Performance Job
    Check HTTP Response Status Code Is    404

Check HTTP Response Body Pm Job Identifier matches the requested Pm Job
    Log    Going to validate Pm Job info retrieved
    Should Be Equal    ${response['body']['id']}    ${pmJobId} 
    Log    Pm Job identifier as expected

GET all Performance Thresholds
    Log    Trying to get all thresholds present in the NFV-MANO    
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

GET Performance Thresholds with attribute-based filter
    Log    Trying to get thresholds present in the NFV-MANO with filter
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds?${FILTER_OK}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

GET Performance Thresholds with invalid attribute-based filter
    Log    Trying to get thresholds present in the NFV-MANO with invalid filter
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds?${FILTER_KO}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Post Request Create new Performance Threshold
    Log    Creating a new Threshold
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    ${template}=    Get File    jsons/CreateThresholdRequest.json
    ${body}=        Format String   ${template}     objectInstanceIds=${objectInstanceIds}    callbackUri=${callback_uri}
    POST    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds    ${body}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Post Request Create new Performance Threshold with unreachable notification endpoint
    Log    Creating a new Threshold
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Check GET response from Unreachable Notification Endpoint
    ${template}=    Get File    jsons/CreateThresholdRequest.json
    ${body}=        Format String   ${template}     objectInstanceIds=${objectInstanceIds}    callbackUri=${callback_uri}
    POST    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds    ${body}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send PUT Request for all Performance Thresholds
    Log    PUT THresholds
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    PUT    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send PATCH Request for all Performance Thresholds
    Log    PUT THresholds
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE_JSON}"}
    PATCH    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send DELETE Request for all Performance Thresholds
    Log    DELETE THresholds
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    DELETE    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Check Postcondition Threshold Exists
    Log    Checking that Threshold exists
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds/${response['body']['id']}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    Threshold
        
Check HTTP Response Body Thresholds match the requested attribute-based filter
    Log    Checking that attribute-based filter is matched
    @{words}=    Split String    ${FILTER_OK}       ,${SEPERATOR}
    Should Be Equal As Strings    ${response['body'][0]['objectInstanceId']}    @{words}[1]

GET Individual Performance Threshold
    Log    Trying to get a Threhsold present in the NFV-MANO
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds/${thresholdId}
    ${output}=    Output    response
    Set Suite Variable    @{response}    ${output}

GET individual Performance Threshold with invalid resource identifier
    Log    Trying to get a Threhsold with invalid resource endpoint
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds/${erroneousThresholdId}
    ${output}=    Output    response
    Set Suite Variable    @{response}    ${output}

Send Delete request for individual Performance Threshold
    Log    Trying to delete a Threhsold in the NFV-MANO
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    DELETE    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds/${thresholdId}
    ${output}=    Output    response
    Set Suite Variable    @{response}    ${output}

Send Delete request for individual Performance Threshold with invalid resource identifier
    Log    Trying to delete a Threhsold in the NFV-MANO with invalid id
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    DELETE    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds/${erroneousThresholdId}
    ${output}=    Output    response
    Set Suite Variable    @{response}    ${output}

Send Post request for individual Performance Threshold
    Log    Trying to create new threshold
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    POST    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds/${newThresholdId}
    ${output}=    Output    response
    Set Suite Variable    @{response}    ${output}

Send Put request for individual Performance Threshold
    Log    Trying to PUT threshold
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds/${thresholdId}
    ${origOutput}=    Output    response
    Set Suite Variable    ${origResponse}    ${origOutput}
    PUT    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds/${thresholdId}
    ${output}=    Output    response
    Set Suite Variable    @{response}    ${output}

Send Patch request for individual Performance Threshold
    Log    Trying to PUT threshold
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE_PATCH}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    Check GET response from Notification Endpoint
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds/${thresholdId}
    ${origOutput}=    Output    response
    Set Suite Variable    ${origResponse}    ${origOutput}
    ${template}=    Get File    jsons/ThresholdModification.json
    ${body}=    Format String    ${template}    callbackUri=${callback_uri}
    PATCH    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds/${thresholdId}    ${body}
    ${output}=    Output    response
    Set Suite Variable    @{response}    ${output}

Send Patch request for individual Performance Threshold - Etag mismatch
    Log    Trying to PUT threshold
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE_PATCH}"}
    Set Headers    {"If-Match": "${invalid_etag}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    Check GET response from Notification Endpoint
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds/${thresholdId}
    ${origOutput}=    Output    response
    Set Suite Variable    ${origResponse}    ${origOutput}
    ${template}=    Get File    jsons/ThresholdModification.json
    ${body}=    Format String    ${template}    callbackUri=${callback_uri}
    PATCH    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds/${thresholdId}    ${body}
    ${output}=    Output    response
    Set Suite Variable    @{response}    ${output}

Send Patch request for individual Performance Threshold with unprocessable entity
    Log    Trying to PUT threshold
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Set Headers    {"Content-Type": "${CONTENT_TYPE_PATCH}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds/${thresholdId}
    ${origOutput}=    Output    response
    Set Suite Variable    ${origResponse}    ${origOutput}
    ${template}=    Get File    jsons/ThresholdModification.json
    ${body}=    Format String    ${template}    callbackUri=${unreachable_callback_uri}
    PATCH    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds/${thresholdId}    ${body}
    ${output}=    Output    response
    Set Suite Variable    @{response}    ${output}

Check Postcondition Performance Threshold is Deleted
    Log    Check Postcondition Threshold is deleted
    GET individual Performance Threshold
    Check HTTP Response Status Code Is    404
    
Check HTTP Response Body Threshold Identifier matches the requested Threshold
    Log    Trying to check response ID
    Should Be Equal    ${response['body']['id']}    ${thresholdId} 
    Log    Pm Job identifier as expected

Check PM Job resource existence and get CallbackUri
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}
    Integer    response status    200
    Validate Json    response body    PmJob.schema.json
    Set Global Variable    ${callbackResp}    response body callbackUri

POST Performance Information Available Notification
    Log    Trying to perform a POST to get notification
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template} =    Get File    jsons/PerformanceInformationAvailabilityNotification.json
    ${body}=    Format String    ${template}    pmJobId=${pmJobId}    objectInstanceId=${objectInstanceIds}    
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

Check Threshold resource existence and get CallbackUri
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/thresholds/${thresholdId}
    Integer    response status    200
    Validate Json    response body    Threshold.schema.json
    Set Global Variable    ${callbackResp}    response body callbackUri

POST Threshold Crossed Notification
    Log    Trying to perform a POST to get notification
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    ${template} =    Get File    jsons/ThresholdCrossedNotification.json
    ${body}=    Format String    ${template}    thresholdId=${thresholdId}    objectInstanceId=${objectInstanceIds}
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

Get Individual Performance Report
    Log    Trying to get a performance report present in the NFV-MANOM
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}/reports/${reportId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Get Individual Performance Report with invalid resource endpoint
    Log    Trying to get a performance report with invalid resource endpoint
    Set Headers    {"Accept": "${ACCEPT_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}/reports/${erroneousReportId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Post request for Individual Performance Report
    Log    Trying to create new performance report
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    POST    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}/reports/${newReportId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Put request for Individual Performance Report
    Log    Trying to update performance report
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}
    ${origOutput}=    Output    response
    Set Suite Variable    ${origResponse}    ${origOutput}
    PUT    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}/reports/${reportId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}
    
Send Patch request for Individual Performance Report
    Log    Trying to update performance report
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    GET    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}
    ${origOutput}=    Output    response
    Set Suite Variable    ${origResponse}    ${origOutput}
    PATCH    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}/reports/${reportId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

Send Delete request for Individual Performance Report
    Log    Trying to delete performance report   
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":${AUTHORIZATION_TOKEN}"}
    DELETE    ${apiRoot}/${apiName}/${apiMajorVersion}/pm_jobs/${pmJobId}/reports/${reportId}
    ${output}=    Output    response
    Set Suite Variable    ${response}    ${output}

POST API Version
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Post    ${apiRoot}/${apiName}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
GET API Version
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
PUT API Version
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
PATCH API Version
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
DELETE API Version
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
POST API Version with apiMajorVersion
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Post    ${apiRoot}/${apiName}/${apiMajorVersion} /api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
GET API Version with apiMajorVersion
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion} /api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
PUT API Version with apiMajorVersion
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Put    ${apiRoot}/${apiName}/${apiMajorVersion} /api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
PATCH API Version with apiMajorVersion
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Patch    ${apiRoot}/${apiName}/${apiMajorVersion} /api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 
	
DELETE API Version with apiMajorVersion
    Set Headers    {"Accept":"${ACCEPT_JSON}"} 
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"${AUTHORIZATION_HEADER}":"${AUTHORIZATION_TOKEN}"}
    Delete    ${apiRoot}/${apiName}/${apiMajorVersion} /api_versions
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse} 

Trigger the availability of Performance Information (external action) 
    #do nothing
    Log    do nothing

Trigger the cross of Performance Threshold (external action) 
    #do nothing
    Log    do nothing   
  
Check Performance Information Available Notification Http POST Request Body Json Schema Is    
    [Arguments]    ${element}
    ${schema}=	Get File	schemas/${element}.schema.json
    Configure Notification Forward    ${schema}    ${callback_endpoint}    ${callback_endpoint_fwd}

Check Performance Information Available Notification Http POST Request Body notificationType attribute Is
    [Arguments]    ${type}
    Configure Notification Performance Information Available Handler    ${callback_endpoint_fwd}    ${type}
    Wait Until Keyword Succeeds    ${total_polling_time}   ${polling_interval}   Verify Mock Expectation    ${notification_request}
    Clear Requests    ${callback_endpoint}
    Clear Requests    ${callback_endpoint_fwd}

Check Threshold Crossed Notification Http POST Request Body Json Schema Is    
    [Arguments]    ${element}
    ${schema}=	Get File	schemas/${element}.schema.json
    Configure Notification Forward    ${schema}    ${callback_endpoint}    ${callback_endpoint_fwd}

Check Threshold Crossed Notification Http POST Request Body notificationType attribute Is
    [Arguments]    ${type}
    Configure Notification Threshold Crossed Handler    ${callback_endpoint_fwd}    ${type}
    Wait Until Keyword Succeeds    ${total_polling_time}   ${polling_interval}   Verify Mock Expectation    ${notification_request}
    Clear Requests    ${callback_endpoint}
    Clear Requests    ${callback_endpoint_fwd}
    
Check Threshold Crossed Notification Http POST Request Body changeType attribute Is
    [Arguments]    ${type}
    #do nothing
    Log    do nothing 
    
Configure Notification Performance Information Available Handler
    [Arguments]    ${endpoint}    ${type}
    ${json}=    evaluate    {}
    set to dictionary    ${json}    notificationType    ${type}    
    ${BODY}=    evaluate    json.dumps(${json})    json
    Log  Creating mock request and response to handle status notification
    &{req}=  Create Mock Request Matcher	POST  ${endpoint}  body_type="JSON"    body=${BODY}
    Set Global Variable    ${notification_request}    ${req}   
    &{notification_response}=  Create Mock Response    status_code=204
    Create Mock Expectation  ${notification_request}  ${notification_response}

Configure Notification Threshold Crossed Handler
    [Arguments]    ${endpoint}    ${type}
    ${json}=    evaluate    {}
    set to dictionary   ${json}    notificationType    ${type}
    ${BODY}=    evaluate    json.dumps(${json})    json
    Log  Creating mock request and response to handle status notification
    &{req}=  Create Mock Request Matcher	POST  ${endpoint}  body_type="JSON"    body=${BODY}
    Set Global Variable    ${notification_request}    ${req}   
    &{notification_response}=  Create Mock Response    status_code=204
    Create Mock Expectation  ${notification_request}  ${notification_response}
  
Configure Notification Forward
    [Arguments]    ${schema}    ${endpoint}    ${endpoint_fwd}    
    Log  Creating mock Http POST forward to handle ${schema}
    &{notification_tmp}=  Create Mock Request Matcher	POST  ${endpoint}  body_type="JSON_SCHEMA"    body=${schema}
    &{notification_fwd}=  Create Mock Http Forward	${endpoint_fwd}
    Create Mock Expectation With Http Forward  ${notification_tmp}  ${notification_fwd}

Create Sessions
    Start Process  java  -jar  ${MOCK_SERVER_JAR}  -serverPort  ${callback_port}  alias=mockInstance
    Wait For Process  handle=mockInstance  timeout=5s  on_timeout=continue
    Create Mock Session  ${callback_uri}
