*** Settings ***
Resource    FaultManagement-APIKeyword.robot  

*** Test Cases ***
Post Individual Subscription - Method not implemented
    [Documentation]    Test ID: 8.3.3.4.1
    ...    Test title: Post Individual Subscription - Method not implemented
    ...    Test objective: The objective is to test that POST method is not allowed for fault management subscription on NFV-MANO  
    ...    Pre-conditions: none
    ...    Reference: clause 7.5.6.3.1 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability:  none
    ...    Post-Conditions:  none
    POST Individual Subscription
    Check HTTP Response Status Code Is    405

Get Information about an individual subscription
    [Documentation]    Test ID: 8.3.3.4.2
    ...    Test title: Get Information about an individual subscription
    ...    Test objective: The objective is to read an individual subscription from NFV-MANO alarms subscribed by the client and perform a JSON schema and content validation of the returned fault management individual subscription data structure
    ...    Pre-conditions: The subscription with the given id exists
    ...   Reference: clause 7.5.6.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability:   none
    ...    Post-Conditions:  none
    GET Individual Subscription
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    FmSubscription
    
Get Information about an individual subscription - Not Found
    [Documentation]    Test ID: 8.3.3.4.3
    ...    Test title: Get Information about an individual subscription - Not Found
    ...    Test objective: The objective is to test the retrieval of individual subscription from NFV-MANO alarms fails when the resource is not present.
    ...    Pre-conditions: none
    ...    Reference: clause 7.5.6.3.2 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Individual Subscription
    Check HTTP Response Status Code Is    404

PUT an individual subscription - Method not implemented
    [Documentation]    Test ID: 8.3.3.4.4
    ...    Test title:PUT an individual subscription - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not allowed for fault management individual subscription on VNF  
    ...    Pre-conditions:  none
    ...    Reference: clause 7.5.6.3.3 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability:  none
    ...    Post-Conditions:  none
    PUT Individual Subscription
    Check HTTP Response Status Code Is    405

PATCH an individual subscription - Method not implemented
    [Documentation]    Test ID: 8.3.3.4.5
    ...    Test title:PATCH an individual subscription - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not allowed for fault management individual subscription on VNF  
    ...    Pre-conditions:  none
    ...    Reference: clause 7.5.6.3.4 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability:  none
    ...    Post-Conditions:  none
    PATCH Individual Subscription
    Check HTTP Response Status Code Is    405
    
DELETE an individual subscription
    [Documentation]    Test ID: 8.3.3.4.6
    ...    Test title:DELETE an individual subscription
    ...    Test objective: The objective is to test that DELETE method removes individual subscription on VNF   
    ...    Pre-conditions: The Subsbcription already exists
    ...    Reference: clause 7.5.6.3.5 - ETSI GS NFV-SOL 009 [7] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability:  none
    ...    Post-Conditions:  subscription is deleted
    DELETE Individual Subscription
    Check HTTP Response Status Code Is    204
    Check Individual Subscription deleted