*** Settings ***
Resource    VnfSnapshotPackageManagementKeywords.robot

*** Test Cases ***
POST VNF Snapshot Packages - Method not implemented
    [Documentation]    Test ID: 7.3.8.2.1
    ...    Test title: POST VNF Snapshot Packages - Method not implemented
    ...    Test objective: The objective is to test that POST method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 12.4.2.3.1 - ETSI GS NFV-SOL 003 [1] v3.6.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    POST VNF Snapshot Packages
    Check HTTP Response Status Code Is    405

GET information about multiple VNF Snapshot Packages  
    [Documentation]    Test ID: 7.3.8.2.2
    ...    Test title: GET information about multiple VNF Snapshot Packages
    ...    Test objective: The objective is to get information about multiples VNF Snapshot Packages
    ...    Pre-conditions: none
    ...    Reference: Clause 12.4.2.3.2 - ETSI GS NFV-SOL 003 [1] v3.6.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple VNF Snapshot Packages
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    VnfSnapshotPkgInfos
    
GET information about multiple VNF Snapshot Packages Bad Request Invalid attribute-based filtering parameters
    [Documentation]    Test ID: 7.3.8.2.3
    ...    Test title: GET information about multiple VNF Snapshot Packages Bad Request Invalid attribute-based filtering parameters
    ...    Test objective: The objective is to get information about multiples VNF Snapshot Packages with Invalid attribute-based filtering parameters
    ...    Pre-conditions: none
    ...    Reference: Clause 12.4.2.3.2 - ETSI GS NFV-SOL 003 [1] v3.6.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple VNF Snapshot Packages with bad attribute
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is   ProblemDetails

GET information about multiple VNF Snapshot Packages Bad Request Invalid attribute selector
    [Documentation]    Test ID: 7.3.8.2.4
    ...    Test title: GET information about multiple VNF Snapshot Packages Bad Request Invalid attribute selector
    ...    Test objective: The objective is to get information about multiples VNF Snapshot Packages with Invalid attribute-based filtering parameters
    ...    Pre-conditions: none
    ...    Reference: Clause 12.4.2.3.2 - ETSI GS NFV-SOL 003 [1] v3.6.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple VNF Snapshot Packages with bad filter
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is   ProblemDetails

GET information about multiple VNF Snapshot Packages with "all_fields" attribute selector
    [Documentation]    Test ID: 7.3.8.2.5
    ...    Test title: GET information about multiple VNF Snapshot Packages with "all_fields" attribute selector
    ...    Test objective: The objective is to query information about multiple VNF Snapshot Packages
    ...    Pre-conditions:  none
    ...    Reference: Clause 12.4.2.3.2 - ETSI GS NFV-SOL 003 [1] v3.6.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple VNF Snapshot Packages with all_fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    VnfSnapshotPkgInfos

GET information about multiple VNF Snapshot Packages with "exclude_default" attribute selector
    [Documentation]    Test ID: 7.3.8.2.6
    ...    Test title: GET information about multiple VNF Snapshot Packages with "exclude_default" attribute selector
    ...    Test objective: The objective is to query information about multiple VNF Snapshot Packages
    ...    Pre-conditions:  none
    ...    Reference: Clause 12.4.2.3.2 - ETSI GS NFV-SOL 003 [1] v3.6.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple VNF Snapshot Packages with exclude_default attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    VnfSnapshotPkgInfos
    
GET information about multiple VNF Snapshot Packages with "fields" attribute selector
    [Documentation]    Test ID: 7.3.8.2.7
    ...    Test title: GET information about multiple VNF Snapshot Packages with "fields" attribute selector
    ...    Test objective: The objective is to query information about multiple VNF Snapshot Packages
    ...    Pre-conditions:  none
    ...    Reference: Clause 12.4.2.3.2 - ETSI GS NFV-SOL 003 [1] v3.6.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple VNF Snapshot Packages with fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    VnfSnapshotPkgInfos

GET information about multiple VNF Snapshot Packages with "exclude_default" and "fields" attribute selector
    [Documentation]    Test ID: 7.3.8.2.8
    ...    Test title: GET information about multiple VNF Snapshot Packages with "exclude_default" and "fields" attribute selector
    ...    Test objective: The objective is to query information about multiple VNF Snapshot Packages
    ...    Pre-conditions:  none
    ...    Reference: Clause 12.4.2.3.2 - ETSI GS NFV-SOL 003 [1] v3.6.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple VNF Snapshot Packages with exclude_default and fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    VnfSnapshotPkgInfos
    
GET information about multiple VNF Snapshot Packages with "exclude_fields" attribute selector
    [Documentation]    Test ID: 7.3.8.2.9
    ...    Test title: GET information about multiple VNF Snapshot Packages with "exclude_fields" attribute selector
    ...    Test objective: The objective is to query information about multiple VNF Snapshot Packages
    ...    Pre-conditions:  none
    ...    Reference: Clause 12.4.2.3.2 - ETSI GS NFV-SOL 003 [1] v3.6.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple VNF Snapshot Packages with exclude_fields attribute selector
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    VnfSnapshotPkgInfos  
    
GET VNF Snapshot Packages - Bad Request Response too Big
    [Documentation]    Test ID: 7.3.8.2.10
    ...    Test title: GET VNF Snapshot Packages - Bad Request Response too Big
    ...    Test objective: The objective is test that the retrieval of existing VNF Snapshot Packages list fails because response is too big, and perform the JSON schema validation of the failed operation HTTP response.
    ...    Pre-conditions: none
    ...    Reference: Clause 12.4.2.3.2 - ETSI GS NFV-SOL 003 [1] v3.6.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: NFVO does not support paged response.
    ...    Post-Conditions: none 
    GET VNF Snapshot Packages without Paging support
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is    ProblemDetails

GET VNF Snapshot Packages as Paged Response
    [Documentation]    Test ID: 7.3.8.2.11
    ...    Test title: GET VNF Snapshot Packages as Paged Response
    ...    Test objective: The objective is to test that GET method retrieves the list of existing VNF Snapshot Packages as paged response.
    ...    Pre-conditions: none
    ...    Reference: Clause 12.4.2.3.2 - ETSI GS NFV-SOL 003 [1] v3.6.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: NFVO supports paged response.
    ...    Post-Conditions: none    
    GET VNF Snapshot Packages with Paging support
    Check HTTP Response Status Code Is  200
    Check HTTP Response Header Contains Link
        
PUT VNF Snapshot Packages - Method not implemented
    [Documentation]    Test ID: 7.3.8.2.12
    ...    Test title: PUT VNF Snapshot Packages - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not implemented
    ...    Pre-conditions:  none
    ...    Reference: Clause 12.4.2.3.3 - ETSI GS NFV-SOL 003 [1] v3.6.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    PUT VNF Snapshot Packages
    Check HTTP Response Status Code Is    405

PATCH VNF Snapshot Packages - Method not implemented
    [Documentation]    Test ID: 7.3.8.2.13
    ...    Test title: PATCH VNF Snapshot Packages - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not implemented
    ...    Pre-conditions: none 
    ...    Reference: Clause 12.4.2.3.4 - ETSI GS NFV-SOL 003 [1] v3.6.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH VNF Snapshot Packages
    Check HTTP Response Status Code Is    405

DELETE VNF Snapshot Packages - Method not implemented
    [Documentation]    Test ID: 7.3.8.2.14
    ...    Test title: DELETE VNF Snapshot Packages - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not implemented
    ...    Pre-conditions: none 
    ...    Reference: Clause 12.4.2.3.5 - ETSI GS NFV-SOL 003 [1] v3.6.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: VNF snapshot package is not deleted
    DELETE VNF Snapshot Packages
    Check HTTP Response Status Code Is    405
    
GET information about multiple VNF Snapshot Packages using filter
    [Documentation]    Test ID: 7.3.8.2.15
    ...    Test title: GET information about multiple VNF Snapshot Packages using filter
    ...    Test objective: The objective is to get information about multiples VNF Snapshot Packages using filter
    ...    Pre-conditions: none
    ...    Reference: Clause 12.4.2.3.2 - ETSI GS NFV-SOL 003 [1] v3.6.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET multiple VNF Snapshot Packages using filter
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    VnfSnapshotPkgInfos
