*** Settings ***
Resource    VnfSnapshotPackageManagementKeywords.robot 

*** Test Cases ***
POST Individual VNF Snapshot Package - Method not implemented
    [Documentation]    Test ID: 7.3.8.3.1
    ...    Test title: POST Individual VNF Snapshot Package - Method not implemented
    ...    Test objective: The objective is to test that POST method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 12.4.3.3.1 - ETSI GS NFV-SOL 003 [1] v3.6.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    POST individual VNF Snapshot Package
    Check HTTP Response Status Code Is    405
    
GET Information about an individual VNF Snapshot Package - SUCCESSFUL
    [Documentation]    Test ID: 7.3.8.3.2
    ...    Test title: GET Information about an individual VNF Snapshot Package - SUCCESSFUL
    ...    Test objective: The objective is to query information about a VNF Snapshot Package resource
    ...    Pre-conditions: none
    ...    Reference: Clause 12.4.3.3.2 - ETSI GS NFV-SOL 003 [1] v3.6.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET individual VNF Snapshot Package
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    VnfSnapshotPkgInfo
        
GET Information about an individual VNF Snapshot Package - NOT FOUND
    [Documentation]    Test ID: 7.3.8.3.3
    ...    Test title: GET Information about an individual VNF Snapshot Package - NOT FOUND
    ...    Test objective: The objective is to test that the retrieval of individual VNF Snapshot Package fails when using an invalid resource identifier.
    ...    Pre-conditions: At least one individual VNF Snapshot Package is available in the NFV-MANO.
    ...    Reference: Clause 12.4.3.3.2 - ETSI GS NFV-SOL 003 [1] v3.6.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Individual VNF Snapshot Package with Invalid URI
    Check HTTP Response Status Code Is    404
    Check HTTP Response Body Json Schema Is   ProblemDetails

PUT Individual VNF Snapshot Package - Method not implemented 
    [Documentation]    Test ID: 7.3.8.3.4
    ...    Test title: PUT Individual VNF Snapshot Package - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 12.4.3.3.3 - ETSI GS NFV-SOL 003 [1] v3.6.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: VNF Snapshot Package not modified
    PUT individual VNF Snapshot Package
    Check HTTP Response Status Code Is    405

PATCH Individual VNF Snapshot Package - Method Not implemented
    [Documentation]    Test ID: 7.3.8.3.5
    ...    Test title: PATCH Individual VNF Snapshot Package
    ...    Test objective: The objective is to test that PATCH method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 12.4.3.3.4 - ETSI GS NFV-SOL 003 [1] v3.6.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: VNF Snapshot Package modified
    PATCH individual VNF Snapshot Package
    Check HTTP Response Status Code Is    405

DELETE Individual VNF Snapshot Package - Method Not implemented 
    [Documentation]    Test ID: 7.3.8.3.6
    ...    Test title: DELETE Individual VNF Snapshot Package - Method Not implemented
    ...    Test objective: The objective is to test that DELETE method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 12.4.3.3.5 - ETSI GS NFV-SOL 003 [1] v3.6.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: VNF Snapshot Package deleted
    DELETE individual VNF Snapshot Package
    Check HTTP Response Status Code Is    405