*** Settings ***
Resource    VnfLcmMntOperationKeywords.robot 

*** Test Cases ***
POST Individual VNF Snapshot - Method not implemented
    [Documentation]    Test ID: 7.3.1.41.1
    ...    Test title: POST Individual VNF Snapshot - Method not implemented
    ...    Test objective: The objective is to test that POST method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.24.3.1 - ETSI GS NFV-SOL 003 [1] v3.6.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    POST individual VNF Snapshot
    Check HTTP Response Status Code Is    405
    
GET Information about an individual VNF Snapshot - SUCCESSFUL
    [Documentation]    Test ID: 7.3.1.41.2
    ...    Test title: GET Information about an individual VNF Snapshot - SUCCESSFUL
    ...    Test objective: The objective is to GET information about an individual VNF Snapshot
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.24.3.2 - ETSI GS NFV-SOL 003 [1] v3.6.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    GET individual VNF Snapshot
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    VnfSnapshotInfo
        
GET Information about an individual VNF Snapshot - NOT FOUND
    [Documentation]    Test ID: 7.3.1.41.3
    ...    Test title: GET Information about an individual VNF Snapshot - NOT FOUND
    ...    Test objective: The objective is to test that the retrieval of individual VNF Snapshot fails when using an invalid resource identifier.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.24.3.2 - ETSI GS NFV-SOL 003 [1] v3.6.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Individual VNF Snapshot with Invalid URI
    Check HTTP Response Status Code Is    404
    Check HTTP Response Body Json Schema Is   ProblemDetails

PUT Individual VNF Snapshot - Method not implemented 
    [Documentation]    Test ID: 7.3.1.41.4
    ...    Test title: PUT Individual VNF Snapshot - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.24.3.3 - ETSI GS NFV-SOL 003 [1] v3.6.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: VNF Snapshot not modified
    PUT individual VNF Snapshot
    Check HTTP Response Status Code Is    405

PATCH Individual VNF Snapshot - Success
    [Documentation]    Test ID: 7.3.1.41.5
    ...    Test title: PATCH Individual VNF Snapshot - Success
    ...    Test objective: The objective is to test that PATCH method successfully modifies an individual VNF Snapshot resource
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.24.3.4 - ETSI GS NFV-SOL 003 [1] v3.6.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: VNF Snapshot modified
    PATCH individual VNF Snapshot
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    VnfSnapshotInfoModifications

PATCH Individual VNF Snapshot - Conflict
    [Documentation]    Test ID: 7.3.1.41.6
    ...    Test title: PATCH Individual VNF Snapshot - Success
    ...    Test objective: The objective is to test that PATCH method cannot modify an individual VNF Snapshot resource due to the fact that another modification is ongoing.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.24.3.4 - ETSI GS NFV-SOL 003 [1] v3.6.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: The Individual VNF Snapshot resource is currently being modified due to an underlying VNF snapshot operation.
    ...    Post-Conditions: none
    PATCH individual VNF Snapshot
    Check HTTP Response Status Code Is    409 
    Check HTTP Response Body Json Schema Is   ProblemDetails

PATCH Individual VNF Snapshot - Precondition Failed
    [Documentation]    Test ID: 7.3.1.41.7
    ...    Test title: PATCH Individual VNF Snapshot - Precondition Failed
    ...    Test objective: The objective is to that the modification of individual VNF Snapshot fails because precondition given in an HTTP request header is not fulfilled due to an ETag mismatch.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.24.3.4 - ETSI GS NFV-SOL 003 [1] v3.6.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: VNF snapshot is not modified
    PATCH individual VNF Snapshot - ETag Mismatch
    Check HTTP Response Status Code Is    412
    Check HTTP Response Body Json Schema Is   ProblemDetails

DELETE Individual VNF Snapshot
    [Documentation]    Test ID: 7.3.1.41.8
    ...    Test title: DELETE Individual VNF Snapshot
    ...    Test objective: The objective is to delete a VNF Snapshot
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.24.3.5 - ETSI GS NFV-SOL 003 [1] v3.6.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: none
    ...    Post-Conditions: VNF Snapshot deleted
    DELETE individual VNF Snapshot
    Check HTTP Response Status Code Is    204
    Check Postcondition VNF Snapshot Resource Is Deleted

DELETE Individual VNF Snapshot - Conflict
    [Documentation]    Test ID: 7.3.1.41.9
    ...    Test title: DELETE Individual VNF Snapshot Conflict
    ...    Test objective: The objective is to verify that The operation cannot be executed currently, due to a conflict with the state of the VNF Snapshot resource.
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.24.3.5 - ETSI GS NFV-SOL 003 [1] v3.6.1
    ...    Config ID: Config_prod_VNFM
    ...    Applicability: VNF snapshot is in use by some operation such as reverting a VNF instance to a VNF snapshot or creating a VNF snapshot package.
    ...    Post-Conditions: none
    DELETE individual VNF Snapshot - CONFLICT
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is    ProblemDetails
    Check Postcondition VNF Snapshot Resource Existence