*** Settings ***
Documentation     This Clause defines the content of the individual NS descriptor, i.e. PNFD content
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt    # Generic Parameters
Resource          NSDManagementKeywords.robot
Library           JSONLibrary
Library           REST    ${NFVO_SCHEMA}://${NFVO_HOST}:${NFVO_PORT}    ssl_verify=false
Library           OperatingSystem

*** Test Cases ***
Get single file PNFD in Plain Format
    [Documentation]    Test ID: 5.3.1.13.1
    ...    Test title: Get single file PNFD in Plain Format
    ...    Test objective: The objective is to test the retrieval of the PNFD in plain format within a PNFD archive and perform a validation that returned content is in plain format
    ...    Pre-conditions: One or more PNFDs are onboarded in the NFVO.
    ...    Reference: Clause 5.4.7a.3.2 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: The PNFD is implemented as a single file
    ...    Post-Conditions: none
    Get single file PNFD in Plain Format
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Content-Type Is    text/plain

Get PNFD in Zip Format
    [Documentation]    Test ID: 5.3.1.13.2
    ...    Test title: Get PNFD in Zip Format
    ...    Test objective: The objective is to test the retrieval of the PNFD in zip format within a PNFD archive and perform a validation that returned content is in zip format
    ...    Pre-conditions: One or more PNFDs are onboarded in the NFVO.
    ...    Reference: Clause 5.4.7a.3.2 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get PNFD in Zip Format
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Content-Type Is    application/zip

Get single file PNFD in Plain or Zip Format 
    [Documentation]    Test ID: 5.3.1.13.3
    ...    Test title: Get single file PNFDin Plain or Zip Format
    ...    Test objective: The objective is to test the retrieval of the single file PNFD within a PNFD archive when requesting Plain or Zip format to NFVO by including both formats in the request, and perform a validation that response is in Plain or Zip format
    ...    Pre-conditions: One or more PNFDs are onboarded in the NFVO.
    ...    Reference: Clause 5.4.7a.3.2 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: The PNFD is implemented as a single file
    ...    Post-Conditions: none
    Get single file PNFD in Plain or Zip Format
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Content-Type Is Any of   text/plain    application/zip
    
Get multi file PNFD in Plain or Zip Format
    [Documentation]    Test ID: 5.3.1.13.4
    ...    Test title: Get multi file PNFD in Plain or Zip Format
    ...    Test objective: The objective is to test the retrieval of the multi file PNFD within a PNFD archive when requesting Plain or Zip format to NFVO by including both formats in the request, and perform a validation that returned content is in Zip format
    ...    Pre-conditions: One or more PNFDs are onboarded in the NFVO.
    ...    Reference: Clause 5.4.7a.3.2 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: The PNFD is implemented as a multi file
    ...    Post-Conditions: none
    Get multi file PNFD in Plain or Zip Format
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Content-Type Is    application/zip

Get multi file PNFD in Plain Format
    [Documentation]    Test ID: 5.3.1.13.5
    ...    Test title: Get multi file PNFD in Plain Format
    ...    Test objective: The objective is to test that the retrieval of the multi file PNFD within a PNFD archive fails when requesting it in Plain format, and perform a validation of the JSON schema validation of the failed operation HTTP response
    ...    Pre-conditions: One or more PNFDs are onboarded in the NFVO.
    ...    Reference: Clause 5.4.7a.3.2 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: The PNFD is implemented as a multi file
    ...    Post-Conditions: none
    Get multi file PNFD in Plain Format
    Check HTTP Response Status Code Is    406
    Check HTTP Response Body Json Schema Is   ProblemDetails

Get PNFD Content with invalid resource identifier
    [Documentation]    Test ID: 5.3.1.13.6
    ...    Test title: Get PNFD Content with invalid resource identifier
    ...    Test objective: The objective is to test that the retrieval of the PNFD within a PNFD archive fails when using an invalid resource identifier
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.7a.3.2 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get PNFD with invalid resource identifier
    Check HTTP Response Status Code Is    404
    Check HTTP Response Body Json Schema Is   ProblemDetails

Get PNFD with conflict due to onboarding state
    [Documentation]    Test ID: 5.3.1.13.7
    ...    Test title: Get PNFD with conflict due to onboarding state
    ...    Test objective: The objective is to test that the retrieval of the PNFD within a PNFD archive fails due to a conflict when the PNFD is not in onboarding state ONBOARDED in the NFVO. The test also performs a validation of the JSON schema validation of the failed operation HTTP response
    ...    Pre-conditions: The onboarding state of the PNFD is different from ONBOARDED.
    ...    Reference: Clause 5.4.7a.3.2 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none 
    Get PNFD with conflict due to onboarding state
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is   ProblemDetails    
    
Get PNFD with security information
    [Documentation]    Test ID: 5.3.1.13.8
    ...    Test title: Get PNFD with security information
    ...    Test objective: The objective is to test the retrieval of the PNFD within a PNFD archive shall include in the ZIP archive the security information when requested with "include_signature" parameter
    ...    Pre-conditions: One or more PNFDs are onboarded in the NFVO.
    ...    Reference: Clause 5.4.7a.3.2 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Get PNFD with security information
    Check HTTP Response Status Code Is    200
    Check HTTP Response Header Content-Type Is    application/zip   
    
POST PNFD - Method not implemented
    [Documentation]    Test ID: 5.3.1.13.9
    ...    Test title: POST PNFD - Method not implemented
    ...    Test objective: The objective is to test that POST method is not allowed to create a new PNFD
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.7a.3.1 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send POST Request for PNFD
    Check HTTP Response Status Code Is    405
    
PUT PNFD - Method not implemented
    [Documentation]    Test ID: 5.3.1.13.10
    ...    Test title: PUT PNFD - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not allowed to update PNFD
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.7a.3.3 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send PUT Request for PNFD
    Check HTTP Response Status Code Is    405

PATCH PNFD - Method not implemented
    [Documentation]    Test ID: 5.3.1.13.11
    ...    Test title: PATCH PNFD - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not allowed to update PNFD
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.7a.3.4 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send PATCH Request for PNFD
    Check HTTP Response Status Code Is    405

DELETE PNFD - Method not implemented
    [Documentation]    Test ID: 5.3.1.13.12
    ...    Test title: DELETE PNFD - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not allowed to delete PNFD
    ...    Pre-conditions: none
    ...    Reference: Clause 5.4.7a.3.5 - ETSI GS NFV-SOL 005 [3] v3.5.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send DELETE Request for PNFD
    Check HTTP Response Status Code Is    405