*** Settings ***
Resource    NFVICapacityInformationKeywords.robot

*** Test Cases ***
POST Individual Capacity Threshold
    [Documentation]    Test ID: 5.3.6.4.1
    ...    Test title: POST Individual Capacity Threshold
    ...    Test objective: The objective is to test that POST method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.5.3.1 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    POST Individual Capacity Threshold
    Check HTTP Response Status Code Is    405

GET Individual Capacity Thresholds  
    [Documentation]    Test ID: 5.3.6.4.2
    ...    Test title: GET Capacity Thresholds
    ...    Test objective: The objective is to test that GET method reads information about Individual Capacity Threshold
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.5.3.2 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Individual Capacity Threshold
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    CapacityThresholds
    
GET Individual Capacity Thresholds - NOT FOUND
    [Documentation]    Test ID: 5.3.6.4.3
    ...    Test title: GET Capacity Thresholds - NOT FOUND
    ...    Test objective: The objective is to test that GET method returns an error when using and invalid URI
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.5.3.2 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Individual Capacity Threshold - Invalid URI
    Check HTTP Response Status Code Is    404
    Check HTTP Response Body Json Schema Is    ProblemDetails
    
PUT Individual Capacity Threshold - Method not implemented
    [Documentation]    Test ID: 5.3.6.4.4
    ...    Test title: PUT Capacity Thresholds - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not implemented
    ...    Pre-conditions:  none
    ...    Reference: Clause 10.4.5.3.3 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    PUT Individual Capacity Threshold
    Check HTTP Response Status Code Is    405

PATCH Individual Capacity Threshold - Success
    [Documentation]    Test ID: 5.3.6.4.5
    ...    Test title: PATCH Individual Capacity Threshold - Success
    ...    Test objective: The objective is to test that PATCH method successfully modifies an individual Capacity Threshold resource
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.5.3.3 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: Capacity Threshold modified
    PATCH Individual Capacity Threshold
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    CapacityThresholds
    
PATCH Individual Capacity Threshold - Precondition Failed
    [Documentation]    Test ID: 5.3.6.4.6
    ...    Test title: PATCH Individual Capacity Threshold - Precondition Failed
    ...    Test objective: The objective is to that the modification of individual Capacity Threshold fails because precondition given in an HTTP request header is not fulfilled due to an ETag mismatch.
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.5.3.4 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH Individual Capacity Threshold - ETag Mismatch
    Check HTTP Response Status Code Is    412
    Check HTTP Response Body Json Schema Is   ProblemDetails
    
PATCH Individual Capacity Threshold - Unprocessible Entity
    [Documentation]    Test ID: 5.3.6.4.7
    ...    Test title: PATCH Individual Capacity Threshold - Precondition Failed
    ...    Test objective: The objective is to that the modification of individual Capacity Threshold fails because callbackUri provided in the request body is unreachable.
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.5.3.4 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH Individual Capacity Threshold - Unreachable CallbackURI
    Check HTTP Response Status Code Is    422
    Check HTTP Response Body Json Schema Is   ProblemDetails
    
DELETE Individual Capacity Threshold
    [Documentation]    Test ID: 5.3.6.4.8
    ...    Test title: DELETE Individual Capacity Threshold
    ...    Test objective: The objective is to delete an Individual Capacity Threshold
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.5.3.4 - ETSI GS NFV-SOL 005 [1] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: Capacity threshold is deleted
    DELETE Individual Capacity Threshold
    Check HTTP Response Status Code Is    204
    Check Postcondition resource is deleted