*** Settings ***
Resource    NFVICapacityInformationKeywords.robot

*** Test Cases ***
POST Create Capacity Threshold
    [Documentation]    Test ID: 5.3.6.5.1
    ...    Test title: POST Create Capacity Threshold
    ...    Test objective: The objective is to test that POST method creates a Capacity  Threshold
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.4.3.1 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    POST Create a Capacity Threshold
    Check HTTP Response Status Code Is    201
    Check HTTP Response Body Json Schema Is    CapacityThreshold
    Check HTTP Response Contains Resource URI

POST Create Capacity Threshold - Unprocessible Entity
    [Documentation]    Test ID: 5.3.6.5.2
    ...    Test title: POST Create Capacity Threshold - Unprocessible Entity
    ...    Test objective: The objective is to test that POST method creates a Capacity  Threshold
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.4.3.1 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    POST Create a Capacity Threshold - Unreachable URI
    Check HTTP Response Status Code Is    422
    Check HTTP Response Body Json Schema Is    ProblemDetails

GET Capacity Thresholds  
    [Documentation]    Test ID: 5.3.6.5.3
    ...    Test title: GET Capacity Thresholds
    ...    Test objective: The objective is to GET Capacity Thresholds objects
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.4.3.2 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Capacity Thresholds
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    CapacityThresholds

GET Capacity Thresholds - Filter
    [Documentation]    Test ID: 5.3.6.5.4
    ...    Test title: GET Capacity Thresholds - Filter
    ...    Test objective: The objective is to GET Capacity Thresholds objects using filter
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.4.3.2 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Capacity Thresholds using filter
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is    CapacityThresholds
     
GET Capacity Thresholds Bad Request Invalid attribute-based filtering parameters
    [Documentation]    Test ID: 5.3.6.5.5
    ...    Test title: GET Capacity Thresholds Bad Request Invalid attribute-based filtering parameters
    ...    Test objective: The objective is to get information about Capacity Thresholds with Invalid attribute-based filtering parameters
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.4.3.2 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Capacity Thresholds using invalid filter
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is   ProblemDetails

GET Capacity Thresholds - Bad Request Response too Big
    [Documentation]    Test ID: 5.3.6.5.6
    ...    Test title: GET Capacity Thresholds - Bad Request Response too Big
    ...    Test objective: The objective is test that the retrieval of existing Capacity Thresholds list fails because response is too big, and perform the JSON schema validation of the failed operation HTTP response.
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.4.3.2 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: NFVO does not support paged response.
    ...    Post-Conditions: none 
    GET Capacity Thresholds without Paging support
    Check HTTP Response Status Code Is    400
    Check HTTP Response Body Json Schema Is    ProblemDetails

GET Capacity Thresholds as Paged Response
    [Documentation]    Test ID: 5.3.6.5.7
    ...    Test title: GET Capacity Thresholds as Paged Response
    ...    Test objective: The objective is to test that GET method retrieves the list of existing Capacity Thresholds as paged response.
    ...    Pre-conditions: none
    ...    Reference: Clause 10.4.4.3.2 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: NFVO supports paged response.
    ...    Post-Conditions: none    
    GET Capacity Thresholds with Paging support
    Check HTTP Response Status Code Is  200
    Check HTTP Response Header Contains Link
        
PUT Capacity Thresholds - Method not implemented
    [Documentation]    Test ID: 5.3.6.5.8
    ...    Test title: PUT Capacity Thresholds - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not implemented
    ...    Pre-conditions:  none
    ...    Reference: Clause 10.4.4.3.3 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    PUT Capacity Thresholds
    Check HTTP Response Status Code Is    405

PATCH Capacity Thresholds - Method not implemented
    [Documentation]    Test ID: 5.3.6.5.9
    ...    Test title: PATCH Capacity Thresholds - Method not implemented
    ...    Test objective: The objective is to test that PATCH method is not implemented
    ...    Pre-conditions: none 
    ...    Reference: Clause 10.4.4.3.4 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH Capacity Thresholds
    Check HTTP Response Status Code Is    405

DELETE Capacity Thresholds - Method not implemented
    [Documentation]    Test ID: 5.3.6.5.10
    ...    Test title: DELETE Capacity Thresholds - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not implemented
    ...    Pre-conditions: none 
    ...    Reference: Clause 10.4.4.3.5 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    DELETE Capacity Thresholds
    Check HTTP Response Status Code Is    405
