*** Settings ***
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt
Library           REST    ${NFVMANO_SCHEMA}://${NFVMANO_HOST}:${NFVMANO_PORT}    ssl_verify=false
Library           OperatingSystem
Library           JSONLibrary
Library           String
Suite Setup    Check resource existence and get CallbackUri

*** Test Cases ***
Information Changed Notification
    [Documentation]    Test ID: 8.3.1.14.1
    ...    Test title: Information Changed Notification
    ...    Test objective: The objective is to test that Information Changed Notification is delivered with success to the notification consumer
    ...    Pre-conditions: A subscription for information availability notification is available in the NFV-MANO.
    ...    Reference: clause 5.5.6.3.1 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    POST Information Changed Notification
    Check HTTP Response Status Code Is    204
    
Change State Notification
    [Documentation]    Test ID: 8.3.1.14.2
    ...    Test title: Change State Notification
    ...    Test objective: The objective is to test that Change State Notification is delivered with success to the notification consumer
    ...    Pre-conditions: A subscription for change state notification is available in the NFV-MANO.
    ...    Reference: clause 5.5.6.3.1 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_Notif_Endpoint
    ...    Applicability: none
    ...    Post-Conditions: none 
    POST Change State Notification
    Check HTTP Response Status Code Is    204
    
*** Keywords ***
Check resource existence and get CallbackUri
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    Get    ${apiRoot}/${apiName}/${apiMajorVersion}/subscriptions/${subscriptionId}
    Integer    response status    200
    Validate Json    response body    CimSubscription.schema.json
    Set Global Variable    ${callbackResp}    response body callbackUri

Check HTTP Response Status Code Is
    [Arguments]    ${expected_status}    
    Should Be Equal As Strings    ${response['status']}    ${expected_status}
    Log    Status code validated 

Post Information Changed Notification
    log    Trying to perform a POST to get notification
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    ${template} =    Get File    jsons/InformationChangedNotification.json  
    ${body}=    Format String    ${template}    subscriptionId=${subscriptionId}
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}

Post Change State Notification
    log    Trying to perform a POST to get notification
    Set Headers  {"Accept":"${ACCEPT_JSON}"}  
    Set Headers  {"Content-Type": "${CONTENT_TYPE_JSON}"}
    Run Keyword If    ${AUTH_USAGE} == 1    Set Headers    {"Authorization":"${AUTHORIZATION}"}
    ${template} =    Get File    jsons/ChangeStateNotification.json  
    ${body}=    Format String    ${template}    subscriptionId=${subscriptionId}    changeStateOpOccId=${changeStateOpOccId}
    Post    ${callbackResp}    ${body}
    ${outputResponse}=    Output    response
	Set Global Variable    ${response}    ${outputResponse}
