*** Settings ***
Library           JSONSchemaLibrary    schemas/
Resource          environment/variables.txt
Library           JSONLibrary
Library           OperatingSystem
Resource          NFVMANOCimKeywords.robot
Library           REST    ${NFVMANO_SCHEMA}://${NFVMANO_HOST}:${NFVMANO_PORT}    ssl_verify=false
Library           MockServerLibrary

*** Test Cases ***
POST NFV-MANO entity - Method not implemented
    [Documentation]    Test ID: 8.3.1.1.1
    ...    Test title: POST NFV-MANO entity - Method not implemented
    ...    Test objective: The objective is to test that POST method is not allowed to create an NFV-MANO Entity.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.3.3.1 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Post request for NFV-MANO Entity
    Check HTTP Response Status Code Is    405

GET NFV-MANO entity
    [Documentation]    Test ID: 8.3.1.1.2
    ...    Test title: Get NFV-MANO entity
    ...    Test objective: The objective is to test the retrieval of information about an NFV-MANO functional entity by reading the NFV-MANO entity resource and perform a JSON schema and content validation of the collected job data structure.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.3.3.2 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET NFV-MANO entity resource
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   ManoEntity
    
GET NFV-MANO entity - Not Found
    [Documentation]    Test ID: 8.3.1.1.3
    ...    Test title: Get NFV-MANO entity - Not Found
    ...    Test objective: The objective is to test the retrieval of information about an NFV-MANO functional entity by reading the NFV-MANO entity resource fails when the resource is not present.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.3.3.2 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET NFV-MANO entity resource
    Check HTTP Response Status Code Is    404
    
PUT NFV-MANO entity - Method not implemented
    [Documentation]    Test ID: 8.3.1.1.4
    ...    Test title: PUT NFV-MANO entity - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not allowed to update an NFV-MANO Entity.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.3.3.3 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Put request for NFV-MANO Entity
    Check HTTP Response Status Code Is    405

PATCH NFV-MANO entity
    [Documentation]    Test ID: 8.3.1.1.5
    ...    Test title: PATCH NFV-MANO entity
    ...    Test objective: The objective is to test that PATCH method modifies the NFV-MANO entity resource and perform a JSON schema and content validation of the modified response.
    ...    Pre-conditions: NFV-MANO entity resource is already created.
    ...    Reference: clause 5.5.3.3.4 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: The NFV-MANO entity is modified by the operation
    Send Patch request for NFV-MANO Entity
    Check HTTP Response Status Code Is    200
    Check HTTP Response Body Json Schema Is   ManoConfigModifications
    
PATCH NFV-MANO entity - Conflict
    [Documentation]    Test ID: 8.3.1.1.6
    ...    Test title: PATCH NFV-MANO entity - Conflict
    ...    Test objective: The objective is to test that the modification of the NFV-MANO entity resource failed due to a conflict with the state of the NFV-MANO entity resource and perform the JSON schema validation of the failed operation HTTP response.
    ...    Pre-conditions: NFV-MANO entity resource is already created.
    ...    Reference: clause 5.5.3.3.4 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: The NFV-MANO entity is not modified by the operation
    Send Patch request for NFV-MANO Entity
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is   ProblemDetails
    
PATCH NFV-MANO entity - PreCondition Failed
    [Documentation]    Test ID: 8.3.1.1.7
    ...    Test title: PATCH NFV-MANO entity - PreCondition Failed
    ...    Test objective: The objective is to test that the modification of the NFV-MANO entity resource failed because precondition given in an HTTP request header is not fulfilled and perform the JSON schema validation of the failed operation HTTP response.
    ...    Pre-conditions: NFV-MANO entity resource is already created.
    ...    Reference: clause 5.5.3.3.4 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: The NFV-MANO entity is not modified by the operation
    Send Patch request for NFV-MANO Entity
    Check HTTP Response Status Code Is    412
    Check HTTP Response Body Json Schema Is   ProblemDetails
    
DELETE NFV-MANO entity - Method not implemented
    [Documentation]    Test ID: 8.3.1.1.8
    ...    Test title: DELETE NFV-MANO entity - Method not implemented
    ...    Test objective: The objective is to test that DELETE method is not allowed to delete an NFV-MANO Entity.
    ...    Pre-conditions: none
    ...    Reference: clause 5.5.3.3.5 - ETSI GS NFV-SOL 009 [7] v3.3.1
    ...    Config ID: Config_prod_NFV-MANO
    ...    Applicability: none
    ...    Post-Conditions: none
    Send Delete request for NFV-MANO Entity
    Check HTTP Response Status Code Is    405