*** Settings ***
Suite Setup       Create Sessions
Suite Teardown    Terminate All Processes    kill=true
Resource          environment/variables.txt
Library           MockServerLibrary
Library           Process
Library           OperatingSystem
Library           Collections

*** Test Cases ***
NS Instance Usage START Notification
    [Documentation]    Test ID: 9.3.2.3.1
    ...    Test title: NS Instance Usage START Notification
    ...    Test objective: The objective is to test the dispatch of NS Instance Usage Start Notification when the usage of an NS instance is started, and perform a JSON schema and content validation of the delivered notification. The action that triggers the notification under test is an explicit test step, but it is not performed by the test system.
    ...    Pre-conditions: A subscription for NS instance usage notification is available in the NFVO.
    ...    Reference: Clause 8.5.5.3.1 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none 
    Trigger a change in NS instance usage START (external action) 
    Check NS Instance Usage Start Notification Http POST Request Body Json Schema Is    NsInstanceUsageNotification
    Check NS Instance Usage Start Notification Http POST Request Body notificationType attribute Is    NsInstanceUsageNotification
    Check NS Instance Usage Start Notification Http POST Request Body notificationStatus attribute Is    START

NS Instance Usage END Notification
    [Documentation]    Test ID: 9.3.2.3.2
    ...    Test title: NS Instance Usage END Notification
    ...    Test objective: The objective is to test the dispatch of NS Instance Usage End Notification when the usage of an NS instance is ended, and perform a JSON schema and content validation of the delivered notification. The action that triggers the notification under test is an explicit test step, but it is not performed by the test system.
    ...    Pre-conditions: A subscription for NS instance usage notification is available in the NFVO.
    ...    Reference: Clause 8.5.5.3.1 - ETSI GS NFV-SOL 011 [6] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none 
    Trigger a change in NS instance usage END (external action) 
    Check NS Instance Usage End Notification Http POST Request Body Json Schema Is    NsInstanceUsageNotification
    Check NS Instance Usage End Notification Http POST Request Body notificationType attribute Is    NsInstanceUsageNotification
    Check NS Instance Usage End Notification Http POST Request Body notificationStatus attribute Is    END
    
*** Keywords ***
Create Sessions
    Start Process  java  -jar  ${MOCK_SERVER_JAR}  -serverPort  ${callback_port}  alias=mockInstance
    Wait For Process  handle=mockInstance  timeout=5s  on_timeout=continue
    Create Mock Session  ${callback_uri}:${callback_port}
    
Trigger a change in NS instance usage START (external action) 
    #do nothing
    Log    do nothing
    
Trigger a change in NS instance usage END (external action) 
    #do nothing
    Log    do nothing

Configure Notification Forward
    [Arguments]    ${schema}    ${endpoint}    ${endpoint_fwd}    
    Log  Creating mock Http POST forward to handle ${schema}
    &{notification_tmp}=  Create Mock Request Matcher	POST  ${endpoint}  body_type="JSON_SCHEMA"    body=${schema}
    &{notification_fwd}=  Create Mock Http Forward	${endpoint_fwd}
    Create Mock Expectation With Http Forward  ${notification_tmp}  ${notification_fwd}

Configure Notification NS Instance Usage Start Handler
    [Arguments]    ${endpoint}    ${type}    ${status}
    ${json}=    evaluate    {}
    set to dictionary   ${json}    notificationType    ${type}    changeType    ${status}
    ${BODY}=    evaluate    json.dumps(${json})    json
    Log  Creating mock request and response to handle status notification
    &{notification_request}=  Create Mock Request Matcher	POST  ${endpoint}  body_type="JSON"    body=${BODY}
    &{notification_response}=  Create Mock Response	headers="Content-Type: application/json"  status_code=204
    Create Mock Expectation  ${notification_request}  ${notification_response}
    
Configure Notification NS Instance Usage End Handler
    [Arguments]    ${endpoint}    ${type}    ${status}
    ${json}=    evaluate    {}
    set to dictionary   ${json}    notificationType    ${type}    changeType    ${status}
    ${BODY}=    evaluate    json.dumps(${json})    json
    Log  Creating mock request and response to handle status notification
    &{notification_request}=  Create Mock Request Matcher	POST  ${endpoint}  body_type="JSON"    body=${BODY}
    &{notification_response}=  Create Mock Response	headers="Content-Type: application/json"  status_code=204
    Create Mock Expectation  ${notification_request}  ${notification_response}
    
Check NS Instance Usage Start Notification Http POST Request Body Json Schema Is 
    [Arguments]    ${element}
    ${schema}=	Get File	schemas/${element}.schema.json
    Configure Notification Forward    ${schema}    ${callback_endpoint}    ${callback_endpoint_fwd}
    
Check NS Instance Usage Start Notification Http POST Request Body notificationType attribute Is
    [Arguments]    ${type}
    Configure Notification NS Instance Usage Start Handler    ${callback_endpoint_fwd}    ${type}    START
    Wait Until Keyword Succeeds    2 min   10 sec   Verify Mock Expectation    ${notification_request}
    Clear Requests    ${callback_endpoint}
    Clear Requests    ${callback_endpoint_fwd}
    
Check NS Instance Usage Start Notification Http POST Request Body notificationStatus attribute Is
    [Arguments]    ${type}
    #do nothing
    Log    do nothing
    
Check NS Instance Usage End Notification Http POST Request Body Json Schema Is 
    [Arguments]    ${element}
    ${schema}=	Get File	schemas/${element}.schema.json
    Configure Notification Forward    ${schema}    ${callback_endpoint}    ${callback_endpoint_fwd}

Check NS Instance Usage End Notification Http POST Request Body notificationType attribute Is
    [Arguments]    ${type}
    Configure Notification NS Instance Usage End Handler    ${callback_endpoint_fwd}    ${type}    START
    Wait Until Keyword Succeeds    2 min   10 sec   Verify Mock Expectation    ${notification_request}
    Clear Requests    ${callback_endpoint}
    Clear Requests    ${callback_endpoint_fwd}
    
Check NS Instance Usage End Notification Http POST Request Body notificationStatus attribute Is
    [Arguments]    ${type}
    #do nothing
    Log    do nothing    