*** Settings ***
Resource    VnfSnapshotPackageManagementKeywords.robot 

*** Test Cases ***
POST Individual VNF Snapshot Package Artifact - Method not implemented
    [Documentation]    Test ID: 5.3.7.10.1
    ...    Test title: POST Individual VNF Snapshot Package Artifact - Method not implemented
    ...    Test objective: The objective is to test that POST method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.10.3.1 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO 
    ...    Applicability: none
    ...    Post-Conditions: none
    POST Individual VNF Snapshot Package Artifact
    Check HTTP Response Status Code Is    405
    
GET Individual VNF Snapshot Package Artifact - Complete File
    [Documentation]    Test ID: 5.3.7.10.2
    ...    Test title: GET Information about an individual VNF Snapshot Package - Complete File
    ...    Test objective: The objective is to fetch the whole content of a VNF snapshot package using GET method.
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.10.3.2 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    GET Individual VNF Snapshot Package Artifact - Complete
    Check HTTP Response Status Code Is    200
    Check HTTP Content-Type Header Is Set For Package Artifact
    
GET Individual VNF Snapshot Package Artifact - Partial Content
    [Documentation]    Test ID: 5.3.7.10.3
    ...    Test title: GET Individual VNF Snapshot Package Artifact - Partial Content
    ...    Test objective: The objective is to fetch partial content of a VNF snapshot package by sending a range request using GET method.
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.10.3.2 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: NFVO supports range requests
    ...    Post-Conditions: none
    GET Individual VNF Snapshot Package Artifact - Range Request
    Check HTTP Response Status Code Is    206
    Check HTTP Content-Type Header Is Set For Package Artifact
    Check HTTP Content-Range Header Is Set
    Check HTTP Content-Length Header Is Set
    
GET Individual VNF Snapshot Package Artifact - Range Request Not Supported
    [Documentation]    Test ID: 5.3.7.10.4
    ...    Test title: GET Information about an individual VNF Snapshot Package - Range Request Not Supported
    ...    Test objective: The objective is to test that the whole content of a VNF snapshot package is delivered even with a range request when NFVO does not support range requests.
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.10.3.2 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: NFVO does not support range requests
    ...    Post-Conditions: none
    GET Individual VNF Snapshot Package Artifact - Range Request
    Check HTTP Response Status Code Is    200
    Check HTTP Content-Type Header Is Set For Package Artifact
    
GET Individual VNF Snapshot Package Artifact - Range Not Satisfiable
    [Documentation]    Test ID: 5.3.7.10.5
    ...    Test title: GET Information about an individual VNF Snapshot Package - Range Not Satisfiable
    ...    Test objective: The objective is to test that an error is returned when the byte range passed in the "Range" header does not match any available byte range in the VNF snapshot package file.
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.10.3.2 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: NFVO supports range requests
    ...    Post-Conditions: none
    GET Individual VNF Snapshot Package Artifact - Invalid Range
    Check HTTP Response Status Code Is    416

GET Individual VNF Snapshot Package Artifact - Conflict
    [Documentation]    Test ID: 5.3.7.10.6
    ...    Test title: GET Information about an individual VNF Snapshot Package - Conflict
    ...    Test objective: The objective is to test that an error is returned when the "state" of the VNF snapshot package has a value different from "AVAILABLE".
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.10.3.2 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: The "state" of the VNF snapshot package has a value different from "AVAILABLE".
    ...    Post-Conditions: none
    GET Individual VNF Snapshot Package Artifact - Not Available
    Check HTTP Response Status Code Is    409
    Check HTTP Response Body Json Schema Is   ProblemDetails

GET Individual VNF Snapshot Package Artifact - External Artifact
    [Documentation]    Test ID: 5.3.7.10.7
    ...    Test title: GET Information about an individual VNF Snapshot Package - External Artifact
    ...    Test objective: The objective is to test that correct response code is returned the referred "Individual VNF Snapshot package artifact" is external to the main VNF snapshot package file created from a build process.
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.10.3.2 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: The "Individual VNF Snapshot package artifact" is external to the main VNF snapshot package file created from a build process.
    ...    Post-Conditions: none
    GET Individual VNF Snapshot Package Artifact - External
    Check HTTP Response Status Code Is    302
    Check HTTP Response Contains Resource URI
    
PUT Individual VNF Snapshot Package Artifact - Method not implemented 
     [Documentation]    Test ID: 5.3.7.10.8
    ...    Test title: PUT Individual VNF Snapshot Package Artifact - Method not implemented
    ...    Test objective: The objective is to test that PUT method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.10.3.3 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: VNF Snapshot Package not modified
    PUT Individual VNF Snapshot Package Artifact
    Check HTTP Response Status Code Is    405

PATCH Individual VNF Snapshot Package Artifact - Method Not implemented
    [Documentation]    Test ID: 5.3.7.10.9
    ...    Test title: PATCH Individual VNF Snapshot Package Artifact
    ...    Test objective: The objective is to test that PATCH method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.10.3.4 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    PATCH Individual VNF Snapshot Package Artifact
    Check HTTP Response Status Code Is    405

DELETE Individual VNF Snapshot Package Artifact - Method Not implemented 
    [Documentation]    Test ID: 5.3.7.10.10
    ...    Test title: DELETE Individual VNF Snapshot Package Artifact - Method Not implemented
    ...    Test objective: The objective is to test that DELETE method is not implemented
    ...    Pre-conditions: none
    ...    Reference: Clause 11.4.10.3.5 - ETSI GS NFV-SOL 005 [3] v3.3.1
    ...    Config ID: Config_prod_NFVO
    ...    Applicability: none
    ...    Post-Conditions: none
    DELETE Individual VNF Snapshot Package Artifact
    Check HTTP Response Status Code Is    405