/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.log.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import javax.annotation.Nullable;
import org.mockserver.formatting.StringFormatter;
import org.mockserver.log.model.LogEntry;
import org.mockserver.model.HttpRequest;
import org.slf4j.event.Level;

public class MessageLogEntry
extends LogEntry {
    private final LogMessageType type;
    private final String messageFormat;
    private final Level logLevel;
    private final Object[] arguments;
    private String message;

    public MessageLogEntry(LogMessageType type, Level logLevel, @Nullable HttpRequest httpRequest, String messageFormat, Object ... arguments) {
        super(httpRequest);
        this.type = type;
        this.messageFormat = messageFormat;
        this.logLevel = logLevel;
        this.arguments = arguments;
    }

    public MessageLogEntry(LogMessageType type, Level logLevel, @Nullable List<HttpRequest> httpRequests, String messageFormat, Object ... arguments) {
        super(httpRequests);
        this.type = type;
        this.messageFormat = messageFormat;
        this.logLevel = logLevel;
        this.arguments = arguments;
    }

    @JsonIgnore
    public String getMessage() {
        if (this.message == null) {
            this.message = StringFormatter.formatLogMessage(this.messageFormat, this.arguments);
        }
        return this.message;
    }

    public String getMessageFormat() {
        return this.messageFormat;
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public LogMessageType getType() {
        return this.type;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public static enum LogMessageType {
        TRACE,
        CLEARED,
        RETRIEVED,
        CREATED_EXPECTATION,
        EXPECTATION_RESPONSE,
        EXPECTATION_MATCHED,
        EXPECTATION_NOT_MATCHED,
        VERIFICATION,
        VERIFICATION_FAILED,
        FORWARDED_REQUEST,
        TEMPLATE_GENERATED,
        SERVER_CONFIGURATION,
        WARN,
        EXCEPTION;

    }
}

